<?php
/* $Id: gallery_image.php,v 1.2 2006/03/10 06:42:37 johnbriggs Exp $ */
/*
    Name: Photo Gallery v2.0
    Author: Steven Waters, John Briggs
    Contributors: Jack Faxon, Stalker, Spike, Bigdumredneck, Elmo
    Copyright  2006 XMBMods.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('header.php');
require_once(ROOT.'include/gallery.functions.inc.php');

loadtemplates(
'img_album_links',
'img_footer',
'img_addimage',
'img_uploadimage',
'img_image',
'img_info',
'img_error',
'img_warn',
'img_user_deleteimage',
'img_moveimage',
'img_multiuploadimage'
);

eval('$css = "'.template('css').'";');

//  Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM $table_imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);
$iid = (isset($iid) ? (int) $iid : 0);

if ($iid != 0) {
    $query = $db->query("SELECT * FROM $table_imgimages WHERE iid = '$iid'");
    if ($db->num_rows($query) == 1) {
        $image = $db->fetch_array($query);
        $image['dateline'] = (int) $image['dateline'];
        $cid = $image['cid'];
    } else {
        eval('echo ("'.template('header').'");');
        gallery_error($lang['img_errornoimage']);
    }
    $db->free_result($query);
    $query = $db->query("SELECT height, width FROM $table_imgimagedata WHERE iid = '$iid'");
    $imageheight = $imagewidth = 0;
    if ($db->num_rows($query) == 1) {
        $imagedata = $db->fetch_array($query);
        $imageheight = $imagedata['height'];
        $imagewidth = $imagedata['width'];
    }
    $db->free_result($query);
}

$cid = (isset($cid) ? (int) $cid : 0);

$query = $db->query("SELECT name, who_view, view_list, status, sub, images, password FROM $table_imgcats WHERE cid = '$cid'");

if ($db->num_rows($query) == 1) {
    $album = $db->fetch_array($query);
    $album['images'] = (int) $album['images'];
    $albumname = stripslashes($album['name']);
} else {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errornoalbum']);
}
$db->free_result($query);

// Check the password for the album.
gallery_pwverify($album['password'], 'gallery_image.php?action=view&amp;iid='.$iid.'#pictop', $cid, true);

$query = $db->query("SELECT name FROM $table_imgcats WHERE cid = '$album[sub]'");
if ($db->num_rows($query) == 1) {
    $owneralbum = $db->fetch_array($query);
    $ownername = stripslashes($owneralbum['name']);
} else {
    $ownername = '';
}

nav('<a href="./gallery.php">'.$gsettings['title'].'</a>');

if ($ownername != '') {
    nav('<a href="./gallery_view_album.php?cid='.$album['sub'].'">'.$ownername.'</a>');
}

nav('<a href="./gallery_view_album.php?cid='.$cid.'">'.$albumname.'</a>');
if ($action == 'add') {
    nav($lang['img_textaddimage']);
} elseif ($action == 'upload') {
    nav($lang['img_textuplimage']);
} elseif ($action == 'multiupload') {
    nav($lang['img_textuplimage']);
} elseif ($action == 'edit') {
    nav($lang['img_texteditimage']);
} elseif ($action == 'move') {
    nav($lang['img_textmovephoto']);
} elseif ($action == 'delete') {
    nav($lang['img_textdeleteimage']);
} elseif ($action == 'view') {
    nav($lang['img_textviewimage']);
}

eval('echo ("'.template('header').'");');

//  Check for permissions to view the gallery
$gallery_viewpermission = privfcheck($gsettings['who_view_gallery'],'');
if (!$gallery_viewpermission) {
    gallery_error($lang['img_errorprivgallery']);
}

switch ($action) {
    case 'add':
        // Check for permissions to add images.
        if (!gallery_addimageperm($cid)) {
            gallery_error($lang['img_errornoaddimage']);
        }

        if (!isset($_POST['addimagesubmit'])) {
            $action = 'add';
            $thing = '&amp;cid='.$cid;
            $title = $lang['img_textaddimage'];
            $readonly = '';
            $image['name'] = '';
            $image['description'] = '';
            $image['url'] = '';
            $image['thumb'] = '';
            $submit = '<input type="submit" name="addimagesubmit" value="'.$lang['textsubmitchanges'].'" class="submit" />';
            $thumb = '';
            if ($gsettings['resize_thumb'] == 'on') {
                $thumb .= '<tr>';
                $thumb .= '<td bgcolor="'.$altbg1.'" class="tablerow" >'.$lang['img_textthumburl'].$lang['img_textoptional'].':</td>';
                $thumb .= '<td bgcolor="'.$altbg2.'" class="tablerow" ><input type="text" name="thumb_url_new" class="text" size="40" value="'.$image['thumb'].'"'.$readonly.' /></td>';
                $thumb .= '</tr>';
            }
            eval('echo ("'.template('img_addimage').'");');

        } elseif ($_POST['addimagesubmit']) {
            $errorlist = array();

            // Validate the name and url
            if (!strlen($name_new) > 0) {
                array_push($errorlist, $lang['img_errornoimagename']);
            }

            if (!strlen($url_new) > 0) {
                array_push($errorlist, $lang['img_errornoimageurl']);
            }

            if (!$SizeArray = GetImageSize($url_new)) {
                array_push($errorlist, $lang['img_errorinvalidfiletype']);
            }

            if ($SizeArray[0] > $SizeArray[1]) {
                // If landscape
                if ($SizeArray[0] > $gsettings['max_image_width'] || $SizeArray[1] > $gsettings['max_image_height']) {
                    eval($lang['img_evalimgtoolarge']);
                    array_push($errorlist, $lang['img_errorimgtoolarge']);
                }
            } else {
                // Portrait, or square
                if ($SizeArray[0] > $gsettings['max_image_height'] || $SizeArray[1] > $gsettings['max_image_width']) {
                    eval($lang['img_evalimgtoolarge']);
                    array_push($errorlist, $lang['img_errorimgtoolarge']);
                }
            }

            // Check the type of the image
            if ($SizeArray[2] != '1' && $SizeArray[2] != '2' && $SizeArray[2] !='3') {
                array_push($errorlist, $lang['img_errorinvalidfiletype']);
            }

            // Check the type of the thumbnail, if present
            $thumb_url_new = (isset($thumb_url_new) ? $thumb_url_new : '');
            if (strlen($thumb_url_new) > 0) {
                if (!$SizeArray = getimagesize($thumb_url_new)) {
                    array_push($errorlist, $lang['img_errorinvalidthumbfiletype']);
                } else {
                    if ($SizeArray[2] != '1' && $SizeArray[2] != '2' && $SizeArray[2] != '3') {
                        array_push($errorlist, $lang['img_errorinvalidthumbfiletype']);
                    }
                }
            }

            // Any errors at this point, just stop and display the messages.
            if (count($errorlist) != 0) {
                gallery_error($errorlist);
            }

            // Validate the size of the image in bytes
            $fp=fopen($url_new,'r');
            $contents=fread($fp,$gsettings['max_image_size']+1);
            fclose($fp);

            if (strlen($contents) > $gsettings['max_image_size']) {
                eval($lang['img_evalfiletoolarge']);
                array_push($errorlist, $lang['img_errorfiletoolarge']);
            }

            if (count($errorlist) != 0) {
                gallery_error($errorlist);
            }
            $name_new = checkInput($name_new, 'no', 'no', '', false);
            $desc_new = checkInput($desc_new, 'no', 'no', '', false);
            $name_new = addslashes(trim($name_new));
            $desc_new = addslashes(trim($desc_new));
            $url_new = addslashes(trim($url_new));
            $dateline_new = time();

            // Insert the row
            $db->query("INSERT INTO $table_imgimages ( iid, cid, author, dateline, thumb, url, upload, name, description ) VALUES ( '', '$cid', '$self[username]', '$dateline_new', 'resize', '$url_new', 'no', '$name_new', '$desc_new')");
            $iid = $db->insert_id();

            // Update the last post info for the album
            $db->query("UPDATE $table_imgcats SET images=images+1, lastpost='$dateline_new|$self[username]' WHERE cid = '$cid'");

            // Now create the thumbnail file if needed.  If a url was provided for a thumb file, use that.
            // Otherwise use the original image file
            if ($gsettings['resize_thumb'] == 'on') {
                //  Create the thumbfile
                switch ($thumb_url_new) {
                    case '':
                        gallery_createthumbrow(stripslashes($url_new), $iid, $cid);
                        break;
                    default:
                        gallery_createthumbrow($thumb_url_new, $iid, $cid);
                        break;
                }
            }
            gallery_info($lang['img_infoimagemsg'],'gallery_view_album.php?cid='.$cid);
        }
        break;

    case 'upload':
        // See if the upload feature is turned on.
        if (!gallery_uploadimageperm($cid)) {
            gallery_error($lang['fnasorry']);
        }

        if (!isset($_POST['uploadimagesubmit'])) {
            $thumb = '<tr>';
            $thumb .= '<td bgcolor="'.$altbg1.'" class="tablerow">'.$lang['img_textthumbfile'].$lang['img_textoptional'].':</td>';
            $thumb .= '<td bgcolor="'.$altbg2.'" class="tablerow"><input type="file" name="thumb" size="40" /></td>';
            $thumb .= '</tr>';
            eval('echo ("'.template('img_uploadimage').'");');

        } elseif ($_POST['uploadimagesubmit']) {
            $attach = $_FILES['attach'];
            if (isset($_FILES['thumb'])) {
                $thumb = $_FILES['thumb'];
            } else {
                $thumb = '';
            }
            $errorlist = gallery_validateupload($name_new, $attach);

            if ($thumb != '' && $thumb['name'] != '') {
                $errorlist = array_merge($errorlist, gallery_validatethumb($thumb));
            }

            if (count($errorlist) != 0) {
                gallery_error($errorlist);
            }

            //  File look good, insert a row into the images table, determine the
            //  name of the file, and move the file.
            $name_new = checkInput($name_new, 'no', 'no', '', false);
            $desc_new = checkInput($desc_new, 'no', 'no', '', false);
            $name_new = addslashes(trim($name_new));
            $desc_new = addslashes(trim($desc_new));
            $dateline_new = time();

            // Insert the row, get the iid.  This will be used to name the uploaded file, so after
            //  the path is determined from the album name, this row will be updated with the new url.
            $db->query("INSERT INTO $table_imgimages ( iid, cid, author, dateline, thumb, upload, name, description ) VALUES ( '', '$cid', '$self[username]', '$dateline_new', 'resize', 'yes', '$name_new', '$desc_new')");
            $iid = $db->insert_id();

            // Update the last post info for the album
            $db->query("UPDATE $table_imgcats SET images=images+1, lastpost='$dateline_new|$self[username]' WHERE cid = '$cid'");

            // Now create the thumbnail file.  If a file was provided use that, otherwise use the original
            // image file
             if ($thumb != '' && $thumb['name'] != '') {
                if (is_uploaded_file($thumb['tmp_name'])) {
                    gallery_createthumbrow($thumb['tmp_name'], $iid, $cid);
                } else {
                    gallery_error($lang['img_errornothumbfile']);
                }
            } else {
                gallery_createthumbrow($attach['tmp_name'], $iid, $cid);
            }

            if (is_uploaded_file($attach['tmp_name'])) {
                $size = GetImageSize($attach['tmp_name']);
                $width = $size[0];
                $height = $size[1];
                $imagetype = $size[2];
                $imagedata = addslashes(fread(fopen($attach['tmp_name'], 'rb'), $attach['size']));
                $imagetype = image_type_to_mime_type($imagetype);
                $db->query("INSERT INTO $table_imgimagedata SET iid='$iid', cid='$cid', width='$width', height='$height', filetype='$imagetype', imagedata='$imagedata'");
                $url = 'gallery.php?action=viewimage&amp;iid='.$iid.'&amp;cid='.$cid;
                $url = addslashes($url);
                $db->query("UPDATE $table_imgimages SET url='$url' WHERE iid='$iid' ");
            } else {
                gallery_error($lang['img_errornofile']);
            }

            gallery_info($lang['img_infoimagemsg'],'gallery_view_album.php?cid='.$cid);
        }
        break;

    case 'multiupload':
        // See if the upload feature is turned on.
        if (!gallery_uploadimageperm($cid)) {
            gallery_error($lang['fnasorry']);
        }

        // Check to see if multi upload is turned on
        if (!$gsettings['multi_upload'] == 'on') {
            gallery_error($lang['fnasorry']);
        }

        // See how many images the user owns, check it against the max number allowed to see how many
        // rows to display in the window.
        if (X_ADMIN) {
            $maxupload = $gsettings['max_upl_mem'];
        } else {
            $number_of_images = $db->result($db->query("SELECT count(iid) FROM $table_imgimages WHERE author = '$self[username]'"), 0);
            $number_left = intval($gsettings['max_img_mem']) - intval($number_of_images);
            $maxupload = min($number_left, $gsettings['max_upl_mem']);
        }

        if (!isset($_POST['uploadimagesubmit'])) {
            $thumb = '<td bgcolor="'.$altbg2.'" class="tablerow">'.$lang['img_textthumbfile'].' '.$lang['img_textoptional'].'</td>';
            $multirows='';
            for ($i=0; $i<$maxupload; $i++) {
                $multirows .= '<tr>';
                $multirows .= '<td bgcolor="'.$altbg2.'"><input type="text" name="name_new'.$i.'" class="text" /></td>';
                $multirows .= '<td bgcolor="'.$altbg2.'"><textarea name="desc_new'.$i.'" cols="30" rows="1" class="textarea"></textarea></td>';
                $multirows .= '<td bgcolor="'.$altbg2.'"><input type="file" name="attach'.$i.'" size="30" /></td>';
                $multirows .= '<td bgcolor="'.$altbg2.'"><input type="file" name="thumb'.$i.'" size="30" /></td>';
                $multirows .= '</tr>';
            }

            eval('echo ("'.template('img_multiuploadimage').'");');

        } elseif (isset($_POST['uploadimagesubmit'])) {
            // Iterate through the list submitted by the user and process each request.
            // First check for errors.
            $errorlist = array();
            for ($i=0; $i<$maxupload; $i++) {
                $name_new = "name_new$i";
                $name_new = "${$name_new}";
                $attach = $_FILES["attach$i"];
                $thumb = $_FILES["thumb$i"];
                isset($attach['name']) ? "$attach[name]" : '';

                if ($name_new != '' || $attach['name'] != '') {
                    $errorlist = array_merge($errorlist, gallery_validateupload($name_new, $attach, $i+1));
                    if ($thumb['name'] != '') {
                        $errorlist = array_merge($errorlist, gallery_validatethumb($thumb, $i+1));
                    }
                }
            }
            // Display the errors, if any
            if (count($errorlist) != 0) {
                gallery_error($errorlist);
            }

            //  Now start back at the beginning and add each image to the album
            for ($i=0; $i<$maxupload; $i++) {
                $name_new = "name_new$i";
                $name_new = "${$name_new}";
                $desc_new = "desc_new$i";
                $desc_new = isset(${$desc_new}) ? "${$desc_new}" : '';
                $attach = $_FILES["attach$i"];
                $thumb = $_FILES["thumb$i"];
                isset($attach) ? "$attach" : '';

                if ($name_new != '') {
                    $name_new = checkInput($name_new, 'no', 'no', '', false);
                    $desc_new = checkInput($desc_new, 'no', 'no', '', false);
                    $name_new = addslashes(trim($name_new));
                    $desc_new = addslashes(trim($desc_new));
                    // need to force a pause, the dateline must be unique
                    sleep(1);
                    $dateline_new = time();

                    // Insert the row, get the iid.  This will be used to name the uploaded file, so after
                    //  the path is determined from the album name, this row will be updated with the new url.
                    $db->query("INSERT INTO $table_imgimages ( iid, cid, author, dateline, thumb, upload, name, description ) VALUES ( '', '$cid', '$self[username]', '$dateline_new', 'resize', 'yes', '$name_new', '$desc_new')");
                    $iid = $db->insert_id();

                    // Update the last post info for the album
                    $db->query("UPDATE $table_imgcats SET images=images+1, lastpost='$dateline_new|$self[username]' WHERE cid = '$cid'");

                    // Now create the thumbnail file.  If a file was provided use that, otherwise use the original
                    // image file
                    if ($thumb != '' && $thumb['name'] != '') {
                        if (is_uploaded_file($thumb['tmp_name'])) {
                            gallery_createthumbrow($thumb['tmp_name'], $iid, $cid);
                        } else {
                            gallery_error($lang['img_errornothumbfile']);
                        }
                    } else {
                        gallery_createthumbrow($attach['tmp_name'], $iid, $cid);
                    }

                    if (is_uploaded_file($attach['tmp_name'])) {
                        $size = GetImageSize($attach['tmp_name']);
                        $width = $size[0];
                        $height = $size[1];
                        $imagetype = $size[2];
                        $imagedata = addslashes(fread(fopen($attach['tmp_name'], 'rb'), $attach['size']));
                        $imagetype = image_type_to_mime_type($imagetype);
                        $db->query("INSERT INTO $table_imgimagedata SET iid='$iid', cid='$cid', width='$width', height='$height', filetype='$imagetype', imagedata='$imagedata'");
                        $url = 'gallery.php?action=viewimage&amp;iid='.$iid.'&amp;cid='.$cid;
                        $url = addslashes($url);
                        $db->query("UPDATE $table_imgimages SET url='$url' WHERE iid='$iid' ");
                    } else {
                        gallery_error($lang['img_errornofile']);
                    }
                }
            }
            gallery_info($lang['img_infoimagesmsg'],'gallery_view_album.php?cid='.$cid);
        }
        break;

    case 'edit':
        // If you have permissions to add images to this album, and you own this image, then
        // you can edit or delete this image.
        if (!gallery_addimageperm($cid)) {
            gallery_error($lang['img_errornoimageupdate']);
        }

        if (X_ADMIN || $self['username'] == $image['author']) {
            // good to go
        } else {
            gallery_error($lang['img_errornoimageupdate']);
        }

        if (!isset($_POST['editimagesubmit'])) {
            $action = 'edit';
            $thing = '&amp;iid='.$iid;
            $title = $lang['img_texteditimage'];
            $readonly = 'READONLY';

            $image['name'] = stripslashes($image['name']);
            $image['description'] = stripslashes($image['description']);
            $image['url'] = stripslashes($image['url']);
            $image['thumb'] = stripslashes($image['thumb']);
            $thumb = '';
            if ($image['thumb'] != 'resize') {
                $thumb .= '<tr>';
                $thumb .= '<td bgcolor="'.$altbg1.'" class="tablerow">'.$lang['img_textthumburl'].':</td>';
                $thumb .= '<td bgcolor="'.$altbg2.'" class="tablerow"><input type="text" name="thumb_url_new" class="text" size="40" value="'.$image['thumb'].'" '.$readonly.' /></td>';
                $thumb .= '</tr>';
            }

            $submit = '<input type="submit" name="editimagesubmit" value="'.$lang['img_texteditimage'].'" class="submit" />';
            eval('echo ("'.template('img_addimage').'");');
        } elseif (isset($_POST['editimagesubmit'])){
            if (!strlen($name_new) > 0) {
                gallery_error($lang['img_errornoimagename']);
            }
            $name_new = checkInput($name_new, 'no', 'no', '', false);
            $desc_new = checkInput($desc_new, 'no', 'no', '', false);
            $name_new = addslashes(trim($name_new));
            $desc_new = addslashes(trim($desc_new));
            $dateline_new = time();

            // Update the row
            $db->query("UPDATE $table_imgimages SET dateline = '$dateline_new', name = '$name_new', description = '$desc_new' WHERE iid = '$iid'");

            // Update the last post info for the album
            $db->query("UPDATE $table_imgcats SET lastpost='$dateline_new|$self[username]' WHERE cid = '$cid'");

            gallery_info($lang['img_infoimageupdate'],'gallery_image.php?action=view&iid='.$iid.'#pictop');
        }
        break;

    case 'move':
        // Check for permissions to move this photo
        $authorization = privfcheck($gsettings['move'],'');
        if ($authorization) {
            if (X_ADMIN || $self['username'] == $image['author']) {
                //  Good to go
            } else {
                gallery_error($lang['img_errornoimageupdate']);
            }
        }

        if (!isset($_POST['moveimagesubmit'])) {
            //  This will display the screen to move the image
            //  This will build the contents of the drop down to select the album to
            //  move to
            $albumlist = gallery_albums();
            $selectalbum = '';

            for($i=0; $i< count($albumlist); $i++) {
                if ($albumlist[$i]['permissions'] == 'write') {
                    $album['name'] = $albumlist[$i]['name'];
                    $album['cid'] = $albumlist[$i]['cid'];
                    $selectalbum = $selectalbum.'<option value="'.$album['cid'].'">'.$album['name'].'</option>';
                }
            }
            eval('echo ("'.template('img_moveimage').'");');

        } elseif (isset($_POST['moveimagesubmit'])) {
            // If this image was uploaded, the url needs to be changed to refer to the new folder

            //  Check for permissions for the new album
            if (!gallery_addimageperm($cid)) {
                gallery_error($lang['img_errornoimageupdate']);
            }

            //
            if ($image['upload'] == 'yes') {
                $image['url'] = 'gallery.php?action=viewimage&amp;iid='.$iid.'&amp;cid='.$album_new;
                $image['url'] = addslashes($image['thumb']);
            }

            // Check to see if the thumb needs to be moved also
            if ($image['thumb'] != 'resize') {
                $image['thumb'] = 'gallery.php?action=viewthumb&amp;iid='.$iid.'&amp;cid='.$album_new;
                $image['thumb'] = addslashes($image['thumb']);
            }

            // Find the current album, decrement the image counter
            $db->query("UPDATE $table_imgcats SET images=images-1 WHERE cid='$cid'");

            // Move the image to the new album
            $db->query("UPDATE $table_imgimages SET cid='$album_new', thumb='$image[thumb]', url='$image[url]' WHERE iid='$iid'");
            $db->query("UPDATE $table_imgimagedata SET cid='$album_new' WHERE iid='$iid'");
            $db->query("UPDATE $table_imgthumbnails SET cid='$album_new' WHERE iid='$iid'");
            // Update the images counter info for the new album
            $db->query("UPDATE $table_imgcats SET images=images+1 WHERE cid='$album_new'");

            gallery_info($lang['img_infoimagemoved'],'gallery_view_album.php?cid='.$album_new);
        }
        break;

    case 'delete':
        // If you have permissions to add images to this album, and you own this image, then
        // you can edit or delete this image.
        if (!gallery_addimageperm($cid)) {
            gallery_error($lang['img_errornoimageupdate']);
        }

        if (X_ADMIN || $self['username'] == $image['author']) {
            // good to go
        } else {
            gallery_error($lang['img_errornoimageupdate']);
        }

        if (!isset($_POST['deleteimagesubmit'])) {
            // This will display the screen to delete the image
            $message = $lang['img_infoconfirmdelimage'];
            eval('echo ("'.template('img_warn').'");');
            eval('echo ("'.template('img_user_deleteimage').'");');

        } elseif (isset($_POST['deleteimagesubmit'])){

            // Delete the row from the images, and all the votes and comments
            $db->query("DELETE FROM $table_imgimages WHERE iid = '$iid'");
            $db->query("DELETE from $table_imgvotes WHERE iid='$iid'");
            $db->query("DELETE from $table_imgcomments WHERE iid='$iid'");
            $db->query("DELETE from $table_imgthumbnails WHERE iid='$iid'");
            $db->query("DELETE from $table_imgimagedata WHERE iid='$iid'");

            // Update the images counter info for the album
            $db->query("UPDATE $table_imgcats SET images=images-1 WHERE cid = '$cid'");

            gallery_info($lang['img_infoimagedel'],'gallery_view_album.php?cid='.$cid);
        }
        break;

    case 'view':
        //  Check for permissions to view the album
        $authorization = gallery_viewalbumperm($cid);
        if (!$authorization) {
            gallery_error($lang['img_errorprivalbum']);
        }

        $dateadded = gmdate($dateformat, $image['dateline']);
        $image['url'] = stripslashes($image['url']);
        $image['name'] = stripslashes($image['name']);
        $image['description'] = stripslashes($image['description']);
        $image['author'] = stripslashes($image['author']);
        $resize = gallery_resize($image['url'], 'image', $imageheight, $imagewidth);
        if ($gsettings['rating'] == 'on') {
            if ($image['votes'] > 0) {
                $num = $image['rate']/(5*$image['votes']);
                $n=$num*5;
                if ($n>='4.5') {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                } elseif ($n>="3.5" && $n<"4.5") {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                } elseif ($n>="2.5" && $n<"3.5") {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                } elseif ($n>="1.5" && $n<"2.5") {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                } elseif ($n>="1" && $n<"1.5") {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                }
            } else {
                $rate = 'None';
            }
        } else {
            $rate = '';
        }

        $query = $db->query("UPDATE $table_imgimages SET views=views+1 WHERE iid='$iid'");

        eval('echo ("'.template('img_image').'");');

        $currentval = $image[$gsettings['image_order']];
        $currentval = addslashes($currentval);
        $nextiid = '';
        $prioriid = '';

        $query = $db->query("SELECT iid, name FROM $table_imgimages WHERE cid='$cid' AND `$gsettings[image_order]`>'$currentval' ORDER BY `$gsettings[image_order]` ASC LIMIT 1");
        $next = $db->fetch_array($query);
        $db->free_result($query);

        if ($next['iid'] != 0) {
            $nextiid = $next['iid'];
            $nextname = stripslashes($next['name']);
        }

        $query = $db->query("SELECT iid, name FROM $table_imgimages WHERE cid='$cid' AND `$gsettings[image_order]`<'$currentval' ORDER BY `$gsettings[image_order]` DESC LIMIT 1");
        $prior = $db->fetch_array($query);
        $db->free_result($query);

        if ($prior['iid'] != 0) {
            $prioriid = $prior['iid'];
            $priorname = stripslashes($prior['name']);
        }

        if ($prioriid != '') {
            $priorlink = '<a href="gallery_image.php?action=view&amp;iid='.$prioriid.'#pictop"><img src="'.$imgdir.'/previous.gif" alt="'.$lang['img_textprior'].'" border=0 /><font class="smalltxt"><b>'.$priorname.'</b></font></a>';
        } else {
            $priorlink = '<img src="'.$imgdir.'/previous2.gif" alt="" border=0 />';
        }

        if ($nextiid != '') {
            $nextlink = '<a href="gallery_image.php?action=view&amp;iid='.$nextiid.'#pictop"><font class="smalltxt"><b>'.$nextname.'</b></font><img src="'.$imgdir.'/next.gif" alt="'.$lang['img_textnext'].'" border=0 /></a>';
        } else {
            $nextlink = '<img src="'.$imgdir.'/next2.gif" alt="" border=0 />';
        }

        // Build the links
        $displaylinks = array();

        if (X_ADMIN) {
            $displaylinks[] = '<a href="gallery_admin.php">'.$lang['img_textadmin'].'</a>';
        }

        // If you have permissions to add images to this album, and you own this image, then
        // you can edit or delete this image.
        if (gallery_addimageperm($cid)) {
            if (X_ADMIN || $self['username'] == $image['author']) {
                $displaylinks[] = '<a href="gallery_image.php?action=edit&amp;iid='.$iid.'">'.$lang['img_texteditimage'].'</a>';
            }
        }

        // If ratings are turned on, and the member hasn't already voted, show the link
        if ($gsettings['rating'] == 'on' && X_MEMBER) {
            $query = $db->query("SELECT username FROM $table_imgvotes WHERE username='$self[username]' AND iid='$iid'");
            $votes = $db->fetch_array($query);
            $db->free_result($query);
            if ($votes['username'] != $self['username']) {
                $displaylinks[] = '<a href="gallery_misc.php?action=rate&amp;iid='.$iid.'">'.$lang['img_textrate'].'</a>';
            }
        }

        // Check for permissions to move this photo
        $authorization = privfcheck($gsettings['move'],'');
        if ($authorization) {
            if (X_ADMIN || $self['username'] == $image['author']) {
                $displaylinks[] = '<a href="gallery_image.php?action=move&amp;iid='.$iid.'">'.$lang['img_textmovephoto'].'</a>';
            }
        }

        // If you have permissions to add images to this album, and you own this image, then
        // you can edit or delete this image.
        if (gallery_addimageperm($cid)) {
            if (X_ADMIN || $self['username'] == $image['author']) {
                $displaylinks[] = '<a href="gallery_image.php?action=delete&amp;iid='.$iid.'">'.$lang['img_textdeleteimage'].'</a>';
            }
        }

        // If printable displays are enabled, show the link
        if ($gsettings['printable'] == 'on') {
            $displaylinks[] = '<a href='.$image['url'].' target=_blank>'.$lang['img_textprintable'].'</a>';
        }

        // If comments are enabled, this will show the prompt to add a new comment.
        if ($gsettings['comments'] == 'on' && X_MEMBER) {
            $displaylinks[] = '<a href="gallery_comments.php?action=reply&amp;cid='.$cid.'&amp;iid='.$iid.'">Comments</a>';
        }

        // If there is more than one image in the album and the slide show is enabled, show the link
        if ($album['images'] > 1 && $gsettings['slideshow'] == 'on') {
            $displaylinks[] = '<a href="gallery_misc.php?action=slideshow&amp;iid='.$iid.'#pictop">'.$lang['img_textslideshow'].'</a>';
        }

        $displaylinks = implode(' | ', $displaylinks);

        eval('echo ("'.template('img_album_links').'");');

        //  This will show the comments, if enabled.
        if ($gsettings['comments'] == 'on') {
            $page = (isset($page) ? (int) $page : 1);
            include "./gallery_view_comments.php";
        }
        break;
}

eval('echo ("'.template('img_footer').'");');
end_time();
eval('echo ("'.template('footer').'");');
?>