<?php
/* $Id: gallery_misc.php,v 1.2 2006/03/10 06:42:37 johnbriggs Exp $ */
/*
    Name: Photo Gallery v2.0
    Author: Steven Waters, John Briggs
    Contributors: Jack Faxon, Stalker, Spike, Bigdumredneck, Elmo
    Copyright  2006 XMBMods.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('header.php');
require_once(ROOT.'include/gallery.functions.inc.php');

loadtemplates(
'img_rate',
'img_error',
'img_footer',
'img_image',
'img_info',
'img_album_links',
'img_slideshow'
);

eval('$css = "'.template('css').'";');

//  Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM $table_imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);

//  Check for permissions to view the gallery
$gallery_viewpermission = privfcheck($gsettings['who_view_gallery'],'');
if (!$gallery_viewpermission) {
    gallery_error($lang['img_errorprivgallery']);
}

$iid = (isset($iid) ? (int) $iid : 0);
if ($iid != 0) {
    $query = $db->query("SELECT * FROM $table_imgimages WHERE iid = '$iid'");
    if ($db->num_rows($query) == 1) {
        $image = $db->fetch_array($query);
        $image['dateline'] = (int) $image['dateline'];
        $cid = $image['cid'];
    } else {
        eval('echo "'.template('header').'";');
        gallery_error($lang['img_errornoimage']);
    }
    $db->free_result($query);
    $query = $db->query("SELECT height, width FROM $table_imgimagedata WHERE iid = '$iid'");
    $imageheight = $imagewidth = 0;
    if ($db->num_rows($query) == 1) {
        $imagedata = $db->fetch_array($query);
        $imageheight = $imagedata['height'];
        $imagewidth = $imagedata['width'];
    }
    $db->free_result($query);
}

//  Retrieve the album settings, store them in an array
$query = $db->query("SELECT * FROM $table_imgcats WHERE cid = '$cid'");
$album = $db->fetch_array($query);
$albumname = stripslashes($album['name']);
$db->free_result($query);

//  Check for permissions to view the album
$authorization = gallery_viewalbumperm($cid);
if (!$authorization) {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errorprivalbum']);
}

nav('<a href="./gallery.php">'.stripslashes($gsettings['title']).'</a>');
nav('<a href="./gallery_view_album.php?cid='.$cid.'">'.$albumname.'</a>');
if ($action == 'rate') {
    nav('<a href="./gallery_image.php?action=view&amp;iid='.$iid.'#pictop">'.$image['name'].'</a>');
    nav($lang['img_textrate']);
} elseif ($action == 'slideshow') {
    nav($lang['img_textslideshow']);
}
eval('echo "'.template('header').'";');

$iid = (isset($iid) ? (int) $iid : 0);

switch ($action) {
    case 'rate':
        // If the ratings aren't turned on, too bad.
        if ($gsettings['rating'] != 'on') {
            gallery_error($lang['img_errornovoteperm']);
        }

        // Check to see if the user has aleady voted for this photo
        if (!X_MEMBER) {
            gallery_error($lang['img_errornovoteperm']);
        } else {
            $query = $db->query("SELECT username FROM $table_imgvotes WHERE username='$self[username]' AND iid='$iid'");
            $votes = $db->fetch_array($query);
            $db->free_result($query);
            if ($votes['username'] == $self['username']) {
                gallery_error($lang['img_erroralreadyrated']);
            }
        }

        if (!isset($_POST['ratesubmit'])) {
            $dateadded = gmdate($dateformat, $image['dateline']);
            $image['url'] = stripslashes($image['url']);
            $image['name'] = stripslashes($image['name']);
            $image['description'] = stripslashes($image['description']);
            $image['author'] = stripslashes($image['author']);
            $resize = gallery_resize($image['url'], 'image', $imageheight, $imagewidth);

            if ($image['votes'] > 0) {
                $num = $image['rate']/(5*$image['votes']);
                $n=$num*5;
                if ($n>='4.5') {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                } elseif ($n>='3.5' && $n<'4.5') {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                } elseif ($n>='2.5' && $n<'3.5') {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                } elseif ($n>='1.5' && $n<'2.5') {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /><img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                } elseif ($n>='1' && $n<'1.5') {
                    $rate='<img src='.$imgdir.'/star.gif alt="" /> ('.$lang['img_textvotes'].': '.$image['votes'].')';
                }
            } else {
                $rate = 'None';
            }

            eval('echo "'.template('img_rate').'";');
            eval('echo "'.template('img_image').'";');

        } elseif (isset($_POST['ratesubmit'])) {

            if (!isset($rate) || $rate < 1 || $rate > 5) {
                gallery_info($lang['img_infonovote'],'gallery_misc.php?action=rate&iid='.$iid);
            }

            // Store the vote
            $db->query("INSERT INTO $table_imgvotes (username, iid ) VALUES ('$self[username]', '$iid')");
            $db->query("UPDATE $table_imgimages SET votes=votes+1, rate=rate+'$rate' WHERE iid='$iid'");
            gallery_info($lang['img_infovoted'],'gallery_image.php?action=view&iid='.$iid.'#pictop');
        }
        break;

    case 'slideshow':
        // Find the previous and next image
        $currentval = $image[$gsettings['image_order']];

        $nextiid = '';
        $prioriid = '';

        $query = $db->query("SELECT iid FROM $table_imgimages WHERE cid='$cid' AND `$gsettings[image_order]`>'$currentval' ORDER BY `$gsettings[image_order]` LIMIT 1");
        $next = $db->fetch_array($query);
        $db->free_result($query);

        if ($next['iid'] != 0) {
            $nextiid = $next['iid'];
        } else {
            $query = $db->query("SELECT iid, name FROM $table_imgimages WHERE cid='$cid' ORDER BY `$gsettings[image_order]` LIMIT 1");
            $next = $db->fetch_array($query);
            $db->free_result($query);
            $nextiid = $next['iid'];
        }

        $query = $db->query("SELECT iid, name FROM $table_imgimages WHERE cid='$cid' AND `$gsettings[image_order]`<'$currentval' ORDER BY `$gsettings[image_order]` DESC LIMIT 1");
        $prior = $db->fetch_array($query);
        $db->free_result($query);

        if ($prior['iid'] != 0) {
            $prioriid = $prior['iid'];
        } else {
            $query = $db->query("SELECT iid, name FROM $table_imgimages WHERE cid='$cid' ORDER BY `$gsettings[image_order]` DESC LIMIT 1");
            $prior = $db->fetch_array($query);
            $db->free_result($query);
            $prioriid = $prior['iid'];
        }

        $image['url'] = stripslashes($image['url']);
        $image['name'] = stripslashes($image['name']);
        $resize = gallery_resize($image['url'], 'image', $imageheight, $imagewidth);
        $priorlink = '<a href="gallery_misc.php?action=slideshow&amp;iid='.$prioriid.'"><img src="'.$imgdir.'/previous.gif" alt="'.$lang['img_textprior'].'" border="0" /></a>';
        $nextlink = '<a href="gallery_misc.php?action=slideshow&amp;iid='.$nextiid.'"><img src="'.$imgdir.'/next.gif" alt="'.$lang['img_textnext'].'" border="0" /></a>';
        eval('echo "'.template('img_slideshow').'";');

        $displaylinks = '';

        if (isset($pause) && $pause == 1) {
            $displaylinks[] = '<a href="gallery_misc.php?action=slideshow&amp;iid='.$nextiid.'">'.$lang['img_textplay'].'</a>';
            $displaylinks[] = '<a href="gallery_image.php?action=view&amp;iid='.$nextiid.'#pictop">'.$lang['img_textstop'].'</a>';
            $displaylinks = implode(' | ', $displaylinks);
            eval('echo "'.template('img_album_links').'";');
        } else {
            $displaylinks[] = '<a href="gallery_misc.php?action=slideshow&amp;iid='.$iid.'&amp;pause=1">'.$lang['img_textpause'].'</a>';
            $displaylinks[] = '<a href="gallery_image.php?action=view&amp;iid='.$nextiid.'#pictop">'.$lang['img_textstop'].'</a>';
            $displaylinks = implode(' | ', $displaylinks);

            eval('echo "'.template('img_album_links').'";');
            ?>
            <script>
            function redirect()
            {
            window.location.replace("gallery_misc.php?action=slideshow&iid=<?=$nextiid?>#pictop");
            }
            setTimeout("redirect();", <?=$gsettings['pause']?>);
            </script>
            <?
        }
        break;

    case 'getip':
        if (isset($pid)) {
            $query = $db->query("SELECT * FROM $table_imgcomments WHERE pid='$pid'");
        }
        $ipinfo = $db->fetch_array($query);

        if (!X_ADMIN) {
            error($lang['textnoaction'], false);
        }

        ?>
        <form method="post" action="cp.php?action=ipban">
        <table cellspacing="0" cellpadding="0" border="0" width="60%" align="center">
        <tr><td bgcolor="<?php echo $bordercolor?>">
        <table border="0" cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" width="100%">
        <tr>
        <td class="header" colspan="3"><?php echo $lang['textgetip']?></td>
        </tr>
        <tr bgcolor="<?php echo $altbg2?>">
        <td class="tablerow"><?php echo $lang['textyesip']?> <b><?php echo $ipinfo['useip']?></b> - <?php echo gethostbyaddr($ipinfo['useip'])?>
        <?

        if (X_ADMIN) {
            $ip = explode(".", $ipinfo['useip']);
            $query = $db->query("SELECT * FROM $table_banned WHERE (ip1='$ip[0]' OR ip1='-1') AND (ip2='$ip[1]' OR ip2='-1') AND (ip3='$ip[2]' OR ip3='-1') AND (ip4='$ip[3]' OR ip4='-1')");
            $result = $db->fetch_array($query);

            if ($result) {
                $buttontext = $lang['textunbanip'];
                for ($i=1; $i<=4; ++$i) {
                    $j = "ip$i";
                    if ($result[$j] == -1) {
                        $result[$j] = "*";
                        $foundmask = 1;
                    }
                }

                if ($foundmask) {
                    $ipmask = '<b>'.$result['ip1'].$result['ip2'].$result['ip3'].$result['ip4'].'</b>';
                    eval($lang['evalipmask']);
                    $lang['bannedipmask'] = stripslashes($lang['bannedipmask']);
                    echo $lang['bannedipmask'];
                } else {
                    $lang['textbannedip'] = stripslashes($lang['textbannedip']);
                    echo $lang['textbannedip'];
                }
                echo '<input type="hidden" name="delete'.$result['id'].'" value="'.$result['id'].'" />';
            } else {
                $buttontext = $lang['textbanip'];
                for ($i=1; $i<=4; ++$i) {
                    $j = $i - 1;
                    echo '<input type="hidden" name="newip'.$i.'" value="'.$ip['$j'].'" />';
                }
            }
            ?>
            </td></tr>
            <tr    bgcolor="<?php echo    $altbg1?>"><td class="tablerow">
            <center><input type="submit" name="ipbansubmit"    value="<?php echo $buttontext?>" /></center>
            <?
        }
        echo '</td></tr></table></td></tr></table></form>';
        break;

    case 'report':
        if ($reportpost == 'off') {
            eval('echo stripslashes("'.template('misc_feature_notavailable').'");');
            eval('echo "'.template('img_footer').'";');
            end_time();
            eval('echo "'.template('footer').'";');
            exit();
        }

        if (!isset($_POST['reportsubmit'])) {
            eval('echo stripslashes("'.template('img_report').'");');
        } else {
            $postcount = $db->result($db->query("SELECT count(pid) FROM $table_imgcomments WHERE iid='$iid'"), 0);
            $query    = $db->query("SELECT username FROM $table_members WHERE status='Super Administrator' OR status='Administrator'");
            while ($usr = $db->fetch_array($query)) {
                $mods[] = $usr['username'];
            }
            $sent  = 0;
            $time  = $onlinetime;
            foreach ($mods as $key=>$mod) {
                $mod = trim($mod);
                $q = $db->query("SELECT ppp FROM $table_members WHERE username='$mod'");
                if ($db->num_rows($q) == 0) {
                    continue;
                }
                $page = quickpage($postcount, $db->result($q, 0));
                $posturl = $SETTINGS['boardurl'] . 'gallery_image.php?action=view&amp;iid='.$iid.'#pid'.$pid;
                $reason  = checkInput($reason);
                $message = $lang['reportmessage'].' '.$posturl."\n\n".$lang['reason'].' '.$reason;

                $db->query("INSERT INTO $table_u2u ( u2uid, msgto, msgfrom, type, owner, folder, subject, message, dateline, readstatus, sentstatus    ) VALUES ('', '$mod', '$self[username]', 'incoming', '$mod', 'Inbox', '$lang[reportsubject]', '$message', $db->time($time), 'no', 'yes')");
                $sent++;
            }
            echo '<center><span class="mediumtxt">'.$lang['reportmsg'].'</span></center>';

            $page = quickpage($postcount, $self['tpp']);
            redirect('gallery_image.php?action=view&iid='.$iid.'&page='.$page.'#pid'.$pid, 2, X_REDIRECT_JS);
        }
        break;
}

eval('echo "'.template('img_footer').'";');
end_time();
eval('echo "'.template('footer').'";');
?>