<?php
/* $Id: gallery_stats.php,v 1.2 2006/03/10 06:42:37 johnbriggs Exp $ */
/*
    Name: Photo Gallery v2.0
    Author: Steven Waters, John Briggs
    Contributors: Jack Faxon, Stalker, Spike, Bigdumredneck, Elmo
    Copyright  2006 XMBMods.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// Fetch global stuff
require_once('header.php');
require_once(ROOT.'include/gallery.functions.inc.php');

//  Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM $table_imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);

// Pre-define a few variables
nav('<a href="./gallery.php">'.stripslashes($gsettings['title']).'</a>');
nav($lang['altstats']);

// Pre-load templates (saves queries)
loadtemplates(
'img_statistics',
'img_footer',
'img_error'
);

eval('$css = "'.template('css').'";');

// Show header
eval('echo "'.template('header').'";');

//  Check for permissions to view the gallery
$gallery_viewpermission = privfcheck($gsettings['who_view_gallery'],'');
if (!$gallery_viewpermission) {
    gallery_error($lang['img_errorprivgallery']);
}

// Check if stats is on/off
    if ($gsettings['stats'] == 'off') {
        gallery_error($lang['fnasorry3']);
}

// Create some of the where clause for subsequent queries
$restrict = '';
switch ($self['status']) {
    case 'member':
        $restrict .= " a.who_view !='3' AND";
    case 'Moderator':
    case 'Super Moderator':
        $restrict .= " a.who_view != '2' AND";
    case 'Administrator':
    case 'Super Administrator':
        // no restrictions
        break;
    default:
        $restrict .= " a.who_view !='3' AND a.who_view != '2' AND a.view_list = '' AND a.password = '' AND";
        break;
}

// Get total amount of albums
$query = $db->query("SELECT COUNT(cid) FROM $table_imgcats WHERE sub=0");
$albums = $db->result($query, 0);
$db->free_result($query);

// Get total amount of subalbums
$query = $db->query("SELECT COUNT(cid) FROM $table_imgcats WHERE sub<>0");
$subalbums = $db->result($query, 0);
$db->free_result($query);

// Get total amount of images
$query = $db->query("SELECT COUNT(iid) FROM $table_imgimages");
$images = $db->result($query, 0);
$db->free_result($query);

// Get total amount of albums that are ON
$query = $db->query("SELECT COUNT(cid) FROM $table_imgcats WHERE sub=0 AND status='on'");
$albumson = $db->result($query, 0);
$db->free_result($query);

// Get total amount of subalbums that are ON
$query = $db->query("SELECT COUNT(cid) FROM $table_imgcats WHERE sub<>0 AND status='on'");
$subalbumson = $db->result($query, 0);
$db->free_result($query);

// Get top 5 most viewed albums
$viewmostalbums = '';
$query = $db->query("SELECT a.views, a.cid, a.name FROM $table_imgcats a WHERE $restrict a.cid = a.cid ORDER BY a.views DESC LIMIT 0,5");
while ($views = $db->fetch_array($query)) {
    $views_albums = stripslashes(censor($views['name']));
    $viewmostalbums .= '<a href="gallery_view_album.php?cid='.$views['cid'].'">'.$views_albums.'</a> ('.$views['views'].')<br />';
}
$db->free_result($query);

// Get top 5 most viewed images
$viewmostimages = '';
$query = $db->query("SELECT i.views, i.iid, i.name FROM $table_imgimages i, $table_imgcats a WHERE $restrict i.cid = a.cid ORDER BY i.views DESC LIMIT 0,5");
while ($views = $db->fetch_array($query)) {
    $views_albums = stripslashes(censor($views['name']));
    $viewmostimages .= '<a href="gallery_image.php?action=view&amp;iid='.$views['iid'].'#pictop ">'.$views_albums.'</a> ('.$views['views'].')<br />';
}
$db->free_result($query);

// eval, and show it all
eval($lang['img_evalstats1']);
eval($lang['img_evalstats2']);
eval($lang['img_evalstats3']);
eval($lang['img_evalstats4']);
eval($lang['img_evalstats5']);
eval($lang['img_evalstats6']);

eval('echo "'.template('img_statistics').'";');

// Create footer, and end page
eval('echo "'.template('img_footer').'";');
end_time();
eval('echo "'.template('footer').'";');
?>