<?php
/* $Id: gallery.functions.inc.php,v 1.3 2006/03/10 06:42:39 johnbriggs Exp $ */
/*
    Name: Photo Gallery v2.0
    Author: Steven Waters, John Briggs
    Contributors: Jack Faxon, Stalker, Spike, Bigdumredneck, Elmo
    Copyright  2006 XMBMods.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
* gallery_createpermission() - Determines if the user is permitted to create an album or not
*
* @param    None
*
* @return   boolean     true = can create album, false = can't create album
*/
function gallery_createpermission() {
    global $gsettings, $self, $table_imgcats, $db;

    if (X_ADMIN) {
        return true;
        exit;
    }

    if (!X_MEMBER) {
        return false;
        exit;
    }

    $gallery_viewpermission = privfcheck($gsettings['who_create'],'');

    if ($gallery_viewpermission) {
        // See how many albums the member currently owns
        $number_of_albums = $db->result($db->query("SELECT count(cid) FROM $table_imgcats WHERE author='$self[username]'"), 0);

        // If the limit has already been met or exceeded, return false
        if (intval($number_of_albums) >= intval($gsettings['max_cat_mem'])) {
            return false;
            exit;
        } else {
            return true;
            exit;
        }
    }
    return false;
}

/**
* gallery_viewalbumperm() - Determines if the user is permitted to view this album or not
*
* @param    $cid         The cid of the album being checked for permission.
*
* @return   boolean     true = can view album, false = can't view album
*/
function gallery_viewalbumperm($cid=0) {
    global $gsettings, $self, $table_imgcats, $db;

    if (X_ADMIN) {
        return true;
        exit;
    }
    // Find the album
    $query = $db->query("SELECT sub, status, who_view, view_list FROM $table_imgcats WHERE cid = '$cid'");
    $album = $db->fetch_array($query);
    $db->free_result($query);
    // Check the view list
    $authorization = privfcheck($album['who_view'], $album['view_list']);
    if ($authorization && $album['status'] == 'on') {
        // If okay, see if this is a sub album.  If it is, then we must be able to view the parent
        // album in order to view the sub album.
        if ($album['sub'] == 0) {
            return true;
            exit;
        }
        if (gallery_viewalbumperm($album['sub'])) {
            return true;
            exit;
        }
    } else {
        return false;
        exit;
    }

    return false;
}

/**
* gallery_addimageperm() - Checks to see if the user can add images to this album
*
* @param    $cid  this is the cid of the album
*
* @return    boolean true = can add images, false = can't add images to album
*/
function gallery_addimageperm($cid) {
    global $gsettings, $self, $table_imgcats, $table_imgimages, $db;

    if (X_ADMIN) {
        return true;
        exit;
    }

    if (!X_MEMBER) {
        return false;
        exit;
    }

    // Start with the gallery settings
    $gallery_addimageperm = privfcheck($gsettings['whoadd'],'');

    // Now, check the album settings
    if ($gallery_addimageperm) {

        $query = $db->query("SELECT who_add, add_list, author, creator_only, closed, status FROM $table_imgcats WHERE cid=$cid");
        $album = $db->fetch_array($query);
        $db->free_result($query);
        // First, see if the album is closed
        if ($album['closed'] == 'yes' || $album['status'] == 'off') {
            return false;
            exit;
        }

        // Now check the album permissions
        $gallery_addimageperm = privfcheck($album['who_add'],$album['add_list']);
        if (!$gallery_addimageperm) {
            return false;
            exit;

        }
        // Is creator only set?
        if ($album['creator_only'] == 'on' && $self['username'] != $album['author']) {
            return false;
            exit;
        }
        // Made it this far, now check to see if the max number of images is exceeded.
        $number_of_images = $db->result($db->query("SELECT count(iid) FROM $table_imgimages WHERE author='$self[username]'"), 0);

        // If the limit has already been met or exceeded, return false
        if (intval($number_of_images) >= intval($gsettings['max_img_mem'])) {
            return false;
            exit;
        } else {
            return true;
            exit;
        }
    }
    return false;
}

/**
* gallery_uploadimageperm() - Checks to see if the user can upload images to this album
*
* @param    $cid  this is the cid of the album
*
* @return    boolean true = can add images, false = can't add images to album
*/
function gallery_uploadimageperm($cid) {
    global $gsettings, $self, $table_imgcats, $db;

    // Start with seeing if the user can add images
    if (!gallery_addimageperm($cid)) {
        return false;
        exit;
    }

    // if the user can add images, check the gallery settings.
    if ($gsettings['upload'] == 'on') {
        if (privfcheck($gsettings['who_upload'],'')) {
            return true;
            exit;
        }
    }

    return false;
}

/**
* gallery_deletealbumdb() - Removes the album and any subalbums from the database
*
* @param    $delete  this is the cid of the album to delete
*
* @return   nothing, if it makes it out of here, then it is valid
*/
function gallery_deletealbumdb($delete) {
    global $table_imgcats, $table_imgimages, $table_imgvotes, $table_imgcomments, $table_imgthumbnails, $table_imgimagedata, $db;

    // Remove all the data from the album.
    $sub = $db->query("SELECT cid from $table_imgcats WHERE sub='$delete'");
    while ($subalbum = $db->fetch_array($sub)) {
        // recurse through all the subalbums, if there are any.
        gallery_deletealbumdb($subalbum['cid']);
    }
    $db->free_result($sub);

    // Now, find the images from the album.
    $images = $db->query("SELECT iid from $table_imgimages WHERE cid='$delete'");

    //  Delete the votes, comments then the image
    while ($imgdelete = $db->fetch_array($images)) {
        $db->query("DELETE from $table_imgvotes WHERE iid='$imgdelete[iid]'");
        $db->query("DELETE from $table_imgcomments WHERE iid='$imgdelete[iid]'");
        $db->query("DELETE from $table_imgimages WHERE iid='$imgdelete[iid]'");
        $db->query("DELETE from $table_imgthumbnails WHERE iid='$imgdelete[iid]'");
        $db->query("DELETE from $table_imgimagedata WHERE iid='$imgdelete[iid]'");
    }
    $db->free_result($images);

    $db->query("DELETE FROM $table_imgcats WHERE cid='$delete'");
}

/**
* gallery_error() - Displays an error message(s).
*
* @param    $error_msg - This is an array that contains all the errors from the requested action
*
* @return   nothing
*/
function gallery_error($error_msg) {
    global $footerstuff;
    extract($GLOBALS);

    $errorrows = '';

    if (count($error_msg) == 1) {
        if (gettype($error_msg) == 'array') {
            $message = $error_msg[0];
        } else {
            $message = $error_msg;
        }
    } else {
        $message = $lang['img_errormultiples'];
        for ($i=0; $i < count($error_msg); $i++) {
            $errornum = $i + 1;
            $errorrows .= '<tr>';
            $errorrows .= '<td bgcolor='.$altbg1.' width=5% ><font class="mediumtxt">'.$errornum.'</font></td>';
            $errorrows .= '<td bgcolor='.$altbg1.' ><font class="mediumtxt">'.$error_msg[$i].'</font></td>';
            $errorrows .= '</tr>';
        }
    }

    eval('echo "'.template('img_error').'";');
    eval('echo "'.template('img_footer').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

/**
* gallery_info() - Displays an informational message.
*
* @param    $info_msg - This is a string that contains the informational message.
* @param    $info_url - This is an optional string that contains the url to redirect to.
*
* @return   nothing
*/
function gallery_info($info_msg, $info_url='') {
    global $footerstuff;
    extract($GLOBALS);

    $message = $info_msg;
    eval('echo "'.template('img_info').'";');
    if (!empty($info_url)) {
        redirect($info_url, 2, X_REDIRECT_JS);
    }
}

/**
* gallery_albums() - Creates an array of albums the user has rights to.  This is used in the display of the
*                    albums and to populate the drop down when moving images.
*
* @param    nothing
*
* @return   nothing
*/
function gallery_albums() {
    global $gsettings, $self, $table_imgcats, $db;

    $albumlist = array();
    $i=0;
    $query = $db->query("SELECT cid, name, password FROM $table_imgcats WHERE sub=0 ORDER BY $gsettings[album_order]");
    while ($albums = $db->fetch_array($query)) {
         $goodalbum = false;

        // Do a quick check for passwords.  Only checking to see if the user has a cookie.  The actual
        // prompt for the password will happen when the user opens the album.
        $password = false;
        if (trim($albums['password']) == '') {
            $password = true;
        } else {
            $cidpw = isset($_COOKIE['albumpw'.$albums['cid']]) ? $_COOKIE['albumpw'.$albums['cid']] : '';
            if ($cidpw = trim($albums['password'])) {
                $password = true;
            }
        }

        // Does this user have write permissions for this album?
        if (gallery_addimageperm($albums['cid']) && $password) {
            $albumrow = array('cid' => $albums['cid'],'name' => stripslashes($albums['name']),'permissions' => 'write','sub' => 0);
            $albumlist[$i] = $albumrow;
            $i++;
            $goodalbum = true;
        } else {
            // Can't write, see if he can view the album.
            $authorization = gallery_viewalbumperm($albums['cid']);
            if ($authorization) {
                // Can't write to this album, but can view this album
                $albumrow = array('cid' => $albums['cid'],'name' => stripslashes($albums['name']),'permissions' => 'read','sub' => 0);
                $albumlist[$i] = $albumrow;
                $i++;
                $goodalbum = true;
            }
        }
        //  If the album was good, check the subalbums for this album
        if ($goodalbum) {
            $subquery = $db->query("SELECT cid, name, sub, password FROM $table_imgcats WHERE sub='$albums[cid]' ORDER BY $gsettings[album_order]");
            while ($subalbums = $db->fetch_array($subquery)) {
                // Do a quick check for passwords.  Only checking to see if the user has a cookie.  The actual
                // prompt for the password will happen when the user opens the album.
                $password = false;
                if (trim($subalbums['password']) == '') {
                    $password = true;
                } else {
                    $cidpw = isset($_COOKIE['albumpw'.$subalbums['cid']]) ? $_COOKIE['albumpw'.$subalbums['cid']] : '';
                    if ($cidpw == trim($subalbums['password'])) {
                        $password = true;
                    }
                }
                if (gallery_addimageperm($subalbums['cid']) && $password) {
                    $albumrow = array('cid' => $subalbums['cid'],'name' => stripslashes($subalbums['name']),'permissions' => 'write','sub' => $subalbums['sub']);
                    $albumlist[$i] = $albumrow;
                    $i++;
                } else {
                    // Can't write, see if he can view the album.
                    $authorization = gallery_viewalbumperm($subalbums['cid']);
                    if ($authorization) {
                        // Can't write to this album, but can view this album
                        $albumrow = array('cid' => $subalbums['cid'],'name' => stripslashes($subalbums['name']),'permissions' => 'read','sub' => $subalbums['sub']);
                        $albumlist[$i] = $albumrow;
                        $i++;
                    }
                }
            }
            $db->free_result($subquery);
        }
    }
    $db->free_result($query);
    return $albumlist;
}

/**
* gallery_pwverify() - Validates the password to view an album
*
* This will check to see if a password is required.  If it is, and the user does not have a cookie that contains
* the password, it will prompt the user for his password.
*
* @param    $pass - This is the password for the album
* @param    $url - This is the url for the album
* @param    $cid - This is the cid for the album
* @param    $showHeader - Optional parameter, if an error is to be be displayed this
*                         is used to decide if the header should also be displayed
*
* @return   Returns true if the password is valid, false otherwise
*/
function gallery_pwverify($pass='', $url, $cid, $showHeader=false) {
    global $self, $cookiepath, $cookiedomain;

    if (X_ADMIN) {
        return true;
    }

    if ((trim($pass) != '') && $_COOKIE['albumpw'.$cid] != $pass) {
        if ($_POST['pw'] != $pass) {
            extract($GLOBALS);
            eval('$pwform = "'.template('forumdisplay_password').'";');
            error(((isset($_POST['pw'])) ? $lang['invalidforumpw'] : $lang['img_textpwinfo']), $showHeader, '', $pwform, false, true, false, true);
        } else {
            put_cookie('albumpw'.$cid, $pass, (time() + (86400*30)), $cookiepath, $cookiedomain);
            redirect($url, 0);
        }
        exit;
    }

    return true;
}

/**
* gallery_resize() - This will check an images orientation and size against the gallery settings.
*                    It will return a string that resize the displayed image.
*
* @param    $url - This contains the url for the image.
* @param    $type - This will be 'thumb' or 'image'
*
* @return   A string that can be inserted into the HTML for the displayed image.
*/
function gallery_resize($url, $type='', $height=0, $width=0) {
    global $gsettings;

    if ($type != 'thumb') {
        $maxheight = (int) $gsettings['max_image_height'];
        $maxwidth = (int) $gsettings['max_image_width'];
    } else {
        $maxheight = (int) $gsettings['max_thumb_height'];
        $maxwidth = (int) $gsettings['max_thumb_width'];
    }

    if ($height == '0' && $width == '0') {
        $SizeArray = getimagesize($url);
        $width = $SizeArray[0];
        $height = $SizeArray[1];
    }

    // Resize the image, if necessary.
    // First, see if the pic is landscape or portrait.
    $resize = '';
    if ($width > $height) {
        // Landscape
        if ($width > $maxwidth) {
            $resize = 'width="'.$maxwidth.'"';
        }
    } else {
        if ($height > $maxheight ) {
            $resize = 'height="'.$maxheight.'"';
        }
    }

    return $resize;

}

/**
* gallery_validateupload() -
*
* @param    $name - This is the name the user specified for the photo.
* @param    $attach - This is the contents of $_FILES[attach] that was submitted on the form
* @param    $multi - This is used to determine if this is a multiple upload, or a single upload
*
* @return   An array of the errors that were found
*/
function gallery_validateupload($name, $attach, $multi='') {
    global $gsettings, $lang;

    $errorlist = array();
    if (!empty($multi)) {
        $multi = $lang['img_textonrow'].$multi.': ';
    }

    // Validate the name of the image
    if (!strlen($name) > 0) {
        array_push($errorlist, $multi.$lang['img_errornoimagename']);
    }

    if ($attach['size'] == 0) {
        array_push($errorlist, $multi.$lang['img_errornofile']);
    }

    if (strpos($attach['type'], 'image/') === false) {
        array_push($errorlist, $multi.$lang['img_errorinvalidfiletype']);
    }

    if (strpos($attach['type'], 'jpeg') === false && strpos($attach['type'], 'jpg') === false && strpos($attach['type'], 'gif') === false && strpos($attach['type'], 'png') === false) {
        array_push($errorlist, $multi.$lang['img_errorinvalidfiletype']);
    }

    // Check the size of the file in bytes, and the size of the image
    if ($attach['size'] > $gsettings['max_image_size']) {
        eval($lang['img_evalfiletoolarge']);
        array_push($errorlist, $multi.$lang['img_errorfiletoolarge']);
    }

    return $errorlist;
}

/**
* gallery_validatethumb() -
*
* @param    $thumb - This is the contents of $_FILES[thumb] that was submitted on the form
* @param    $multi - This is used to determine if this is a multiple upload, or a single upload
*
* @return   An array of the errors that were found
*/
function gallery_validatethumb($thumb, $multi='') {
    global $gsettings, $lang;

    $errorlist = array();
    if (!empty($multi)) {
        $multi = $lang['img_textonrow'].$multi.': ';
    }

    if ($thumb['size'] == 0) {
        array_push($errorlist, $multi.$lang['img_errornothumbfile']);
    }

    if (strpos($thumb['type'], 'image/') === false) {
        array_push($errorlist, $multi.$lang['img_errorinvalidthumbfiletype']);
    }

    if (strpos($attach['type'], 'jpeg') === false && strpos($attach['type'], 'jpg') === false && strpos($attach['type'], 'gif') === false && strpos($attach['type'], 'png') === false) {
        array_push($errorlist, $multi.$lang['img_errorinvalidthumbfiletype']);
     }

    return $errorlist;

}

/**
* gallery_createthumbrow() - This will create a thumbnail from an attached image and insert the
                          row into the thumbnail table
*
* @param    $filename - This is the temporary file created when the file was uploaded
* @param    $iid      - This is the identifier to the image that owns this thumbnail
* @param    $cid      - This is the identifier to the album that owns the image
*
* @return
*/
function gallery_createthumbrow($filename, $iid, $cid) {
    global $gsettings, $table_imgthumbnails, $table_imgimages, $db;

    $size = GetImageSize($filename);
    $ratio = $size[0]/$size[1];
    $imagetype = $size[2];

    if ($ratio > 1) {
        $width = $gsettings['max_thumb_width'];
        $height = ($gsettings['max_thumb_width']*$size[1]) / $size[0];
    } else {
        $width = ($gsettings['max_thumb_height']*$size[0]) / $size[1];
        $height = $gsettings['max_thumb_height'];
    }

    $thumb = ImageCreateTrueColor($width, $height);

    if ($imagetype == '1') {
        $source = ImageCreateFromGIF($filename);
    } elseif ($imagetype == '2') {
        $source = ImageCreateFromJPEG($filename);
    } elseif ($imagetype == '3') {
        $source = ImageCreateFromPNG($filename);
    }

    ImageCopyResampled($thumb, $source, 0, 0, 0, 0, $width, $height, ImageSX($source), ImageSY($source));

    ob_start();
    if ($imagetype == '1') {
        ImageGIF($thumb, '', 75);
        $thumbData = ob_get_contents();
    } elseif ($imagetype == '2') {
        ImageJPEG($thumb, '', 75);
        $thumbData = ob_get_contents();
    }

    if ($imagetype == '3') {
        ImagePNG($thumb, '', 75);
        $thumbData = ob_get_contents();
    }
    ob_end_clean();
    ImageDestroy($thumb);
    $thumbData = addslashes($thumbData);
    $imagetype = image_type_to_mime_type($imagetype);
    $db->query("INSERT INTO $table_imgthumbnails SET iid='$iid', cid='$cid', width='$width', height='$height', filetype='$imagetype', thumbnail='$thumbData'");
    $thumb_url = 'gallery.php?action=viewthumb&amp;iid='.$iid.'&amp;cid='.$cid;
    $thumb_url = addslashes($thumb_url);
    $db->query("UPDATE $table_imgimages SET thumb='$thumb_url' WHERE iid='$iid' ");
}
?>