<?php
/**
 * Calendar System v1.0
 *  2006 John Briggs
 * http://www.xmbmods.com

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/

require_once('header.php');

function bbcodeinsert() {
    global $imgdir, $bbinsert, $altbg1, $altbg2, $lang, $SETTINGS, $spelling_lang;

    $bbcode = '';
    if ($bbinsert == 'on') {
        eval('$bbcode = "'.template('functions_bbcodeinsert').'";');
    }
    return $bbcode;
}

loadtemplates(
'functions_smilieinsert',
'functions_smilieinsert_smilie',
'functions_bbcode',
'functions_bbcodeinsert',
'cal_admin',
'cal_holiday',
'cal_new_event',
'cal_edit_event',
'cal_add_event',
'cal_add_holiday',
'cal_edit_holiday',
'cal_event_edit',
'cal_eventlist',
'cal_copyright',
'misc_feature_notavailable'
);

smcwcache();

eval('$css = "'.template('css').'";');

if ($SETTINGS['calendar'] == 'off') {
    eval('echo "'.template('header').'";');
    eval('echo "'.template('misc_feature_notavailable').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

switch ($action) {
    case 'settings':
        nav('<a href="calendar.php">'.$lang['textcalendar'].'</a>');
        nav($lang['calendar_settings']);
        break;
    case 'admin':
        nav('<a href="calendar.php">'.$lang['textcalendar'].'</a>');
        nav($lang['calendar_admin']);
        break;
    default:
        nav($lang['textcalendar']);
        break;
}

eval('$bbcodescript = "'.template('functions_bbcode').'";');

eval('echo "'.template('header').'";');

if (file_exists('install.php') && !@unlink('install.php') || file_exists('calendar.xmb') && !@unlink('calendar.xmb')) {
    error('You must remove the calendar install files named "install.php" and "calendar.xmb" before you may proceed to use the calendar system!', false);
}

$monthNames = array('offset', $lang['textjan'], $lang['textfeb'], $lang['textmar'], $lang['textapr'], $lang['textmay'], $lang['textjun'], $lang['textjul'], $lang['textaug'], $lang['textsep'], $lang['textoct'], $lang['textnov'], $lang['textdec']);
$dayNames = array('offset', $lang['textsun'], $lang['textmon'], $lang['texttue'], $lang['textwed'], $lang['textthu'], $lang['textfri'], $lang['textsat']);

if (!isset($month)) {
    $month = date("n");
}

if (!isset($day)) {
    $day = date("d");
}

if (!isset($year)) {
    $year =  date("Y");
}

if ($month < 1 || $month > 12) {
    $month = date("n");
}

if ($day < 1 || $day > 31) {
    $day = date("d");
}

$query = $db->query("SELECT * FROM $table_calendar");
$cal_set = $db->fetch_array($query);
$db->free_result($query);

$cal_showbdays = $cal_set['showbdays'];
$cal_showholidays = $cal_set['showholidays'];
$cal_showevents = $cal_set['showevents'];
$cal_display = $cal_set['display'];
$cal_postevents = $cal_set['postevents'];
$cal_membersonly = $cal_set['membersonly'];

if ($cal_set['themes'] == $lang['texton']) {
    $cal_bdaycolor = isset(${$cal_set['bdaycolor']}) ? "${$cal_set['bdaycolor']}" : '';
    $cal_holidaycolor = isset(${$cal_set['holidaycolor']}) ? "${$cal_set['holidaycolor']}" : '';
    $cal_eventcolor = isset(${$cal_set['eventcolor']}) ? "${$cal_set['eventcolor']}" : '';
    $cal_seventcolor = isset(${$cal_set['special_event_color']}) ? "${$cal_set['special_event_color']}" : '';
} else {
    $cal_bdaycolor = $cal_set['bdaycolor'];
    $cal_holidaycolor = $cal_set['holidaycolor'];
    $cal_eventcolor = $cal_set['eventcolor'];
    $cal_seventcolor = $cal_set['special_event_color'];
}

$cal_dayeffect = $cal_set['dayeffect'];
$cal_bdayimage = $cal_set['bdayimage'];

$useend = $eventform = '';
$listed_icons = 0;
$icons = '<input type="radio" name="posticon" value="" /> <img src="'.$imgdir.'/default_icon.gif" alt="[*]" />';
if (isset($newevent) || isset($editevent)) {
    if (!X_STAFF) {
        $query = $db->query("SELECT url, code FROM $table_smilies WHERE type='picon' AND (url NOT LIKE '%rsvd%')");
        while ($smilie = $db->fetch_array($query)) {
            $icons .= " <input type=\"radio\" name=\"posticon\" value=\"$smilie[url]\" /><img src=\"$smdir/$smilie[url]\" alt=\"$smilie[code]\" />";
            $listed_icons += 1;
            if ($listed_icons == 9) {
                $icons .= "<br />";
                $listed_icons = 0;
            }
        }
        $db->free_result($query);
    } else {
        $query = $db->query("SELECT url, code FROM $table_smilies WHERE type='picon'");
        while ($smilie = $db->fetch_array($query)) {
            $icons .= " <input type=\"radio\" name=\"posticon\" value=\"$smilie[url]\" /><img src=\"$smdir/$smilie[url]\" alt=\"$smilie[code]\" />";
            $listed_icons += 1;
            if ($listed_icons == 9) {
                $icons .= "<br />";
                $listed_icons = 0;
            }
        }
        $db->free_result($query);
    }

    $bbcodeinsert = bbcodeinsert();
    $smilieinsert = smilieinsert();
}

if ($action && !X_GUEST) {
    if ($action == 'settings' && (X_ADMIN)) {
        if (!isset($submitsettings)) {
            if ($cal_set['themes'] == $lang['texton']) {
                $themecolors = "<option value=''>$lang[calendar_color]</option>\n";
                $themecolors .= "<option style='color:$link' value='link'>$lang[textlink]</option>\n";
                $themecolors .= "<option style='color:$bordercolor' value='bordercolor'>$lang[textborder]</option>\n";
                $themecolors .= "<option style='color:$headertext' value='headertext'>$lang[textheadertext]</option>\n";
                $themecolors .= "<option style='color:$tabletext' value='tabletext'>$lang[texttabletext]</option>\n";
                $themecolors .= "<option style='color:$text' value='text'>$lang[texttext]</option>\n";
                $themecolors .= "<option style='color:$cattext' value='cattext'>$lang[textcattextcolor]</option>\n";

                $bcolor = "<select name='bdaycolor' size='1'>\n";
                if ($cal_set['bdaycolor'] != '') {
                    $bcolor .= str_replace("<option style='color:$cal_bdaycolor' value='$cal_set[bdaycolor]'>", "<option selected style='color:$cal_bdaycolor' value='$cal_set[bdaycolor]'>", $themecolors);
                } else {
                    $bcolor .= str_replace("<option value=''>$lang[calendar_color]</option>", "<option selected value=''>$lang[calendar_color]</option>", $themecolors);
                }

                $bcolor .= "</select>\n";
                $hcolor = "<select name='holidaycolor' size='1'>\n";
                if ($cal_set['holidaycolor'] != '') {
                    $hcolor .= str_replace("<option style='color:$cal_holidaycolor' value='$cal_set[holidaycolor]'>", "<option selected style='color:$cal_holidaycolor' value='$cal_set[holidaycolor]'>", $themecolors);
                } else {
                    $hcolor .= str_replace("<option value=''>$lang[calendar_color]</option>", "<option selected value=''>$lang[calendar_color]</option>", $themecolors);
                }

                $hcolor .= "</select>\n";
                $ecolor = "<select name='eventcolor' size='1'>\n";
                if ($cal_set['eventcolor'] != '') {
                    $ecolor .= str_replace("<option style='color:$cal_eventcolor' value='$cal_set[eventcolor]'>", "<option selected style='color:$cal_eventcolor' value='$cal_set[eventcolor]'>", $themecolors);
                } else {
                    $ecolor .= str_replace("<option value=''>$lang[calendar_color]</option>", "<option selected value=''>$lang[calendar_color]</option>", $themecolors);
                }
                $ecolor .= "</select>\n";
                
                $secolor = '<select name="sevtcolor">';
                if ($cal_set['special_event_color'] != '') {
                    $secolor .= str_replace("<option style='color:$cal_seventcolor' value='$cal_set[special_event_color]'>", "<option selected style='color:$cal_seventcolor' value='$cal_set[special_event_color]'>", $themecolors);
                } else {
                    $secolor .= str_replace("<option value=''>$lang[calendar_color]</option>", "<option selected value=''>$lang[calendar_color]</option>", $themecolors);
                }
                $secolor .= '</select>';
            } else {
                $bcolor  = "<input type='text' name='bdaycolor' size='10' value='$cal_bdaycolor'>\n";
                $hcolor  = "<input type='text' name='holidaycolor' size='10' value='$cal_holidaycolor'>\n";
                $ecolor  = "<input type='text' name='eventcolor' size='10' value='$cal_eventcolor'>\n";
                $secolor = '<input type="text" name="sevtcolor" size="10" value="'.$cal_set['special_event_color'].'" />';
            }

            $use_theme = "<select name='themes' size='1'>\n";
            $use_theme .= "<option value='$lang[texton]'";
            if ($cal_set['themes'] == $lang['texton']) {
                $use_theme .= " selected='selected' ";
            }

            $use_theme .= ">$lang[texton]</option>\n";
            $use_theme .= "<option value='$lang[textoff]'";
            if ($cal_set['themes'] == $lang['textoff']) {
                $use_theme .= " selected='selected' ";
            }

            $use_theme .= ">$lang[textoff]</option>\n";
            $use_theme .= "</select>\n";

            $day_effect = "<select name='dayeffect' size='1'>\n";
            $day_effect .= "<option value='none'";
            if ($cal_dayeffect == 'none') {
                $day_effect .= " selected='selected' ";
            }

            $day_effect .= ">$lang[textnone]</option>\n";
            $day_effect .= "<option value='raised'";
            if ($cal_dayeffect == 'raised') {
                $day_effect .= " selected='selected' ";
            }

            $day_effect .= ">$lang[textraised]</option>\n";
            $day_effect .= "<option value='sunken'";
            if ($cal_dayeffect == 'sunken') {
                $day_effect .= " selected='selected' ";
            }

            $day_effect .= ">$lang[textsunken]</option>\n";
            $day_effect .= "</select>\n";

            $showbdays = "<select name='showbdays' size='1'>\n";
            $showbdays .= "<option value='off'";
            if ($cal_showbdays == 'off') {
                $showbdays .= " selected='selected' ";
            }

            $showbdays .= ">$lang[textoff]</option>\n";
            $showbdays .= "<option value='on'";
            if ($cal_showbdays == 'on') {
                $showbdays .= " selected='selected' ";
            }

            $showbdays .= ">$lang[texton]</option>\n";
            $showbdays .= "</select>\n";

            $showholidays = "<select name='showholidays' size='1'>\n";
            $showholidays .= "<option value='off'";
            if ($cal_showholidays == 'off') {
                $showholidays .= " selected='selected' ";
            }

            $showholidays .= ">$lang[textoff]</option>\n";
            $showholidays .= "<option value='on'";
            if ($cal_showholidays == 'on') {
                $showholidays.= " selected='selected' ";
            }

            $showholidays .= ">$lang[texton]</option>\n";
            $showholidays .= "</select>\n";

            $showevents = "<select name='showevents' size='1'>\n";
            $showevents .= "<option value='off'";
            if ($cal_showevents == 'off') {
                $showevents.= " selected='selected' ";
            }

            $showevents .= ">$lang[textoff]</option>\n";
            $showevents .= "<option value='list'";
            if ($cal_showevents == 'list') {
                $showevents .= " selected='selected' ";
            }

            $showevents .= ">$lang[textlist]</option>\n";
            $showevents .= "<option value='count'";
            if ($cal_showevents == 'count') {
                $showevents.= " selected='selected' ";
            }

            $showevents .= ">$lang[textcount]</option>\n";
            $showevents .= "</select>\n";

            // Special Event Display
            $sevtdisplay   = array();
            $sevtdisplay[] = '<select name="sevtdisplay">';
            $bSel = $iSel = $uSel = '';
            switch($cal_set['special_event_effect']) {
	            case 'bold':
	                $bSel = ' selected="selected"';
	                break;
	                
	            case 'italic':
	                $iSel = ' selected="selected"';
	                break;
	                
	            case 'underline':
	                $uSel = ' selected="selected"';
	                break;
            }
            
            $sevtdisplay[] = '<option value="bold" style="font-weight: bold;"'.$bSel.'>Bold</option>';
            $sevtdisplay[] = '<option value="italic" style="font-weight: italic;"'.$iSel.'>Italic</option>';
            $sevtdisplay[] = '<option value="underline" style="text-decoration: underline;"'.$uSel.'>Underline</option>';
            $sevtdisplay[] = '</select>';
            $sevtdisplay   = implode("\n", $sevtdisplay);
            // End Special Event Display
            
            $cdisplay = "<select name='display' size='1'>\n";
            $cdisplay .= "<option value='month'";
            if ($cal_display == 'month') {
                $cdisplay .= " selected='selected' ";
            }

            $cdisplay .= ">$lang[calendar_display_month]</option>\n";
            $cdisplay .= "<option value='list'";
            if ($cal_display == 'list') {
                $cdisplay .= " selected='selected' ";
            }

            $cdisplay .= ">$lang[textlist]</option>\n";
            $cdisplay .= "</select>\n";

            $postevents = "<select name='postevents' size='1'>\n";
            $postevents .= "<option value='Super Administrator|Administrator'";
            if ($cal_postevents == "Super Administrator|Administrator") {
                $postevents .= " selected='selected' ";
            }

            $postevents .= ">$lang[textpermission2]</option>\n";
            $postevents .= "<option value='Super Administrator|Administrator|Super Moderator|Moderator'";
            if ($cal_postevents == "Super Administrator|Administrator|Super Moderator|Moderator") {
                $postevents .= " selected='selected' ";
            }

            $postevents .= ">$lang[textpermission3]</option>\n";
            $postevents .= "<option value='Super Administrator|Administrator|Super Moderator|Moderator|Member'";
            if ($cal_postevents == "Super Administrator|Administrator|Super Moderator|Moderator|Member") {
                $postevents .= " selected='selected' ";
            }

            $postevents .= ">$lang[textallmembers]</option>\n";
            $postevents .= "</select>\n";

            $cmembersonly = "<select name='membersonly' size='1'>\n";
            $cmembersonly .= "<option value='0'";
            if ($cal_membersonly == 0) {
                $cmembersonly .= " selected='selected' ";
            }

            $cmembersonly .= ">$lang[texteveryone]</option>\n";
            $cmembersonly .= "<option value='1'";
            if ($cal_membersonly == 1) {
                $cmembersonly .= " selected='selected' ";
            }

            $cmembersonly .= ">$lang[textmembers]</option>\n";
            $cmembersonly.= "</select>\n";
            eval('echo stripslashes("'.template('cal_admin').'");');
        } else {
            $db->query("UPDATE $table_calendar SET showbdays='$showbdays', showholidays='$showholidays', showevents='$showevents', display='$display', postevents='$postevents', membersonly='$membersonly', bdaycolor='$bdaycolor', holidaycolor='$holidaycolor', eventcolor='$eventcolor', dayeffect='$dayeffect', bdayimage='$bdayimage', themes='$themes', special_event_color='$sevtcolor', special_event_effect='$sevtdisplay'");
            echo "<table border='0' width='100%' align='center'><tr class='tablerow'><td align='center'>$lang[calendar_updated]</td></tr></table>\n";
            redirect("calendar.php?month=$month&day=$day&year=$year", 2.5, X_REDIRECT_JS);
        }
    }

    if ($action == 'admin') {
        if (isset($editholidaysubmit) && (X_ADMIN)) {
            $holidaydesc = addslashes($holidaydesc);
            $db->query("UPDATE $table_holidays SET description='$holidaydesc', country='$holidaycountry' WHERE id=$holidayid");
            echo "<table border='0' width='100%' align='center'><tr class='tablerow'><td align='center'>$lang[holidaysupdate]</td></tr></table>\n";
        }

        if (isset($newholiday) && (X_ADMIN)) {
            $newholidaydesc = addslashes($newholidaydesc);
            $db->query("INSERT INTO $table_holidays VALUES ('', '$newholidaydesc', '$monthNames[$month] $day', '$newholidaycountry')");
            echo "<table border='0' width='100%' align='center'><tr class='tablerow'><td align='center'>$lang[holidaysupdate]</td></tr></table>\n";
        } elseif (isset($editholiday) && (X_ADMIN)) {
            if ($holidayid == 'default') {
                $editholiday = '';
            } else {
                $query = $db->query("SELECT * FROM $table_holidays WHERE id='$holidayid'");
                $result = $db->fetch_array($query);
                $db->free_result($query);
                $holidaydesc = stripslashes($result['description']);
                eval('echo stripslashes("'.template('cal_holiday').'");');
            }
        } elseif (isset($deleteholiday) && (X_ADMIN)) {
            if ($holidayid != 'default') {
                $db->query("DELETE FROM $table_holidays WHERE id='$holidayid'");
                echo "<table border='0' width='100%' align='center'><tr class='tablerow'><td align='center'>$lang[holidaysupdate]</td></tr></table>\n";
            }
        }

        if (isset($editeventsubmit)) {
            if ($message != '' && $eventsubject != '') {
                $eventsubject = str_replace("<", "&lt;", $eventsubject);
                $eventsubject = str_replace(">", "&gt;", $eventsubject);
                $message = stripslashes($message);
                $message = addslashes($message);
                $eventsubject = addslashes($eventsubject);

                if (isset($usestarttime)) {
                    if ($startampm == "pm") $starthour += 12;
                    $calstarttime = $starthour . $startminute;
                } else {
                    $calstarttime = '';
                }

                if (isset($useendtime)) {
                    if ($endampm == "pm") $endhour += 12;
                    $calendtime = $endhour . $endminute;
                } else {
                    $calendtime = '';
                }

                if (isset($membersonly)) {
                    $membersonly = 1;
                } else {
                    $membersonly = 0;
                }
                
                $evttype = (isset($evtspecial) && is_numeric($evtspecial) && $evtspecial == 1) ? 'special' : 'normal';
                $posticon = (isset($posticon) && $posticon != '') ? $posticon : '';

                $submittime = $onlinetime;
                $mid = 0;
                if (X_MEMBER) {
                    $query = $db->query("SELECT uid as 'memberid' FROM $table_members WHERE username='$onlineuser'");
                    $result = $db->fetch_array($query);
                    $db->free_result($query);
                    $mid = $result['memberid'];
                }

                if ($eventid == 'new') {
                    $db->query("INSERT INTO $table_events VALUES ('', '$mid', '$evttype', '$onlineuser', '$monthNames[$month] $day, $year', $submittime, $submittime, '$eventsubject', '$message', $membersonly, '', '$calstarttime', '$calendtime', '$posticon')");
                    echo "<table border='0' width='100%' align='center'><tr class='tablerow'><td align='center'>$lang[eventsupdate]</td></tr></table>\n";
                } else {
                    $db->query("update $table_events set type='$evttype', subject='$eventsubject', body='$message', dateupdated=$submittime, membersonly='$membersonly', updatedby='$onlineuser', starttime='$calstarttime', endtime='$calendtime', icon='$posticon' where id=$eventid ");
                    echo "<table border='0' width='100%' align='center'><tr class='tablerow'><td align='center'>$lang[eventsupdate]</td></tr></table>\n";
                }
            } else {
                echo "<table border='0' width='100%' align='center'><tr class='tablerow'><td align='center'>Please enter both an event subject and an event message.</td></tr></table>\n";
            }
        }

        if (isset($newevent)) {
            $neweventsubject = stripslashes($neweventsubject);
            $calstarttime = '';
            $calendtime = '';
            $start_hour = "00";
            $start_minute = "00";
            $start_ampm = "am";
            $end_hour = "00";
            $end_minute = "00";
            $end_ampm = "am";

            $start_time = "<select name='starthour' size='1'>\n";
            for ($hour = 1; $hour <= 12; $hour++) {
                $val_hour = $hour;
                if ($hour < 10) {
                    $val_hour = "0$hour";
                }

                if ($hour == 12) {
                    $val_hour = "00";
                }

                $start_time .= "<option value='$val_hour'";
                if ($val_hour == $start_hour) {
                    $start_time .= " selected='selected' ";
                }

                if ($hour == 12) {
                    $val_hour = "12";
                }
                $start_time .= ">$val_hour</option>\n";
            }

            $start_time .= "</select>\n";
            $start_time .= "<strong>:</strong>\n";
            $start_time .= "<select name='startminute' size='1'>\n";
            for ($minute = 0; $minute < 60; $minute += 5) {
                $val_minute = $minute;
                if ($minute < 10) {
                    $val_minute = "0$minute";
                }

                $start_time .= "<option value='$val_minute'";
                if ($val_minute == $start_minute) {
                    $start_time .= " selected='selected' ";
                }
                $start_time .= ">$val_minute</option>\n";
            }

            $start_time .= "</select>&nbsp;";
            $start_time .= "<select name='startampm' size='1'>\n";
            $start_time .= "<option value='am'";
            if ($start_ampm == "am") {
                $start_time .= " selected='selected' ";
            }

            $start_time .= ">AM</option>\n";
            $start_time .= "<option value='pm'";
            if ($start_ampm == "pm") {
                $start_time .= " selected='selected' ";
            }

            $start_time .= ">PM</option>\n";
            $start_time .= "</select>";

            $ending_time = "<select name='endhour' size='1'>\n";
            for ($hour = 1; $hour <= 12; $hour++) {
                $val_hour = $hour;
                if ($hour < 10) {
                    $val_hour = "0$hour";
                }

                if ($hour == 12) {
                    $val_hour = "00";
                }

                $ending_time .= "<option value='$val_hour'";
                if ($val_hour == $end_hour) {
                    $ending_time .= " selected='selected' ";
                }

                if ($hour == 12) {
                    $val_hour = "12";
                }
                $ending_time .= ">$val_hour</option>\n";
            }

            $ending_time .= "</select>\n";
            $ending_time .= "<strong>:</strong>\n";
            $ending_time .= "<select name='endminute' size='1'>\n";
            for ($minute = 0; $minute < 60; $minute += 5) {
                $val_minute = $minute;
                if ($minute < 10) {
                    $val_minute = "0$minute";
                }

                $ending_time.= "<option value='$val_minute'";
                if ($val_minute == $end_minute) {
                    $ending_time .= " selected='selected' ";
                }
                $ending_time .= ">$val_minute</option>\n";
            }

            $ending_time .= "</select>&nbsp;";
            $ending_time .= "<select name='endampm' size='1'>\n";
            $ending_time .= "<option value='am'";
            if ($end_ampm == "am") {
                $ending_time .= " selected='selected' ";
            }
            $ending_time .= ">AM</option>\n";

            $ending_time .= "<option value='pm'";
            if ($end_ampm == "pm") {
                $ending_time .= " selected='selected' ";
            }
            $ending_time .= ">PM</option>\n";
            $ending_time .= "</select>";
            eval('echo stripslashes("'.template('cal_new_event').'");');
        } elseif (isset($editevent)) {
            if ($eventid == 'default') {
                $editevent = '';
            } else {
               $query = $db->query("SELECT * FROM $table_events WHERE id='$eventid'");
               $result = $db->fetch_array($query);
               $db->free_result($query);

               if (X_ADMIN || $onlineuser == $result['author']) {
                   $eventsubject = stripslashes($result['subject']);
                   $message = stripslashes($result['body']);
                   $calstarttime = $result['starttime'];
                   $calendtime = $result['endtime'];
                   $icon = $result['icon'];
                if ($calstarttime == '') {
                    $start_hour = "00";
                    $start_minute = "00";
                    $start_ampm = "am";
                } else {
                    $start_hour = substr($calstarttime, 0, 2);
                    $start_minute = substr($calstarttime, 2, 2);
                    if (substr($start_hour, 0, 1) == "0") {
                        $start_ampm = "am";
                    } elseif (substr($start_hour, 0, 2) == "10") {
                        $start_ampm = "am";
                    } elseif (substr($start_hour, 0, 2) == "11") {
                        $start_ampm = "am";
                    } else {
                        $start_ampm = "pm";
                        $start_hour -= 12;
                    }
                }

                if ($calendtime == '') {
                    $end_hour = "00";
                    $end_minute = "00";
                    $end_ampm = "am";
                } else {
                    $end_hour = substr($calendtime, 0, 2);
                    $end_minute = substr($calendtime, 2, 2);
                    if (substr($end_hour, 0, 1) == "0") {
                        $end_ampm = "am";
                    } elseif (substr($end_hour, 0, 2) == "10") {
                        $end_ampm = "am";
                    } elseif (substr($end_hour, 0, 2) == "11") {
                        $end_ampm = "am";
                    } else {
                        $end_ampm = "pm";
                        $end_hour -= 12;
                    }
                }

                $membersonly = '';
                if ($result['membersonly'] == 1) {
                    $membersonly = " checked='checked' ";
                }

                $start_enable = "<input type='checkbox' name='usestarttime' value='yes' ";
                if ($calstarttime != '') {
                    $start_enable .= " checked='checked' ";
                }

                $usestart = "<select name='starthour' size='1'>\n";
                for ($hour = 1; $hour <= 12; $hour++) {
                    $val_hour = $hour;
                    if ($hour < 10) {
                        $val_hour = "0$hour";
                    }

                    if ($hour == 12) {
                        $val_hour = "00";
                    }

                    $usestart .= "<option value='$val_hour'";
                    if ($val_hour == $start_hour) {
                        $usestart .= " selected='selected' ";
                    }

                    if ($hour == 12) {
                        $val_hour = "12";
                    }
                    $usestart .= ">$val_hour</option>\n";
                }

                $usestart .= "</select>\n";
                $usestart .= "<strong>:</strong>\n";
                $usestart .= "<select name='startminute' size='1'>\n";
                for ($minute = 0; $minute < 60; $minute += 5) {
                    $val_minute = $minute;
                    if ($minute < 10) {
                        $val_minute = "0$minute";
                    }

                    $usestart .= "<option value='$val_minute'";
                    if ($val_minute == $start_minute) {
                        $eventform .= " selected='selected' ";
                    }
                    $usestart .= ">$val_minute</option>\n";
                }

                $usestart .= "</select>&nbsp;";
                $usestart .= "<select name='startampm' size='1'>\n";
                $usestart .= "<option value='am'";
                if ($start_ampm == "am") {
                    $usestart .= " selected='selected' ";
                }

                $usestart .= ">AM</option>\n";
                $usestart .= "<option value='pm'";
                if ($start_ampm == "pm") {
                    $usestart .= " selected='selected' ";
                }

                $usestart .= ">PM</option>\n";
                $usestart .= "</select>";
                $end_enable = "<input type='checkbox' name='useendtime' value='yes' ";
                if ($calendtime != '') {
                    $end_enable .= " checked='checked' ";
                }

                $useend .= "<select name='endhour' size='1'>\n";
                for ($hour = 1; $hour <= 12; $hour++) {
                    $val_hour = $hour;
                    if ($hour < 10) {
                        $val_hour = "0$hour";
                    }

                    if ($hour == 12) {
                        $val_hour = "00";
                    }

                    $useend .= "<option value='$val_hour'";
                    if ($val_hour == $end_hour) {
                        $eventform .= " selected='selected' ";
                    }

                    if ($hour == 12) {
                        $val_hour = "12";
                    }
                    $useend .= ">$val_hour</option>\n";
                }

                $useend .= "</select>\n";
                $useend .= "<strong>:</strong>\n";
                $useend .= "<select name='endminute' size='1'>\n";
                for ($minute = 0; $minute < 60; $minute += 5) {
                    $val_minute = $minute;
                    if ($minute < 10) {
                        $val_minute = "0$minute";
                    }

                    $useend .= "<option value='$val_minute'";
                    if ($val_minute == $end_minute) {
                        $eventform .= " selected='selected' ";
                    }
                    $useend .= ">$val_minute</option>\n";
                }

                $useend .= "</select>&nbsp;";
                $useend .= "<select name='endampm' size='1'>\n";
                $useend .= "<option value='am'";
                if ($end_ampm == "am") {
                    $useend .= " selected='selected' ";
                }

                $useend .= ">AM</option>\n";
                $useend .= "<option value='pm'";
                if ($end_ampm == "pm") {
                    $useend .= " selected='selected' ";
                }

                $useend .= ">PM</option>\n";
                $useend .= "</select>";

                if ($icon != '') {
                    $icons = str_replace($icon."\"", $icon."\" checked='checked'", $icons);
                }
                
                $specialChecked = '';
                if ($result['type'] == 'special') {
	                $specialChecked = ' checked="checked"';
                }
                $specialevent = '<input type="checkbox" name="evtspecial" value="1"'.$specialChecked.' />&nbsp;';
                
                eval('echo stripslashes("'.template('cal_edit_event').'");');
                }
            }
        } elseif (isset($deleteevent)) {
            if ($eventid != 'default') {
                $query = $db->query("SELECT * FROM $table_events WHERE id='$eventid'");
                $result = $db->fetch_array($query);
                $db->free_result($query);
                if (X_ADMIN || $onlineuser == $result['author']) {
                    $db->query("DELETE FROM $table_events WHERE id='$eventid'");
                    echo "<table border='0' width='100%' align='center'><tr class='tablerow'><td align='center'>$lang[eventsupdate]</td></tr></table>\n";
                }
            }
        }

        if (!isset($newevent) && !isset($editholiday) && !isset($editevent)) {
            $cal_edit_holiday = '';
            if (X_ADMIN) {
                $query = $db->query("SELECT COUNT(*) as Num FROM $table_holidays WHERE monthday='$monthNames[$month] $day' ORDER BY description");
                $result = $db->fetch_array($query);
                $db->free_result($query);
                if ($result['Num'] > 0) {
                    $holid1 = "<select name='holidayid'><option value='default'>$lang[selectholiday]</option>\n";
                    $query = $db->query("SELECT * FROM $table_holidays where monthday = '$monthNames[$month] $day' ORDER BY description");
                    while ($holiday = $db->fetch_array($query)) {
                        $description = stripslashes($holiday['description']);
                        $holid1 .= "<option value='$holiday[id]'>$description";
                        if ($holiday['country']) {
                            $holid1 .= " ($holiday[country])";
                        }
                        $holid1 .= "</option>\n";
                    }
                    $holid1 .= "</select>&nbsp;&nbsp;\n";
                    $db->free_result($query);
                    eval('$cal_edit_holiday = "'.template('cal_edit_holiday').'";');
                }
                eval('$cal_add_holiday = "'.template('cal_add_holiday').'";');
            }

            $mid = 0;
            if (X_ADMIN) {
                $doall = 'true';
            } else {
                $query = $db->query("select uid as 'memberid' from $table_members where username='$onlineuser'");
                $result = $db->fetch_array($query);
                $db->free_result($query);
                $mid = $result['memberid'];
            }

            if (X_ADMIN) {
                $query = $db->query("SELECT COUNT(*) as Num FROM $table_events WHERE eventday = '$monthNames[$month] $day, $year'");
            } else {
                $query = $db->query("SELECT COUNT(*) as Num FROM $table_events WHERE eventday = '$monthNames[$month] $day, $year' and mid='$mid'");
            }
            $result = $db->fetch_array($query);
            $db->free_result($query);

            $cal_event_edit = '';
            if ($result['Num'] > 0) {
                $eventi = "<select name='eventid'><option value='default'>$lang[selectevent]</option>\n";
                if (X_ADMIN) {
                    $query = $db->query("SELECT * FROM $table_events WHERE eventday='$monthNames[$month] $day, $year' ORDER BY subject");
                } else {
                    $query = $db->query("SELECT * FROM $table_events WHERE eventday='$monthNames[$month] $day, $year' AND mid='$mid' ORDER BY subject");
                }
                while ($event = $db->fetch_array($query)) {
                    $subject = stripslashes($event['subject']);
                    $eventi .= "<option value='$event[id]'>$subject";
                    $eventi .= "</option>\n";
                }
                $eventi .= "</select>&nbsp;&nbsp;\n";
                $db->free_result($query);
                eval('$cal_event_edit = "'.template('cal_event_edit').'";');
            }
            eval('echo stripslashes("'.template('cal_add_event').'");');
        }
    }
}

if ($action == 'list') {
    $getevents = '';
    if (X_GUEST) {
        if ($cal_membersonly == 0) {
            if (!$eventid) {
                $query = $db->query("SELECT * FROM $table_events WHERE eventday LIKE '$monthNames[$month] $day, $year' AND membersonly='0' ORDER by subject ");
            } else {
                $query = $db->query("SELECT * FROM $table_events WHERE eventday LIKE '$monthNames[$month] $day, $year' AND membersonly='0' AND id='$eventid'");
            }
            $getevents = 'true';
        }
    } else {
        if (!$eventid) {
            $query = $db->query("SELECT * FROM $table_events WHERE eventday LIKE '$monthNames[$month] $day, $year' ORDER BY subject");
        } else {
            $query = $db->query("SELECT * FROM $table_events WHERE eventday LIKE '$monthNames[$month] $day, $year' AND id='$eventid'");
            $getevents = 'true';
        }
    }

    if ($getevents != '') {
        $eventlist = '';
        while ($event = $db->fetch_array($query)) {
            $author = $event['author'];
            $event['subject'] = stripslashes($event['subject']);
            $timeline = '';
            $calstarttime = $event['starttime'];
            $calendtime = $event['endtime'];
            $icon = $event['icon'];
            if ($calstarttime != '') {
                $start_hour = substr($calstarttime, 0, 2);
                $start_minute  = substr($calstarttime, 2, 2);
                if ($start_hour == "00") { // 00
                    $start_hour = "12";
                    $start_ampm = "am";
                } elseif (substr($start_hour, 0, 1) == "0") { // 01-09
                    $start_hour = substr($start_hour, 1, 1); // ditch the leading 0
                    $start_ampm = "am";
                } elseif (substr($start_hour, 0, 2) == "10") { // 10
                    $start_ampm = "am";
                } elseif (substr($start_hour, 0, 2) == "11") { // 11
                    $start_ampm = "am";
                } elseif (substr($start_hour, 0, 2) == "12") { // 12
                    $start_ampm = "pm";
                } else {
                    $start_hour -= 12;
                    $start_ampm = "pm";
                }

                $timeline .= "$lang[texttime] $start_hour:$start_minute$start_ampm";

                if ($calendtime != '') {
                    $end_hour = substr($calendtime, 0, 2);
                    $end_minute  = substr($calendtime, 2, 2);
                    if ($end_hour == "00") { // 00
                        $end_hour = "12";
                        $send_ampm = "am";
                    } elseif (substr($end_hour, 0, 1) == "0") { // 01-09
                        $end_hour = substr($end_hour, 1, 1); // ditch the leading 0
                        $end_ampm = "am";
                    } elseif (substr($end_hour, 0, 2) == "10") { // 10
                        $end_ampm = "am";
                    } elseif (substr($end_hour, 0, 2) == "11") { // 11
                        $end_ampm = "am";
                    } elseif (substr($end_hour, 0, 2) == "12") { // 12
                        $end_ampm = "pm";
                    } else  {
                        $end_hour -= 12;
                        $end_ampm = "pm";
                    }
                    $timeline .= " - $end_hour:$end_minute$end_ampm";
                }
                $timeline = "<strong>$timeline</strong><br />";
            }

            $eventlist .= "<tr>\n";
            $eventlist .= "<td class='header'>\n";

            if ($icon != '') {
                $eventlist .= "<img src='$smdir/$icon' border='0' align='middle' />&nbsp;";
            }

            $eventlist .= "<strong>$event[subject]:</strong> $lang[textpostby] $author</td>\n";
            $eventlist .= "</tr>\n";
            $eventlist .= "<tr>\n";
            $eventlist .= "<td bgcolor='$altbg1' class='tablerow' align='left'>\n";
            $eventlist .= $timeline;
            $eventlist .= postify(stripslashes($event['body']), 'no', 'no', 'yes', 'no', 'yes', 'yes', 'yes');
            $eventlist .= "<br /><br /><hr color=$bordercolor>\n";

            $postdate = gmdate($dateformat, $event['dateposted'] + ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600));
            $posttime = gmdate($timecode, $event['dateposted'] + ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600));
            $eventlist .= "$lang[event_poston] &nbsp;$postdate $posttime<br />\n";

            if ($event['dateposted'] < $event['dateupdated']) {
                $updatedate = gmdate($dateformat, $event['dateupdated'] + ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600));
                $updatetime = gmdate($timecode, $event['dateupdated'] + ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600));
                $eventlist .= "$lang[event_lastupdated] &nbsp;$updatedate $updatetime $lang[textby] $event[updatedby]<br />\n";
            }
            $eventlist .= "</td></tr>\n";
            $eventlist .= "<tr><td bgcolor='$altbg2' class='tablerow' align='center'>\n";
            if (X_STAFF || $onlineuser == $author) {
                $eventlist .= "<input class='submit' type='button' value='$lang[calendar_editevent]' onclick=\"location.href='calendar.php?action=admin&amp;editevent=edit&amp;eventid=$event[id]'\" style=\"cursor: pointer; cursor: hand;\">\n";
                $eventlist .= "&nbsp;<input class='submit' type='button' value='$lang[calendar_deleteevent]' onclick=\"location.href='calendar.php?action=admin&amp;deleteevent=delete&amp;eventid=$event[id]'\" style=\"cursor: pointer; cursor: hand;\">\n";
            }
        }
        $db->free_result($query);
        eval('echo stripslashes("'.template('cal_eventlist').'");');
    }
}

if (!isset($action)) {
    $monthYear = mktime(0, 0, 0, $month, 1, $year);
    $daysInMonth = date("t", $monthYear);
    $firstDay = date("w", $monthYear) + 1;
    $dayOfMonth = 1;
    $curDay = 1;
    $colWidth = floor(100/7);
    $todayDay = date("d");
    $todayMonth = date("n");
    $todayYear = date("Y");
    $curMonth = $monthNames[$month];
    $bdayMonth = date("m", $monthYear);

    $holidays = array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
    $bdays = array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
    $events = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

    if ($cal_display == 'month') {
        if ($cal_dayeffect == 'sunken'){
            $daystyle = "style='border-style: inset; border-width: 2px;'";
        } elseif ($cal_dayeffect == 'raised') {
            $daystyle = "style='border-style: outset; border-width: 2px;'";
        } else {
            $daystyle = '';
        }

        if ($cal_showbdays == 'on') {
            $query = $db->query("SELECT username, bday FROM $table_members WHERE bday LIKE '%-$bdayMonth-%' ORDER BY username");
            while ($member = $db->fetch_array($query)) {
                $bday = explode('-', $member['bday']);
                $bdayDay = (int) trim($bday[2]);
                $bdayYear = trim($bday[0]);
                $bdayAge = $year - $bdayYear;

                $memlink = '';
                if ($cal_bdayimage != '') {
                    $memlink = "<img src='./images/$cal_bdayimage' border='0' alt='$lang[texthappybday] $member[username]!' title='$lang[texthappybday] $member[username]!' />&nbsp;";
                }

                $memlink .= "<a href='member.php?action=viewpro&amp;member=".rawurlencode($member['username'])."' style='color:$cal_bdaycolor'>$member[username]</a> ($bdayAge)";

                if ($bdays[$bdayDay] == '') {
                    $bdays[$bdayDay] = $memlink;
                } else {
                    $bdays[$bdayDay] .= "<br />$memlink";
                }
            }
            $db->free_result($query);
        }

        if ($cal_showholidays == 'on') {
            $query = $db->query("SELECT * FROM $table_holidays WHERE monthday LIKE '$curMonth%'");
            while ($holiday = $db->fetch_array($query)) {
                $hday = explode(' ', $holiday['monthday']);
                $holidayDay = trim(str_replace(',', '', $hday[1]));
                $holidaytext = stripslashes($holiday['description']);
                if ($holiday['country']) {
                    $holidaytext .= " ($holiday[country])";
                }

                if ($holidays[$holidayDay] == '') {
                    $holidays[$holidayDay] = "<font color='$cal_holidaycolor'>$holidaytext</font>";
                } else {
                    $holidays[$holidayDay] .= "<font color='$cal_holidaycolor'>, $holidaytext</font>";
                }
            }
            $db->free_result($query);
        }

        if ($cal_showevents != 'off') {
            $getevents = '';
            if (X_GUEST) {
                if ($cal_membersonly == 0) {
                    $query = $db->query("SELECT * FROM $table_events WHERE eventday LIKE '$curMonth%$year' AND membersonly='0'");
                    $getevents = "true";
                }
            } else {
                $query = $db->query("SELECT * FROM $table_events WHERE eventday LIKE '$curMonth%$year'");
                $getevents = 'true';
            }

            if ($getevents != '') {
                while ($event = $db->fetch_array($query)) {
                    $ev = explode(' ', $event['eventday']);
                    $e = trim(str_replace(',', '', $ev[1]));

                    if ($cal_showevents == 'count') {
                        $events[$e]++;
                    } else {
	                    $pre = $suff = '';
	                    if ($event['type'] == 'special') {
		                    switch($cal_set['special_event_effect']) {
			                    case 'bold':
			                        $pre  = '<span style="color: '.$cal_seventcolor.';"><strong>';
			                        $suff = '</strong></span>';
			                        break;
			                        
			                    case 'italic':
			                        $pre  = '<span style="color: '.$cal_seventcolor.';"><em>';
			                        $suff = '</em></span>';
			                        break;
			                        
			                    case 'underline':
			                        // W3C sucks for deprecating <u>
			                        $pre  = '<span style="color: '.$cal_seventcolor.'; text-decoration: underline;">';
			                        $suff = '</span>';
			                        break;
		                    }
	                    }
	                    
                        if ($events[$e] == "0") { // first event found for this day
                            $events[$e] = '';
                            if ($event['icon'] != '') {
                                $events[$e] .= "<img src='$smdir/$event[icon]' border='0' align='middle' />&nbsp;";
                            }
                            $events[$e] .= "<a href='calendar.php?action=list&month=$month&amp;day=$e&amp;year=$year&amp;eventid=$event[id]' style='color:$cal_eventcolor'>";
                            $events[$e] .= $pre.stripslashes($event['subject']).$suff;
                            $events[$e] .= "</a>";
                        } else {
                            $events[$e] .= "<br /><br />";
                            if ($event['icon'] != '') {
                                $events[$e] .= "<img src='$smdir/$event[icon]' border='0' align='middle' />&nbsp;";
                            }
                            $events[$e] .= "<a href='calendar.php?action=list&amp;month=$month&amp;day=$e&amp;year=$year&amp;eventid=$event[id]' style='color:$cal_eventcolor'>";
                            $events[$e] .= $pre.stripslashes($event['subject']).$suff;
                            $events[$e] .= "</a>";
                        }
                    }
                }
                $db->free_result($query);
            }
        }

        $calendar  = "<table cellspacing='0' cellpadding='0' border='0' width='$tablewidth' align='center'>\n";
        $calendar .= "<tr><td bgcolor='$bordercolor'>\n";
        $calendar .= "<table border='0' cellspacing='$borderwidth' cellpadding='$tablespace' width='100%' align='center'> \n";
        $calendar .= "<tr><td colspan='7' align='center' class='header'>$monthNames[$month] $year</td></tr>\n";

        $calendar .= " <tr class='category'>\n";
        for ($i = 1; $i <= 7; $i++) {
            $calendar .= "<td align='center' width='$colWidth%'><font color='$cattext'><strong>$dayNames[$i]</strong></font></td>\n";
        }
        $calendar .= "</tr>\n";

        for ($i = 1; $i < $firstDay; $i++) {
            if ($i == 1) {
                $calendar .= "<tr>\n";
            }
            $calendar .= "<td bgcolor='$altbg2'>&nbsp;</td>\n";
            $curDay++;
        }

        $adminDate = '';
        $poststatus = explode('|', $cal_postevents);
        $index = 0;
        while ($poststatus[$index] && !isset($canuserpost)) {
            if ($self['status'] == $poststatus[$index]) $canuserpost = 'yes';
            $index++;
        }

        for ($i = 1; $i <= $daysInMonth; $i++) {
            if ($curDay == 1) {
                $calendar .= "<tr>\n";
            }

            $mouseover = " onmouseover='this.style.backgroundColor=\"$altbg2\";' onmouseout='this.style.backgroundColor=\"$altbg1\";'";

            if ($canuserpost == 'yes') {
                $adminDate = " onclick=\"location.href='calendar.php?action=admin&amp;month=$month&amp;day=$i&amp;year=$year'\" ";
            }

            $eventcount = 0;
            if ($cal_showevents == 'count') {
                if ($events[$i] == 1) {
                    $eventlink = "<a href='calendar.php?action=list&amp;month=$month&amp;day=$i&amp;year=$year' style='color:$cal_eventcolor'>1 $lang[textevent]</a>";
                } elseif ($events[$i] > 1) {
                    $eventlink = "<a href='calendar.php?action=list&amp;month=$month&amp;day=$i&amp;year=$year' style='color:$cal_eventcolor'>$events[$i] $lang[textevents]</a>";
                } else      {
                    $eventlink = '';
                }
            } elseif ($cal_showevents == 'list') {
                if ($events[$i] != "0") {
                    $eventlink = "$events[$i]";
                    $eventcount = count(explode("<br />", $eventlink));
                } else {
                    $eventlink = '';
                }
            } else {
                $eventlink = '';
            }

            if ($year == $todayYear && $month == $todayMonth && $i == $todayDay) {
                $calendar .= "<td bgcolor='$altbg2' class='tablerow' valign='top' $adminDate $daystyle>\n";
                $calendar .= "<div align='left'><strong>[$i]</strong></div><br />\n";
            } else {
                $calendar .= "<td bgcolor='$altbg1' class='tablerow' valign='top' $adminDate $mouseover>\n";
                $calendar .= "<div align='left'><strong>$i</strong></div><br />\n";
            }

            $items = 0;
            if ($holidays[$i] != '') {
                $calendar .= "$holidays[$i]<br />\n";
                $items++;
            }

            if ($eventlink != '') {
                $calendar .= "$eventlink<br />\n";
                $items++;
            }

            if ($bdays[$i] != '') {
                $calendar .= "$bdays[$i]<br />\n";
                $items++;
            }

            for ($lines = $items + $eventcount; $lines < 4; $lines++) {
                $calendar .= "<br />";
            }

            $calendar .= "</td>\n";
            if ($curDay == 7) {
                $calendar .= "</tr>\n";
                $curDay = 1;
            } else {
                $curDay++;
            }
        }

        if ($curDay > 1) {
            for ($i = $curDay; $i <= 7; $i++) {
                $calendar .= "<td bgcolor='$altbg2'>&nbsp;</td>\n";
                if ($i == 7) {
                    $calendar .= "</tr>\n";
                }
            }
        }

        $calendar .= " </tr>\n";
        $calendar .= "</table>\n";
        $calendar .= " </td></tr></table>\n";
    } else {
        if ($cal_showbdays == 'on') {
            $query = $db->query("SELECT username, bday FROM $table_members WHERE bday LIKE '$curMonth%' ORDER BY username");
            while ($member = $db->fetch_array($query)) {
                $bday = explode(' ', $member['bday']);
                $bdayDay = trim(str_replace(',', '', $bday[1]));
                $bdayYear = trim($bday[2]);
                $bdayAge  = $year - $bdayYear;
                $memlink = '';
                if ($cal_bdayimage != '' && file_exists('images/'.$cal_bdayimage) && $bdays[$bdayDay] == '') {
                    $memlink = "<img src='images/$cal_bdayimage' border='0' alt='$lang[texthappybday] $member[username]!' />&nbsp;";
                }
                $memlink .= "<a href='member.php?action=viewpro&amp;member=".rawurlencode($member['username'])."' style='color:$cal_bdaycolor'>$member[username]</a> ($bdayAge)";
                if ($bdays[$bdayDay] == '') {
                    $bdays[$bdayDay] = "<strong>$lang[textbdays]:</strong><br />&nbsp;&nbsp;&nbsp;$memlink";
                } else  {
                    $bdays[$bdayDay] .= "<br />$memlink";
                }
            }
            $db->free_result($query);
        }

        if ($cal_showholidays == 'on') {
            $query = $db->query("SELECT * FROM $table_holidays WHERE monthday LIKE '$curMonth%'");
            while ($holiday = $db->fetch_array($query)) {
                $hday = explode(" ", $holiday['monthday']);
                $holidayDay = trim(str_replace(',', '', $hday[1]));
                $holidaytext = stripslashes($holiday['description']);
                if ($holiday['country']) {
                    $holidaytext .= " ($holiday[country])";
                }

                if ($holidays[$holidayDay] == '') {
                    $holidays[$holidayDay] = "<strong>$lang[calendar_holidays]:</strong><br />&nbsp;&nbsp;&nbsp;<font color='$cal_holidaycolor'>$holidaytext</font>";
                } else {
                    $holidays[$holidayDay] .= "<font color='$cal_holidaycolor'>, $holidaytext</font>";
                }
            }
            $db->free_result($query);
        }

        if ($cal_showevents != 'off') {
            $getevents = '';
            if (X_GUEST) {
                if ($cal_membersonly == 0) {
                    $query = $db->query("SELECT * FROM $table_events WHERE eventday like '$curMonth%$year' AND membersonly='0'");
                    $getevents = 'true';
                }
            } else {
                $query = $db->query("SELECT * FROM $table_events WHERE eventday LIKE '$curMonth%$year'");
                $getevents = 'true';
            }

            if ($getevents != '') {
                while ($event = $db->fetch_array($query)) {
                    $ev = explode(' ', $event['eventday']);
                    $e = trim(str_replace(',', '', $ev[1]));
                    if ($events[$e] == "0") { //first event found for this day
                        $events[$e] = "<strong>$lang[textevents]:</strong><br />\n";
                        $events[$e] .= "&nbsp;&nbsp;&nbsp;";

                        if ($event['icon'] != '') {
                            $events[$e] .= "<img src='$smdir/$event[icon]' border='0' align='middle' />&nbsp;";
                        }

                        $events[$e] .= "<a href='calendar.php?action=list&amp;month=$month&amp;day=$e&amp;year=$year&amp;eventid=$event[id]' style='color:$cal_eventcolor'>";
                        $events[$e] .= stripslashes($event['subject']);
                        $events[$e] .= "</a><br />";
                    } else { // append to list
                        $events[$e] .= "&nbsp;&nbsp;&nbsp;";

                        if ($event['icon'] != '') {
                            $events[$e] .= "<img src='$smdir/$event[icon]' border='0' align='middle' />&nbsp;";
                        }

                        $events[$e] .= "<a href='calendar.php?action=list&amp;month=$month&amp;day=$e&amp;year=$year&amp;eventid=$event[id]' style='color:$cal_eventcolor'>";
                        $events[$e] .= stripslashes($event['subject']);
                        $events[$e] .= "</a><br />";
                    }
                }
                $db->free_result($query);
            }
        }

        $calendar  = "<table cellspacing='0' cellpadding='0' border='0' width='$tablewidth' align='center'>\n";
        $calendar .= "<tr><td bgcolor='$bordercolor'>\n";
        $calendar .= "<table border='0' cellspacing='$borderwidth' cellpadding='$tablespace' width='100%' align='center'> \n";
        $calendar .= "<tr><td colspan='2' align='left' class='header'>$monthNames[$month] $year</td></tr>\n";

        $countdays = 0;
        for ($i = 1; $i <= $daysInMonth; $i++) {
            if ($bdays[$i] != '' || $holidays[$i] != '' || $events[$i] != '') {
                $calendar .= "<tr><td bgcolor='$altbg2' class='tablerow' align='right' valign='top' width='20px'><strong>$i</strong></td>\n";
                $calendar .= "<td bgcolor='$altbg2' class='tablerow' valign='top'>\n";

                if ($holidays[$i] != '') {
                    $calendar .= "$holidays[$i]<br />\n";
                }

                if ($bdays[$i] != '') {
                    $calendar .= "$bdays[$i]<br />\n";
                }

                if ($events[$i] != '') {
                    $calendar .= "$events[$i]\n";
                }
                $calendar .= "</td></tr>\n";
                $countdays++;
            }
        }

        if ($countdays == 0) {
            $calendar .= "<tr><td bgcolor='$altbg1' class='tablerow' align='left' valign='top' colspan='2'>$lang[textnoevents]</td></tr>\n";
        }

        $calendar .= "</table>\n";
        $calendar .= " </td></tr></table>\n";
    }

    $navbar  = "<br /><form action='calendar.php' method='post'>\n";
    $navbar .= "<table cellspacing='0' cellpadding='0' border='0' width='$tablewidth' align='center'>\n";
    $navbar .= "<tr><td bgcolor='$bordercolor'>\n";
    $navbar .= "<table border='0' cellspacing='$borderwidth' cellpadding='$tablespace' width='100%' align='center'>\n";
    $navbar .= "<tr class='category'><td align='center' colspan='3'>\n";
    $navbar .= "<font color='$cattext'><strong>$lang[calendar_navigation]</strong></font>\n";
    $navbar .= "</td></tr>\n";
    $navbar .= "<tr class='tablerow'>\n";

    $lastmonth = $lastyear = 0;

    if ($month == 1) {
        $lastmonth = 12;
        $lastyear = $year - 1;
    } else {
        $lastmonth = $month - 1;
        $lastyear = $year;
    }

    $navbar .= "<td class='nav' bgcolor='$altbg1' width='$colWidth%' align='center'>&laquo;&nbsp;<a href='calendar.php?month=$lastmonth&amp;year=$lastyear'>$monthNames[$lastmonth] $lastyear</a></td>\n";

    $navbar .= "<td bgcolor='$altbg2' align='center'>\n";
    $navbar .= "<select name='month' size='1'>\n";
    for ($i = 1; $i <= 12; $i++) {
        $navbar .= "<option value='$i'";
        if ($month == $i) $navbar .= " selected='selected' ";
        $navbar .= ">$monthNames[$i]</option>\n";
    }

    $navbar .= "</select>\n";
    $navbar .= "&nbsp;";
    $navbar .= "<select name='year' size='1'>\n";
    for ($i = $year - 2; $i <= $year + 2; $i++) {
        $navbar .= "<option value='$i'";
        if ($year == $i) {
            $navbar .= " selected='selected' ";
        }
        $navbar .= ">$i</option>\n";
    }
    $navbar .= "</select>\n";
    $navbar .= "&nbsp;";
    $navbar .= "<input class='submit' type='submit' name='submit' value='$lang[calendar_display]' />\n";

    if (X_ADMIN) {
        $navbar .= "&nbsp;$lang[textadminoptions]&nbsp;<strong>[<a href='calendar.php?action=settings'>$lang[calendar_settings]</a>]</strong>\n";
    }

    $navbar .= "</td>\n";

    $nextmonth = $nextyear = 0;

    if ($month == 12) {
        $nextmonth = 1;
        $nextyear = $year + 1;
    } else {
        $nextmonth = $month + 1;
        $nextyear = $year;
    }

    $navbar .= "<td class='nav' bgcolor='$altbg1' width='$colWidth%' align='center'><a href='calendar.php?month=$nextmonth&amp;year=$nextyear'>$monthNames[$nextmonth] $nextyear</a>&nbsp;&raquo;</td>\n";
    $navbar .= "</tr>\n";
    $navbar .= "</table>\n";
    $navbar .= "</td></tr></table>\n";
    $navbar .= "</form>\n";
    echo $calendar;
    echo $navbar;
}

eval('echo "'.template('cal_copyright').'";');

end_time();
eval('echo "'.template('footer').'";');
?>