<?php

/*
 * Modification Name: Ranking System
 *
 * Modification Version: 1.0
 *
 * Author: nfpunk, GuldanWarlock, John Briggs and WormHole
 *
 * Modification Description: This modification will add a Ranking System that keeps track of wins and losses. It is editable by Staff or members, your choice.
 * 
 * Supported Version: XMB 1.9.5 SP1
 * 
 * Notes:
 * 
 * This modification is released under the GPL v 3. You should have received a copy of it with this software package.
 * 
 * Please backup your files before installing this modification. Neither XMB Garage nor the author can be held 
 * responsible if your board stops functioning properly due to you installing this modification.
 * Author Note:
 * You downloaded this modification from XMBGarage.com, the #1 source for XMB related downloads.
*/

if (!defined('ROOT')) {
    define('ROOT', './');
}

require_once('header.php');
require_once(ROOT.'include/admin.user.inc.php');

loadtemplates(
'error_nologinsession',
'ranking_edit',
'ranking_deny'
);

nav('<a href="cp.php">'.$lang['textcp'].'</a>');
nav($lang['ranking_settings']);

eval('$css = "'.template('css').'";');
eval('echo "'.template('header').'";');
echo '<script language="JavaScript" type="text/javascript" src="./include/admin.js"></script>';

if (!X_ADMIN) {
    eval('echo "'.template('error_nologinsession').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

$auditaction = $_SERVER['REQUEST_URI'];
$aapos = strpos($auditaction, "?");
if ($aapos !== false) {
    $auditaction = substr($auditaction, $aapos + 1);
}
$auditaction = addslashes("$onlineip|#|$auditaction");
audit($xmbuser, $auditaction, 0, 0);

function ValidateRankVars($uid) {
    global $db, $table_members, $member, $tid, $pid, $THEME;
    
    $sameuiderr = str_replace('*TITLE*', $GLOBALS['rsettings']['ranktitle'], $GLOBALS['lang']['ranking_noeditown']);

    if (isset($member) && !empty($member)) {
        $memcheckquery  = $db->query("SELECT uid FROM $table_members WHERE username='$member'");
        $ruid = $db->result($memcheckquery, 0);
        if ($db->num_rows($memcheckquery) != 0) {
            if (isset($tid) && !empty($tid) && is_numeric($tid)) {
                if (isset($pid) && !empty($pid) && is_numeric($pid)) {
                    if ($uid != $ruid) {
                        return true;
                    } else {
                        error($sameuiderr);
                    }
                } else {
                    error('Invalid PostID!');
                }
            } else {
                error('Invalid ThreadID!');
            }
        } else {
            error('Member does not exist!');
        }
    } else {
        error('No Member Specified!');
    }
}

if ($action == 'win') {
    $ranksquery = $db->query("SELECT * FROM $table_ranking_settings");
    $rsettings = $db->fetch_array($ranksquery);
    $db->free_result($ranksquery);

    if (X_GUEST) {
        error('Sorry, Guests are not allowed to edit '.$rsettings['ranktitle']);
    }

    // Check if Ranking is on...
    if ($rsettings['rstatus'] == 'off') {
        error("Sorry, ".$rsettings['ranktitle']."has been turned off!");
    }

    // Make sure all the GET vars are set properly or die...
    ValidateRankVars($self['uid']);

    $xmblistname = $xmbuser.',';
    $rmemcheck = $db->query("SELECT wins, losses, status FROM $table_members WHERE username = '$xmbuser'");
    $rmember = $db->fetch_array($rmemcheck);
    $db->free_result($rmemcheck);

    $xmbliststatus = $rmember['status'].',';
    if (eregi($xmblistname, $rsettings['rallow'])) {
        $specialallow = 'yes';
    } elseif (eregi($xmbliststatus, $rsettings['rallow'])) {
        $specialallow = 'yes';
    } else {
        $specialallow = 'no';
    }

    if ($rmember['status'] == 'Banned') {
        $disallow = 'yes';
    } else {
        $disallow = 'no';
    }

    if ($specialallow == 'yes' && $disallow == 'no') {
        $db->query("UPDATE $table_members SET wins = wins+$rsettings[rincrement] WHERE username = '$member'");
        eval('echo stripslashes("'.template('ranking_edit').'");');
    } else {
        eval('echo stripslashes("'.template('ranking_deny').'");');
    }

    end_time();
    eval('echo "'.template('footer').'";');
    redirect("viewthread.php?tid=$tid#pid$pid", 2, X_REDIRECT_JS);
} elseif ($action == 'lose') {
    $ranksquery = $db->query("SELECT * FROM $table_ranking_settings");
    $rsettings = $db->fetch_array($ranksquery);
    $db->free_result($ranksquery);

    if (X_GUEST) {
        error('Sorry, Guests are not allowed to edit '.$rsettings['ranktitle']);
    }

    // Check if Ranking is on...
    if ($rsettings['rstatus'] == 'off') {
        error("Sorry! ".$rsettings['ranktitle']."has been turned off!");
    }

    eval('$css = "'.template('css').'";');

    // Make sure all the GET vars are set properly or die...
    ValidateRankVars($self['uid']);

    eval('echo ("'.template('header').'");');

    $xmblistname = $xmbuser.',';
    $rmemcheck = $db->query("SELECT wins, losses, status FROM $table_members WHERE username = '$xmbuser'");
    $rmember = $db->fetch_array($rmemcheck);
    $db->free_result($rmemcheck);

    $xmbliststatus = $rmember['status'].',';
    if (eregi($xmblistname, $rsettings['rallow'])) {
        $specialallow = 'yes';
    } elseif (eregi($xmbliststatus, $rsettings['rallow'])) {
        $specialallow = 'yes';
    } else {
        $specialallow = 'no';
    }

    if ($rmember['status'] == 'Banned') {
        $disallow = 'yes';
    } else {
        $disallow = 'no';
    }

    if ($specialallow == 'yes' && $disallow == 'no') {
        $db->query("UPDATE $table_members SET losses=losses+$rsettings[rincrement] WHERE username='$member'");
        eval('echo stripslashes("'.template('ranking_edit').'");');
    } else {
        eval('echo stripslashes("'.template('ranking_deny').'");');
    }

    end_time();
    eval('echo "'.template('footer').'";');
    redirect("viewthread.php?tid=$tid#pid$pid", 2, X_REDIRECT_JS);
} elseif ($action == 'settings') {
    if (!X_ADMIN) {
        eval('echo "'.template('error_nologinsession').'";');
        end_time();
        eval('echo "'.template('footer').'";');
        exit;
    }

    displayAdminPanel();

    if (!isset($_POST['rankingsubmit']) || empty($_POST['rankingsubmit'])) {
        $rquery  = $db->query("SELECT * FROM $table_ranking_settings");
        $ranking = $db->fetch_array($rquery);
        $db->free_result($rquery);

        $rtitle = $ranking['ranktitle'];
        $rtitle = isset($rtitle) ? checkInput($rtitle, '', '', 'javascript', false) : '';
        $rwin = $ranking['wintitle'];
        $rwin = isset($rwin) ? checkInput($rwin, '', '', 'javascript', false) : '';
        $rlose = $ranking['losetitle'];
        $rlose = isset($rlose) ? checkInput($rlose, '', '', 'javascript', false) : '';
        $rincrement = $ranking['rincrement'];
        $rallow = $ranking['rallow'];
        $rstatus = $ranking['rstatus'];
        $selHTML = 'selected="selected"';

        $renabled = $rdisabled = '';
        if ($rstatus == 'on') {
            $renabled = $selHTML;
        } elseif ($rstatus == 'off') {
            $rdisabled = $selHTML;
        }
        ?>
        <tr bgcolor="<?php echo $THEME[altbg2]?>">
        <td align="center">
        <form method="post" action="ranking.php?action=settings">
        <table border="0" cellspacing="<?php echo $THEME[borderwidth]?>" cellpadding="<?php echo $THEME[tablespace]?>" width="100%">
        <tr class="category">
        <td colspan="2"><strong><font color="<?php echo $THEME[cattext]?>">&raquo;&nbsp;<?php echo $lang['ranking_settings']?></font></strong></td>
        </tr>
        <tr class="tablerow">
        <td bgcolor="<?php echo $THEME[altbg1]?>"><?php echo $lang['ranking_status']?></td>
        <td bgcolor="<?php echo $THEME[altbg2]?>">
        <select name="rstatusnew" size="1">
        <option value="on" <?php echo $renabled?>><?php echo $lang['ranking_enabled']?></option>
        <option value="off" <?php echo $rdisabled?>><?php echo $lang['ranking_disabled']?></option>
        </select>
        </td>
        </tr>
        <tr class="tablerow">
        <td bgcolor="<?php echo $THEME[altbg1]?>" width="22%"><?php echo $lang['ranking_name']?></td>
        <td bgcolor="<?php echo $THEME[altbg2]?>"><input type="text" name="rtitle" size="30" value=<?php echo $rtitle?> /></td>
        </tr>
        <tr class="tablerow">
        <td bgcolor="<?php echo $THEME[altbg1]?>" width="22%"><?php echo $lang['ranking_winname']?></td>
        <td bgcolor="<?php echo $THEME[altbg2]?>"><input type="text" name="rwin" size="30" value=<?php echo $rwin?> /></td>
        </tr>
        <tr class="tablerow">
        <td bgcolor="<?php echo $THEME[altbg1]?>" width="22%"><?php echo $lang['ranking_losename']?></td>
        <td bgcolor="<?php echo $THEME[altbg2]?>"><input type="text" name="rlose" size="30" value=<?php echo $rlose?> /></td>
        </tr>
        <tr class="tablerow">
        <td bgcolor="<?php echo $THEME[altbg1]?>" width="22%"><?php echo $lang['ranking_increment']?></td>
        <td bgcolor="<?php echo $THEME[altbg2]?>"><input type="text" name="rincrement" size="30" value=<?php echo $rincrement?> /></td>
        </tr>
        <tr class="tablerow">
        <td bgcolor="<?php echo $THEME[altbg1]?>" width="22%"><?php echo $lang['ranking_edit']?></td>
        <td bgcolor="<?php echo $THEME[altbg2]?>">
        <textarea name="rallow" rows="5" cols="70"><?php echo $rallow?></textarea>
        <br />
        <?php echo $lang['ranking_commanote']?>.
        </td>
        </tr>
        <tr>
        <td class="ctrtablerow" bgcolor="<?php echo $THEME[altbg2]?>" colspan="2"><input class="submit" type="submit" name="rankingsubmit" value="<?php echo $lang['textsubmitchanges']?>" /></td>
        </tr>
        </table>
        </td>
        </tr>
        </table>
        </form>
        </td>
        </tr>
        <?php
    } else {
        $rtitle = isset($rtitle) ? checkInput($rtitle, '', '', 'javascript', false) : '';
        $rwin = isset($rwin) ? checkInput($rwin, '', '', 'javascript', false) : '';
        $rlose = isset($rlose) ? checkInput($rlose, '', '', 'javascript', false) : '';

        $db->query("UPDATE $table_ranking_settings SET
            ranktitle = '$rtitle',
            wintitle = '$rwin',
            losetitle = '$rlose',
            rincrement = '$rincrement',
            rallow = '$rallow',
            rstatus = '$rstatusnew'
        ");

        echo '<tr bgcolor="'.$THEME['altbg2'].'" class="ctrtablerow"><td>'.$lang['ranking_updatesuccessful'].'</td></tr>';
        redirect('ranking.php?action=settings', 2, X_REDIRECT_JS);
    }
} else {
    error($lang['noaction']);
}

echo "</table></td></tr></table>";
end_time();
eval('echo "'.template('footer').'";');
?>