<?php
/*  File Id: backupcp.php, V1.0, 12/11/2005 18:20 (GMT) */
/*
    Advanced DB Backup Mod V1.0
     2004 - 2005 Adam Clarke
    http://www.xmbservices.com

    Designed For Use With XMB 1.9.3
     2001 - 2005 Aventure Media & The XMB Development Team
    http://www.aventure-media.co.uk
    http://www.xmbforum.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// User editable settings.

// Database Info

  $config['db_username'] = ''; // Enter the username for the db(s) here. You do not have to use the same user as the forum.
  $config['db_password'] = ''; // Enter the password for the username above here
  $config['db_name'] = ''; // Enter the database name here.

// Backup Info

  $config['backup_compression'] = 'bzip2'; // ('none', 'gzip', 'bzip2')
  $config['backup_location'] = '/home/#USER#/db_backups/';
  
// FTP Info

  $config['use_ftp'] = '0'; // ('0' = No, '1' = Yes)
  $config['ftp_server'] = ''; // Enter the ftp address for remote transfer here.
  $config['ftp_username'] = ''; // Enter the ftp username for remote transfer here.
  $config['ftp_password'] = ''; // Enter the ftp password for remote transfer here.
  $config['ftp_path'] = ''; // Enter FTP path here (eg: 'public_html/')
  $config['ftp_passive'] = '0'; // Use passive FTP? ('0' = No, '1' = Yes)

// E-mail Info

  $config['use_email'] = '0'; // ('0' = No, '1' = Yes)
  $config['email_address'] = ''; // Enter e-mail address here.

// Auto Delete Info

  $config['local_delete'] = '1'; // Enter number of days to keep local backup's. ('0' = No Delete)
  $config['ftp_delete'] = '1'; // Enter number of days to keep remote backup's. ('0' = No Delete)


// DO NOT EDIT BELOW THIS LINE UNLESS YOU KNOW WHAT YOU ARE DOING !

// Lets see if the scipt is being run from SHELL.

  if(isset($argv[1])) {
      define('IN_SHELL', true);
  } else {
      define('IN_SHELL', false);
  }

// Require files.
require "header.php";
require "./include/admin.inc.php";

// loadtemplates('error_nologinsession');

nav($lang['textcp']);

// Security check to ensure non authorised people can not view this page.
if (!X_ADMIN && !IN_SHELL) {
    eval("\$css = \"".template("css")."\";");
    eval("echo (\"".template('header')."\");");
    eval('echo stripslashes("'.template('error_nologinsession').'");');
    end_time();
    eval("echo (\"".template('footer')."\");");
    exit();
}

if (!IN_SHELL) {
    $auditaction = $_SERVER['REQUEST_URI'];
    $aapos = strpos($auditaction, "?");
    if ($aapos !== false) {
        $auditaction = substr($auditaction, $aapos + 1);
    }
    $auditaction = addslashes("$onlineip|#|$auditaction");
    audit($xmbuser, $auditaction, 0, 0);
}

if (!isset($action)) {
    $action = '';
}

// Clear out old backups (If Required)
if ($config['local_delete'] > 0) {
    $handle = opendir($config['backup_location']);
    $timecut = time() - ($config['local_delete'] * 86400);
    while(false !== ($file = readdir($handle))) {
        if ($file != "." && $file != "..") {
            $file_info = explode(".", $file);
            if(isset($file_info[2]) && ($file_info[2] == 'sql' || $file_info[2] == 'info')) {
                if(($file_info[1] < $timecut)) {
                     unlink($config['backup_location'] . $file);
                }
            }
        }
    }
}

if ($config['ftp_delete'] > 0 && $config['use_ftp'] == 1 && function_exists('ftp_connect')) {
    $ftp_connection = @ftp_connect($config['ftp_server']);
    $ftp_login_result = @ftp_login($ftp_connection, $config['ftp_username'], $config['ftp_password']);
    if ($ftp_login_result && $ftp_connection) {
        if ($config['ftp_passive'] == '1') {
            ftp_pasv($ftp_connection, 'TRUE');
        }
        // find the time to remove ftp backups backups
        $timecut = time() - ($config['ftp_delete'] * 86400);

        // get the file list
        $ftp_files_array = ftp_nlist($ftp_connection, $config['ftp_path']);
        if ($ftp_files_array != 'FALSE') {
            while(list($file_id,$file_name)=each($ftp_files_array)) {
                $tmp_file = explode("/", $file_name);
                $ftp_file = $tmp_file[sizeof($tmp_file)-1];
                $file_info_arr = explode(".",$ftp_file);
                $filtype = isset($file_info_arr[2]) ? $file_info_arr[2] : '';
                if ($filtype=="sql") {
                    if (($file_info_arr[1] < $timecut) && ($config['ftp_delete'] != 0)) {
                        ftp_delete ($ftp_connection,$config['ftp_path']."/".$ftp_file);
                    }
                }
            }
        }
        // close the FTP stream
        if (function_exists('ftp_close')) {
            ftp_close($ftp_connection);
        }
    }
}

if ($action == "download") {
    if (isset($_GET['file']) && !empty($_GET['file']) && file_exists($config['backup_location'] . $_GET['file'])) {

        // Generate $type, $name and $size vars
        $file_name = $_GET['file'];
        $file_type = filetype($config['backup_location'] . $_GET['file']);
        $file_size = (int) filesize($config['backup_location'] . $_GET['file']);
        $file_content = fread( fopen($config['backup_location'] . $_GET['file'], 'rb'), filesize($config['backup_location'] . $_GET['file']));

        // Make sure text/html types can't be run...
        $file_type = ($file_type == 'text/html') ? 'text/plain' : $file_type;

        // Put out headers for mime-type, filesize, forced-download, description and no-cache.
        header("Content-type: application/download");
        header("Content-length: $file_size");
        header("Content-Disposition: attachment; filename=$file_name");
        header("Content-Description: XMB Advanced Database Backup");
        header("Cache-Control: public; max-age=604800"); // http 1.1
        header("Expires: 604800"); // http 1.0

        // Start file download
        echo $file_content;

        // End download
        exit();

    } else {
        eval("\$css = \"".template("css")."\";");
        eval("echo (\"".template('header')."\");");

        displayAdminPanel();

        if (isset($_GET['file'])) {
            echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br />The file \"$_GET[file]\" does not exist.</td></tr>";
        } else {
            echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br />No file selected.</td></tr>";
        }
        echo "</table></td></tr></table>";
        end_time();
        eval("echo (\"".template('footer')."\");");
        exit();
    }
}

eval("\$css = \"".template("css")."\";");

if (!IN_SHELL) {
    eval("echo (\"".template('header')."\");");
    
    displayAdminPanel();
}

ob_flush();

if ($action == 'backup' || IN_SHELL) {
    if(isset($backupsubmit) || IN_SHELL) {
        @set_time_limit(0);

        $db_time = '.' . time();

        if (IN_SHELL) {
            $db_name = $argv[1];
            $db_compression = $config['backup_compression'];
            $db_tables = array('all');
            $db_data = 'yes';

            $use_ftp = $config['use_ftp'];
            $ftp_server = $config['ftp_server'];
            $ftp_username = $config['ftp_username'];
            $ftp_password = $config['ftp_password'];
            $ftp_path = $config['ftp_path'];

            $use_email = $config['use_email'];
            $email_address = $config['email_address'];
        } else {
            $db_name = (isset($_POST['db_name']) && !empty($_POST['db_name'])) ? $_POST['db_name'] : $config['db_name'];
            $db_compression = (isset($_POST['db_compression']) && !empty($_POST['db_compression'])) ? $_POST['db_compression'] : $config['backup_compression'];
            $db_tables = (isset($_POST['db_tables']) && !empty($_POST['db_tables'])) ? $_POST['db_tables'] : array('all');
            $db_data = $_POST['db_data'] == 'no' ? 'no' : 'yes';

            $use_ftp = $_POST['use_ftp'] == '1' ? '1' : '0';
            $ftp_server = isset($_POST['ftp_server']) && !empty($_POST['ftp_server']) ? $_POST['ftp_server'] : $config['ftp_server'];
            $ftp_username = (isset($_POST['ftp_user']) && !empty($_POST['ftp_user'])) ? $_POST['ftp_user'] : $config['ftp_username'];
            $ftp_password = (isset($_POST['ftp_pass']) && !empty($_POST['ftp_pass'])) ? $_POST['ftp_pass'] : $config['ftp_password'];
            $ftp_path = (isset($_POST['ftp_path']) && !empty($_POST['ftp_path'])) ? $_POST['ftp_path'] : $config['ftp_path'];

            $use_email = $_POST['use_email'] == '1' ? '1' : '0';
            $email_address = (isset($_POST['email_address']) && !empty($_POST['email_address'])) ? $_POST['email_address'] : $config['email_address'];
        }

        if ($db_compression == 'gzip') {
            $backup_ext = '.sql.gz';
            $backup_command = '| gzip -c >';
            $info_compression = 'Gzip';
        } elseif ($db_compression == 'bzip2') {
            $backup_ext = '.sql.bz2';
            $backup_command = '| bzip2 -c >';
            $info_compression = 'Bzip 2';
        } else {
            $backup_ext = '.sql';
            $backup_command = '>';
            $info_compression = 'None';
        }

        $sql_filename = $db_name . $db_time . $backup_ext;
        $info_filename = $db_name . $db_time . '.info';

        if (is_array($db_tables) && !in_array('all', $db_tables)) {
            $backup_tables = implode(' ', $db_tables);
            $info_tables = implode(', ', $db_tables);
        } else {
            $backup_tables = '';
            $info_tables = 'all';
        }

        if ($db_data == 'no') {
            $backup_data = '-d';
            $info_data = 'No';
        } else {
            $backup_data = '';
            $info_data = 'Yes';
        }

        $info_file = fopen($config['backup_location'] . $info_filename, "w");
        fwrite($info_file, "$info_tables|$info_data");
        fclose($info_file);
        exec("mysqlcheck --auto-repair garage_xmb19");
        exec("mysqldump -Q --opt --skip-lock-tables --compress -f $backup_data -u$config[db_username] -p$config[db_password] $db_name $backup_tables $backup_command $config[backup_location]$sql_filename");

        // E-mail backup (If Required)
        if ($use_email == "1") {
            $Send_Date = gmdate("j F Y");
            $subject = "XMB Advanced Database Backup - $Send_Date";
            $message = "XMB Advanced Database Backup has backed up your MySQL database to " . $config['backup_location'] . $sql_filename . " and attached a copy to this email";
            $fileatt_type = filetype($config['backup_location'] . $sql_filename);
            $fileatt_name = $sql_filename;
            $headers = "From: " . $SETTINGS['adminemail'];

            // Read the file to be attached ('rb' = read binary)
            $file = fopen($config['backup_location'] . $sql_filename,'rb');
            $data = fread($file, filesize($config['backup_location'] . $sql_filename));
            fclose($file);
	
            // Generate a boundary string
            $semi_rand = md5(time());
            $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
	
            // Add the headers for a file attachment
            $headers .= "\nMIME-Version: 1.0\n" ."Content-Type: multipart/mixed;\n" ." boundary=\"{$mime_boundary}\"";

            // Add a multipart boundary above the plain message
            $message = "This is a multi-part message in MIME format.\n\n" ."--{$mime_boundary}\n" ."Content-Type: text/plain; charset=\"iso-8859-1\"\n" ."Content-Transfer-Encoding: 7bit\n\n" .
            $message . "\n\n";
	
            // Base64 encode the file data
            $data = chunk_split(base64_encode($data));

            // Add file attachment to the message
            $message .= "--{$mime_boundary}\n" ."Content-Type: {$fileatt_type};\n" ." name=\"{$fileatt_name}\"\n" ."Content-Disposition: attachment;\n" ." filename=\"{$fileatt_name}\"\n" ."Content-Transfer-Encoding: base64\n\n" .
            $data . "\n\n" ."--{$mime_boundary}--\n";
            // Send the message
            mail($config['email_address'], $subject, $message, $headers);
        }

        // Transfer backup via FTP (If Required)
        if ($use_ftp == '1' && function_exists('ftp_connect')) {
            $ftp_connection = @ftp_connect($config['ftp_server']);
            $ftp_login_result = @ftp_login($ftp_connection, $config['ftp_username'], $config['ftp_password']);
            if ($ftp_login_result && $ftp_connection) {
                if ($config['ftp_passive'] == '1') {
                    ftp_pasv($ftp_connection, 'TRUE');
                }
                $file = fopen($config['backup_location'] . $sql_filename, 'r');
                ftp_fput($ftp_connection, $config['ftp_path'] . $sql_filename, $file, FTP_BINARY);
                ftp_close($ftp_connection);
                fclose($file);
            }
        }

        if (!IN_SHELL) {
            echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">";
        }
        
        echo "File successfully saved to: $config[backup_location]$sql_filename.\n";
        if ($use_email == "1") {
           echo "<br />File successfully e-mailed to: $config[email_address].";
        }

        if ($use_ftp == '1' && function_exists('ftp_connect')) {
           echo "<br />File successfully transfered via FTP to: $config[ftp_server].";
        }

        if (!IN_SHELL) {
            echo "</td></tr>";
        }
    } else {
        echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br /><br />No options selected.</td></tr>";
    }

} elseif ($action == "restore") {
    if (isset($_GET['file'])) {
        if (file_exists($config['backup_location'].$_GET['file'])) {
            $file_info=explode(".", $_GET['file']);
            $file_db = $file_info[0];

            $file = $config['backup_location'].$_GET['file'];

            if (strpos($file, '.bz2')) {
                exec("bzip2 -d $file");
                $file = str_replace('.bz2', '', $file);
            } elseif(strpos($file, '.gz')) {
                exec("gzip -d $file");
                $file = str_replace('.gz', '', $file);
            }

            exec("mysql -u$config[db_username] -p$config[db_password] -f $file_db < $file");

            echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">File successfully restored.</td></tr>";
        } else {
            echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br />The file \"$file\" does not exist.</td></tr>";
        }
    } else {
        echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br />No file selected.</td></tr>";
    }

} elseif ($action == "deletefile") {
    if (isset($_GET['file'])) {
        if (file_exists($config['backup_location'].$_GET['file'])) {
            $file_info1=explode(".", $_GET['file']);
            $file_db = $file_info1[0];
            $file_time = $file_info1[1];
            $sql_file = $config['backup_location'].$_GET['file'];
            $info_file = $config['backup_location'].$file_db.".".$file_time.".info";
            unlink($sql_file);
            if (file_exists($info_file)) {
                unlink($info_file);
            }
            echo"File was successfully removed.<br>\n";
            redirect('./backupcp.php', 2);
        } else {
            echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br />The file \"$file\" does not exist.</td></tr>";
        }
    } else {
        echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br />No file selected.</td></tr>";
    }

} elseif ($action == "compressfile") {
    if (isset($_GET['file'])) {
        if (file_exists($config['backup_location'].$_GET['file'])) {
            $file = $config['backup_location'].$_GET['file'];
            if (strpos($file, '.bz2')) {
                exec("bzip2 -d $file");
                $file = str_replace('.bz2', '', $file);
                $old_compression = 'Bzip2';
            } elseif(strpos($file, '.gz')) {
                exec("gzip -d $file");
                $file = str_replace('.gz', '', $file);
                $old_compression = 'Gzip';
            } else {
                $old_compression = 'None';
            }


            if ($_GET['compression'] == 'bzip2') {
                exec("bzip2 $file");
                $new_compression = 'Bzip2';
            } elseif($_GET['compression'] == 'gzip') {
                exec("gzip $file");
                $new_compression = 'Gzip';
            } else {
                $new_compression = 'None';
            }

            echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">File compression successfully changed from '$old_compression' to '$new_compression'.</td></tr>";
        } else {
            echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br />The file \"$file\" does not exist.</td></tr>";
        }
    } else {
        echo "<tr bgcolor=\"$THEME[altbg2]\" class=\"tablerow\"><td align=\"center\">An error occured.<br />No file selected.</td></tr>";
    }

} else {
    ?>
    <tr bgcolor="<?php echo $THEME[altbg2]?>">
    <td align="center">
    <br />

    <script language="JavaScript" type="text/javascript">
    // <![CDATA[

    //Setup Hack Array in format ("'DisplayName','systemname','defaultSelected','selected'", ... )
    Array['Default']= new Array("'Select Database . . .',''");

    <?php
    $db_selection = "<select name=\"db_name\" onChange=\"updateTables(this[this.selectedIndex].value)\">";
    $db_selection .= "<option value=\"\">Please Select . . .</option>";

    $db_list = mysql_list_dbs();
    while ($database = $db->fetch_row($db_list)) {
        if (@mysql_select_db($database['0'])) {
            $db_selection .= "<option value=\"$database[0]\">$database[0]</option>";
            echo "Array['" . $database['0'] . "'] = new Array(\"'All Tables','all'\", \"'----------------------------------------','all'\"";
            $db_tables = mysql_list_tables($database['0']);
            while ($table = $db->fetch_row($db_tables)) {
                echo ", \"'" . $table['0'] . "','" . $table['0'] . "'\"";
            }
            echo ");";
        }
    }
    ?>

    //Inline Update Function in format (value that is currently selected, form list to load)
    function updateTables(selected)
     {
      //This runs the load if an array is selected
      if (selected =="")
       {
        updateTables('Default');
       }
      else
       {
        //This loads the name of the array into selected
        var selectedArray = eval( "Array['" + selected + "']");

        var dbtables = 'db_tables[]';

        //This is reset the drop down to be empty so that is can be refilled
        document.db_backup.db_tables.options.length = 0;

        //This loads the selected array into the form list
        for (var i=0; i < selectedArray.length; i++)
         {
          document.db_backup.db_tables.options[i] = eval("new Option(" + selectedArray[i] + ")");
         }
       }
     } 

    // ]]>
    </script>

    <?php
    $handle = opendir($config['backup_location']);
    $backup_files = array();

    while (false !== ($file = readdir($handle))) {
        if ($file != "." && $file != "..") {
            $file_info = explode(".",$file);
            if (isset($file_info[2]) && $file_info[2] == "sql") {
                $backup_files[]=$file;
            }
        }
    }

    $printed_titles = array();
    $closetables = '';

    natsort($backup_files);
    foreach($backup_files as $file) {

        $bzip2compression = $gzipcompression = $nocompression = '';
        if (strpos($file, '.bz2')) {
            $bzip2compression = 'selected="selected"';
        } elseif (strpos($file, '.gz')) {
            $gzipcompression = 'selected="selected"';
        } else {
            $nocompression = 'selected="selected"';
        }

        $compressfile = "<select name=\"compression\" onchange=\"if(this.options[this.selectedIndex].value != '') { window.location=('backupcp.php?action=compressfile&amp;compression='+this.options[this.selectedIndex].value+'&amp;file=$file') }\">";
        $compressfile .= "<option value=\"none\" $nocompression>None</option>";
        $compressfile .= "<option value=\"gzip\" $gzipcompression>Gzip</option>";
        $compressfile .= "<option value=\"bzip2\" $bzip2compression>Bzip2</option>";
        $compressfile .= "</select>";

        $file_info1=explode(".", $file);
        $file_db = $file_info1[0];
        $file_time = $file_info1[1];

        $info_file = $file_db . '.' . $file_time . '.info';

        if (file_exists($config['backup_location'] . $info_file)) {
            $file_info_tmp = implode("", file($config['backup_location'] . $info_file));
            $file_info = explode("|", $file_info_tmp);
            $tables_list = $file_info[0];
            if ($tables_list == 'all') {
                $tables = 'All';
            } elseif ($tables_list != '') {
                $tables = "<a href=\"javascript:alert('$tables_list')\">Selection</a>";
            } else {
                $tables = 'None';
            }
            $data = $file_info[1];
        } else {
            $tables = 'Unknown';
            $data = 'Unknown';
        }

        if (!isset($printed_titles[$file_db])) {
            $printed_titles[$file_db]=1;
            echo $closetables;
            ?>
            <table cellspacing="0" cellpadding="0" border="0" width="800" align="center">
            <tr>
            <td bgcolor="<?php echo $THEME['bordercolor']?>">
            <table border="0" cellspacing="<?php echo $THEME['borderwidth']?>" cellpadding="<?php echo $THEME['tablespace']?>" width="100%">
            <tr class="category">
            <td colspan="9" width="100%" align="center"><font color="<?php echo $THEME['cattext']?>"><strong>Database: <?php echo $file_db?></strong></font></td></tr>
            <tr>
            <td class="header" align="center"><strong>File Name</strong></font></td>
            <td class="header" align="center"><strong>Backup Date</strong></font></td>
            <td class="header" align="center"><strong>Tables</strong></font></td>
            <td class="header" align="center"><strong>Data</strong></font></td>
            <td class="header" align="center"><strong>File Size</strong></font></td>
            <td class="header" align="center"><strong>Compression</strong></font></td>
            <td class="header" align="center"><strong>Download</strong></font></td>
            <td class="header" align="center"><strong>Restore</strong></font></td>
            <td class="header" align="center"><strong>Delete</strong></font></td>
            </tr>

            <?php
            $closetables = '</table></td></tr></table><br>';
        }
        $filesize = filesize($config['backup_location'].$file);
        if ($filesize >= 1073741824) {
            $filesize = round($filesize / 1073741824 * 100) / 100 . " gb";
        } elseif ($filesize >= 1048576) {
            $filesize = round($filesize / 1048576 * 100) / 100 . " mb";
        } elseif ($filesize >= 1024) {
            $filesize = round($filesize / 1024 * 100) / 100 . " kb";
        } else {
            $filesize = $filesize . " b";
        }

        $file_date = gmdate("$dateformat $timecode", $file_time + ($timeoffset * 3600) + ($addtime * 3600));

        ?>
        <tr bgcolor="<?php echo $THEME['altbg1']?>" class="tablerow">
        <td align="left"><img src="<?php echo $THEME['imgdir']?>/ipost.gif"> <?php echo $file?></td>
        <td align="center"><?php echo $file_date?></td>
        <td align="center"><?php echo $tables?></td>
        <td align="center"><?php echo $data?></td>
        <td align="center"><?php echo $filesize?></td>
        <td align="center"><?php echo $compressfile?></td>
        <td align="center"><a href="backupcp.php?action=download&file=<?php echo $file?>" onclick="return confirm('Do you really want to download file: <?php echo $file?>?')" target="_blank">Download</a></td>
        <td align="center"><a href="backupcp.php?action=restore&file=<?php echo $file?>" onclick="return confirm('Do you really want to restore file: <?php echo $file?> into database: <?php echo $file_db?>?')">Restore</a></td>
        <td align="center"><a href="backupcp.php?action=deletefile&file=<?php echo $file?>" onclick="return confirm('Do you really want to delete backup: <?php echo $file ?>?')"><img src="<?php echo $imgdir?>/delete_db.gif" border="0" alt="Delete this backup"></a></td>
        </tr>
        <?php
    }
    echo $closetables;
    ?>

    </td>
    </tr>

    <tr bgcolor="<?php echo $THEME['altbg1']?>">
    <td align="center">
    <br />

    <form name="db_backup" method="post" action="backupcp.php?action=backup">
    <table cellspacing="0" cellpadding="0" border="0" width="800" align="center">
    <tr>
    <td bgcolor="<?php echo $THEME['bordercolor']?>">
    <table border="0" cellspacing="<?php echo $THEME['borderwidth']?>" cellpadding="<?php echo $THEME['tablespace']?>" width="100%">

    <tr class="category">
     <td colspan="6" width="100%" align="center"><font color="<?php echo $THEME['cattext']?>"><strong>Create New Backup</strong></font></td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>" width="20%">Database:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>" width="80%">
      <?php echo $db_selection?>
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">Tables:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <select name="db_tables[]" id="db_tables" multiple="multiple">
       <option value="" selected="selected">Select Database . . .</option>
      </select>
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">Compression:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <select name="db_compression">
       <option value="none" selected="selected">None</option>
       <option value="gzip">Gzip</option>
       <option value="bzip2">Bzip 2</option>
      </select>
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">Include Data:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <select name="db_data">
       <option value="yes" selected="selected">Yes</option>
       <option value="no">No</option>
      </select>
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">Send Backup via FTP:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <select name="use_ftp">
       <option value="1">Yes</option>
       <option value="0" selected="selected">No</option>
      </select>
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">FTP Server:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <input type="text" name="ftp_server" size="30" />
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">FTP Username:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <input type="text" name="ftp_user" size="30" />
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">FTP Password:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <input type="password" name="ftp_pass" size="30" />
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">FTP Path:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <input type="text" name="ftp_path" size="30" />
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">Send Backup via E-mail:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <select name="use_email">
       <option value="1">Yes</option>
       <option value="0" selected="selected">No</option>
      </select>
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg1']?>">E-mail Address:</td>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>">
      <input type="text" name="email_address" size="30" />
     </td>
    </tr>

    <tr>
     <td class="tablerow" bgcolor="<?php echo $THEME['altbg2']?>" colspan="2" align="center">
      <input class="submit" type="submit" name="backupsubmit" value="Create Backup">
     </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>

<?php
}

if (!IN_SHELL) {
    echo "</table></td></tr></table>";
    end_time();
    eval("echo (\"".template('footer')."\");");
}
?>