<?php
/**
 * Avatar Gallery
 *  2005-2008 John Briggs
 * http://www.xmbmods.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/

require 'header.php';

loadtemplates(
'avatar_gallery',
'avatar_gallery_multipage'
);

eval('$css = "'.template('css').'";');

$avatarname = $avatar = $submitbutton = $multipage = '';
$total = (isset($total) && is_numeric($total)) ? (int) $total : 0;
$page = (isset($page) && is_numeric($page)) ? (int) $page : 1;
$type = (isset($type) ? $type : '');

if (strpos($_SERVER['HTTP_REFERER'], 'memcp.php') !== false) {
    nav('<a href="memcp.php">'.$lang['textusercp'].'</a>');
}

if (empty($type)) {
    nav($lang['avatars']);
} else {
    nav('<a href="avatars.php">'.$lang['avatars'].'</a>');
    nav($type);
}

eval('echo "'.template('header').'";');

if ($SETTINGS['avatargal'] == 'off') {
    error($lang['avatarfeaturedisabled'], false);
}

if (X_GUEST || !X_MEMBER) {
    error($lang['avatarnologin'], false);
}

$avatarfolder = './images/avatars';

$avatars = '';
if (!isset($action) || empty($action)) {
    if (!isset($_POST['avatarsubmit']) || empty($_POST['avatarsubmit'])) {
        $dirf = opendir($avatarfolder);
        while(false !== ($file = readdir($dirf))) {
            $avatardir[] = $file;
        }
        closedir($dirf);
        sort($avatardir);
        $totalf = count($avatardir);
        $subfolders = '';
        for($i = 1; $i < $totalf; $i++) {
            if ($avatardir[$i] != '.' && $avatardir[$i] != '..' && is_dir($avatarfolder.'/'.$avatardir[$i])) {
                if ($type == $avatardir[$i]) {
                    $folderimg = 'openav.gif';
                    $pre = '<strong>';
                    $suf = '</strong>';
                } else {
                    $folderimg = 'closeav.gif';
                    $pre = $suf = '';
                }
                $subfolders .= '<br />&nbsp;&nbsp;&nbsp;<img src="'.$THEME['imgdir'].'/'.$folderimg.'" alt="'.$lang['altfolder'].'" border="0" /> <a href="avatars.php?type='.$avatardir[$i].'">'.$pre.''.$avatardir[$i].''.$suf.'</a>';
            }
        }

        if ($type) {
            $avatarfolder .= '/'.$type.'/';
            if (!($dir = opendir($avatarfolder))) {
                error($lang['folderdoesnotexist'], false);
            }

            while(false !== ($file = readdir($dir))) {
                $size = filesize($avatarfolder.''.$file);
                $size = round(($size/100), 1);
                $ext = strtolower(substr(strrchr($file, '.'), 1));
                if ($file != '.' && $file != '..' && $file != 'index.html' && !is_dir($file) && (($ext == 'jpg' || $ext == 'gif' || $ext == 'png' || $ext == 'bmp' || $ext == 'jpeg') && $size > 1)) {
                    $avatarname[] = $file;
                }
            }

            if (!empty($avatarname)) {
                closedir($dir);
                sort($avatarname);
                $totalc = count($avatarname);

                if (isset($page)) {
                    if ($page < 1) {
                        $page = 1;
                    }
                    $start_limit = ($page-1) * $SETTINGS['avatargalpp'];
                    if (($page * $SETTINGS['avatargalpp']) > $totalc) {
                        $end_limit = $start_limit + ($totalc - (($page-1) * $SETTINGS['avatargalpp']));
                    } else {
                        $end_limit = $start_limit + $SETTINGS['avatargalpp'];
                    }
                } else {
                    $start_limit = 0;
                    if ($SETTINGS['avatargalpp'] > $totalc) {
                        $end_limit = $totalc;
                    } else {
                        $end_limit = $start_limit + $SETTINGS['avatargalpp'];
                    }
                    $page = 1;
                }

                $mpurl = 'avatars.php?type='.$type;
                $multipage = '';
                if (($multipage = multi($totalc, $SETTINGS['avatargalpp'], $page, $mpurl)) !== false) {
                    eval('$multipage = "'.template('avatar_gallery_multipage').'";');
                }

                $listed_avatars = $frc = 0;
                for($a = $start_limit; $a < $end_limit; $a++) {
                    $size = filesize($avatarfolder.'/'.$avatarname[$a]);
                    $size = round(($size/1024), 1) . 'kb';

                    if ($listed_avatars == 0) {
                        $avatars .= '<tr>';
                        $avatars .= "\n";
                        $frc++;
                    }
                    $avatars .= '<td class="ctrtablerow"><img src="'.$avatarfolder.''.$avatarname[$a].'" alt="'.$avatarname[$a].'" border="0" /><br /><font class="smalltxt">'.$size.'</font><br /><input type="radio" name="avataricon" value="'.$avatarfolder.''.$avatarname[$a].'" /></td>';
                    $avatars .= "\n";

                    $listed_avatars += 1;
                    if ($listed_avatars == $SETTINGS['avatargalpr']) {
                        $avatars .= '</tr>';
                        $avatars .= "\n";
                        $listed_avatars = 0;
                    }
                    $total = count($avatarname[$a]);
                }

                for($z = 0; $z < (($frc * $SETTINGS['avatargalpr']) - ($end_limit - $start_limit)); $z++) {
                    $avatars .= '<td class="ctrtablerow">&nbsp;</td>';
                    $avatars .= "\n";
                }
            }
        }

        if (!empty($self['avatar'])) {
            $avatar = '<br />'.$lang['currentavatarmsg'].'<br /><br /><img src="'.$self['avatar'].'" alt="'.$lang['altavatar'].'"  border="0" /><br />';
        }

        if (empty($type) && $total == 0) {
            $avatars .= '<td class="ctrtablerow"><br />'.$lang['welcomeavatarmsg'].'<br />'.$avatar.'<br />'.$lang['navigateavatarmsg'].'<br /><br /></td></tr>';
            $avatars .= "\n";
        }

        if ($total > 0) {
            $submitbutton = '<tr><td class="ctrtablerow" bgcolor="'.$THEME['altbg2'].'" colspan="2"><input type="submit" name="avatarsubmit" value="'.$lang['updateavatar'].'" /></td></tr>';
        } else if ($total < 0) {
            error($lang['noavatarsinfolder'], false);
        }
        eval('echo ("'.template('avatar_gallery').'");');
    }

    if (isset($_POST['avatarsubmit']) || !empty($_POST['avatarsubmit'])) {
        if (empty($_POST['avataricon'])) {
            error($lang['noavatarselected'], false);
        }

        $max_size = explode('x', $SETTINGS['max_avatar_size']);
        if ($max_size[0] > 0 && $max_size[1] > 0 && substr_count($avatar, ',') < 2) {
            $size = @getimagesize($avatar);
            if ($size === false) {
                $self['avatar'] = '';
            } else if (($size[0] > $max_size[0] && $max_size[0] > 0) || ($size[1] > $max_size[1] && $max_size[1] > 0) && !X_SADMIN) {
                error($lang['avatar_too_big'] . $SETTINGS['max_avatar_size'] .' px', false);
            }
        }

        $db->query("UPDATE ".X_PREFIX."members SET avatar='$_POST[avataricon]' WHERE username='$xmbuser'");
        echo '<div align="center"><span class="mediumtxt">'.$lang['avatarupdated'].'</span></div>';
        redirect('avatars.php', 2, X_REDIRECT_JS);
    }
}

end_time();
eval('echo "'.template('footer').'";');
?>