<?php

/*

Hack Name: Member Groups

Hack Version: 3.0

File Name: membergroups.inc.php

Hack Author: GuldantheWarlock (GuldantheWarlock@xmbgarage.com)

Based on MemberGroups 2.0 by: EvilC (http://www.evilc.com/)

Hack Description:
FILL THIS IN LATER!

Supported Version: XMB 1.9.8 Engage Final SP2

Notes:

This hack is released under the GPL. You should have recieved a copy of it with this hack.

Please backup your files before installing this mod. Neither XMBGarage nor the author can be held 
responsible if your board stops functioning properly due to you installing this hack.

*/

// Functions that may or may not exist in the current XMB version...
if (!function_exists('printGmDate')) {
	function printGmDate($timestamp=NULL, $altFormat=NULL, $altOffset=0) {
		global $self, $SETTINGS;
		
		$timestamp = ($timestamp !== NULL) ? $timestamp : time();
		$altFormat = ($altFormat !== NULL) ? $altFormat : $self['dateformat'];
		
		$f = false;
		if ((($pos = strpos($altFormat, 'F')) && $f = true) || ($pos2 = strpos($altFormat, 'M')) !== false) {
			$startStr = substr($altFormat, 0, $pos);
			$endStr   = substr($altFormat, $pos+1);
			
			$month = gmdate('m', $timestamp + ($self['timeoffset']*3600)+(($altOffset+$SETTINGS['addtime'])*3600));
			
			$textM = month2text($month);
			
			return printGmDate($timestamp, $startStr, $altOffset).substr($textM, 0, ($f ? strlen($textM) : 3)).printGmDate($timestamp, $endStr, $altOffset);
		} else {
			return gmdate($altFormat, $timestamp + ($self['timeoffset'] * 3600) + (($altOffset+$SETTINGS['addtime']) * 3600));
		}
	}
}

if (!function_exists('printGmTime')) {
	function printGmTime($timestamp=NULL, $altFormat=NULL, $altOffset=0) {
		global $self, $SETTINGS;
		
		$timestamp = ($timestamp !== NULL) ? $timestamp : time();
		$theFormat = ($altFormat !== NULL) ? $altFormat : $self['timecode'];
		
		return gmdate($theFormat, $timestamp + ($self['timeoffset'] * 3600) + (($altOffset+$SETTINGS['addtime']) * 3600));
	}
}

function submitted($var) {
	return (isset($_POST[$var]) && !empty($_POST[$var]));
}

// This function borrowed from UltimaBB
function postArray($var, $type='string') {
    $array = array();
    
    if (isset($_POST[$var]) && !is_array($_POST[$var])) {
	    if (strpos($_POST[$var], ',') !== false) {
		    $_POST[$var] = explode(',', $_POST[$var]);
	    } else {
		    $_POST[$var] = array($_POST[$var]);
	    }
    }
    
    if (isset($_POST[$var]) && is_array($_POST[$var]) && count($_POST[$var]) > 0) {
	    $array = $_POST[$var];
	    foreach($array as $key => $val) {
		    $val = &$array[$key];
		    
		    switch($type) {
			    case 'int':
			        $val = intval($val);
			        break;
			        
			    case 'string':
			        $val = stripslashes($val);
			        break;
			        
		    }
		    unset($val);
	    }
    }
    
    return $array;
}

function mg_auth($userlist) {
	return (bool) (X_ADMIN || (trim($userlist) != '' && (privfcheck(1, $userlist) === true)));
}

function mg_error($msg, $header=true, $redirect=false) {
	global $lang, $mg_docs_link, $mg_copyright_year;
	
	eval('$footer = "'.template('member_groups_footer').'";');
	
	error($msg, $header, '', $footer, false, false);
	
	if ($redirect !== false) {
		redirect($redirect, 2);
	}
	
	exit;
}

function mg_success($msg, $redirect=false) {
	global $THEME;
	
	eval('echo "'.template('member_groups_message').'";');
	
	if ($redirect !== false) {
		redirect($redirect, 2.5);
	}
}

function mg_audit($user='', $action='', $gid=0, $reason='') {
	global $db, $xmbuser, $table_membergroups_logs;
	
	if ($user == '') {
		$user = $xmbuser;
	}
	
	$gid    = (int) $gid;
	$user   = checkInput($user);
	$action = checkInput($action);
	$reason = checkInput($reason);
	
	$db->query("INSERT INTO ".X_PREFIX."membergroups_logs (username, action, gid, reason, dateline) VALUES ('$user', '$action', '$gid', '$reason', '".time()."')");
}

function mg_rename_group($groupfrom, $groupto) {
	global $table_forums, $table_members, $table_membergroups, $table_restricted;
	global $db, $lang;
	
	if (!preg_match("/^[A-Za-z0-9_\-]*$/", $groupto)) {
		return $lang['mg_er_grp_bad_char'];
	}
	
	$groupto = addslashes($groupto);
	
	$query = $db->query("SELECT COUNT(mgid) FROM ".X_PREFIX."membergroups WHERE groupname='$groupto'");
	if ($db->result($query, 0) > 0) {
		return $lang['mg_er_grp_exist'];
	}
	$db->free_result($query);
	
	$query = $db->query("SELECT COUNT(uid) FROM ".X_PREFIX."members WHERE username='$groupto'");
	if ($db->result($query, 0) > 0) {
		return $lang['mg_er_grp_exist2'];
	}
	$db->free_result($query);
	
	// Should be ok, go ahead and rename
	$db->query("UPDATE ".X_PREFIX."membergroups SET groupname='$groupto' WHERE groupname='$groupfrom'");
	$db->query("UPDATE ".X_PREFIX."restricted SET name='$groupto' WHERE name='$groupfrom'");
	
	$query = $db->query("SELECT fid, userlist FROM ".X_PREFIX."forums WHERE (userlist REGEXP '(^|(,))( )*$groupfrom( )*((,)|$)')");
	while($list = $db->fetch_array($query)) {
		$list['userlist'] = array_unique(array_map('trim', explode(',', $list['userlist'])));
		$index = array_search($groupfrom, $list['userlist']);
		$list['userlist'][$index] = $groupto;
		$list['userlist'] = implode(', ', natcasesort($list['userlist']));
		
		$db->query("UPDATE ".X_PREFIX."forums SET userlist='$list[userlist]' WHERE fid='$list[fid]'");
	}
	$db->free_result($query);
	
	return $lang['mg_grpupdated'];
}
?>