<?php
/**
 * Contact Us v1.0
 *  2009 John Briggs
 * http://www.xmbgarage.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/

define('X_SCRIPT', 'contact.php');

require 'header.php';

header('X-Robots-Tag: noindex');

loadtemplates(
'contactus',
'contactus_captcha',
'misc_feature_notavailable'
);

nav($lang['contactus']);

smcwcache();

eval('$css = "'.template('css').'";');
eval('echo "'.template('header').'";');

if ($SETTINGS['contactus_status'] == 'off') {
    eval('echo "'.template('misc_feature_notavailable').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

if (noSubmit('contactsubmit')) {
    $self['username'] = (isset($self['username']) ? $self['username'] : '');
    $self['email'] = (isset($self['email']) ? $self['email'] : '');
    $captchacheck = '';
    if ($SETTINGS['captcha_status'] == 'on' && !DEBUG) {
        require ROOT.'include/captcha.inc.php';
        $Captcha = new Captcha(250, 50);
        if ($Captcha->bCompatible !== false) {
            $imghash = $Captcha->GenerateCode();
            if ($SETTINGS['captcha_code_casesensitive'] == 'off') {
                $lang['captchacaseon'] = '';
            }
            eval('$captchacheck = "'.template('contactus_captcha').'";');
        }
    }
    eval('echo "'.template('contactus').'";');
}

if (onSubmit('contactsubmit')) {
    $name = trim(stripslashes($_POST['name']));
    $email = trim(stripslashes($_POST['email']));
    $subject = trim(stripslashes($_POST['subject']));
    $message = trim(stripslashes($_POST['message']));

    if ($name === '' || $email === '' || $subject === '' || $message === '') {
        error($lang['contactempty'], false, '', '', $full_url.'contact.php', true, false, true);
    }

    if ($SETTINGS['captcha_status'] == 'on' && !DEBUG) {
        require ROOT.'include/captcha.inc.php';
        $Captcha = new Captcha(250, 50);
        if ($Captcha->bCompatible !== false) {
            $imghash = postedVar('imghash', '', FALSE, TRUE);
            $imgcode = postedVar('imgcode', '', FALSE, FALSE);
            if ($Captcha->ValidateCode($imgcode, $imghash) !== true) {
                error($lang['captchaimageinvalid'], false, '', '', $full_url.'contact.php', true, false, true);
            }
        }
    }

    // Validate email address
    $emailPattern = "^([_a-z0-9-]+)(\.[_a-z0-9-]+)*@([a-z0-9-]+)(\.[a-z0-9-]+)*(\.[a-z]{2,4})$";
    $emailValid = false;

    if (eregi($emailPattern, $email)) {
        // Under Windows, PHP does not possess getmxrr(), so we skip it
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $emailValid = true;
            break;
        }

        $user = $domain = '';
        list($user, $domain) = split('@', $email);

        // Check if the site has an MX record. We can't send unless there is.
        $mxrecords = '';
        if (getmxrr($domain, $mxrecords)) {
            $emailValid = true;
        }
    }

    if (!$emailValid) {
        error($lang['contactbademail'], false, '', '', $full_url.'contact.php', true, false, true);
    }

    if (X_GUEST) {
        $xmbuser = $lang['textguest'];
    }

    $headers[] = "From: $name <$email>";
    $headers[] = "X-Sender: <$email>";
    $headers[] = 'X-Mailer: PHP';
    $headers[] = 'X-AntiAbuse: Board servername - '.$bbname;
    $headers[] = 'X-AntiAbuse: Username - '.$xmbuser;
    $headers[] = 'X-Priority: 2';
    $headers[] = "Return-Path: <$email>";
    $headers[] = 'Content-Type: text/plain; charset='.$charset;
    $headers = implode("\r\n", $headers);

    altMail($SETTINGS['adminemail'], $subject, $message, $headers);

    message($lang['contactsubmitted'], false, '', '', $full_url.'index.php', true, false, true);
}

end_time();
eval('echo "'.template('footer').'";');
?>