<?php
/**
 * Title: Download Center
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'files.php');

require 'header.php';
require ROOT.'include/files.inc.php';

loadtemplates(
'files_main_categories',
'files_main',
'files_subcategories_categories',
'files_subcategories',
'files_categories_rows',
'files_categories_none',
'files_categories',
'files_submit',
'files_viewall_rows',
'files_viewall_none',
'files_viewall',
'files_license',
'files_file_edit',
'files_file_email',
'files_file_report',
'files_file_description',
'files_file_creator',
'files_file_version',
'files_file_size',
'files_file_type',
'files_file_submitted',
'files_file_screenshot_image',
'files_file_screenshot_url',
'files_file_documents',
'files_file_rating',
'files_file_custom',
'files_file_download',
'files_file_rate',
'files_file_comment',
'files_file_comments_rows',
'files_file_comments',
'files_file',
'files_email',
'files_report',
'files_search',
'files_search_results_rows',
'files_search_results',
'files_copyright',
'files_confirm',
'files_error',
'files_admin_files_custom',
'files_main_none',
'files_file_comments_edit',
'files_file_comments_report',
'files_navigation_statslink',
'files_navigation_searchlink',
'files_navigation_adminlink',
'files_navigation',
'files_faq',
'files_navigation_faqlink',
'files_file_fee',
'files_fees_paypal'
);

eval('$css = "'.template('css').'";');

if (file_exists('install.php') && !@unlink('install.php') || file_exists('files.xmb') && !@unlink('files.xmb')) {
    error('You must remove the install files named "install.php" and "files.xmb" before you may proceed to use the files system!');
}

if ((!X_MEMBER) && $SETTINGS['files_guests'] != 'on') {
    nav($lang['downloadcenter']);
    eval('echo "'.template('header').'";');
    files_errormsg($lang['featureunavailable']);
}

if ($SETTINGS['files_status'] == 'off' && (!X_ADMIN)) {
    nav($lang['downloadcenter']);
    eval('echo "'.template('header').'";');
    files_errormsg($lang['featuredisabled']);
}

switch($action) {
    case 'download':
        $fid = (isset($fid) ? (int)$fid : 0);
        $mid = (isset($mid) ? (int)$mid : 0);

        $query = $db->query("SELECT catid, downloadlist, dlurl, mirror, fee FROM ".X_PREFIX."files WHERE id='$fid' OR id='$mid'");
        $file = $db->fetch_array($query);
        $db->free_result($query);

        $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE id='$file[catid]'");
        $category = $db->fetch_array($query);
        $db->free_result($query);

        $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));

        if (empty($whoview)) {
            files_errormsg($lang['cannotviewfile']);
        }

        $whodownload = files_permissions($category['whodownload'], stripslashes($category['downloadlist']));
        if (!empty($file['fee']) && $file['fee'] != '0.00') {
            $whodownloadfile = files_paidpermissions(stripslashes($file['downloadlist']).', ');
        } else {
            $whodownloadfile = true;
        }

        if (empty($whodownload) || empty($whodownloadfile)) {
            files_errormsg($lang['cannotdownfile']);
        }

        if (empty($file)) {
            eval('echo "'.template('header').'";');
            files_errormsg($lang['nofileexists']);
        }

        $time = $onlinetime;

        $db->query("UPDATE ".X_PREFIX."files SET dls=dls + 1, last='$time' WHERE id='$fid' OR id='$mid'");

        if ($fid > 0) {
            $url = str_replace(' ', '%20', $file['dlurl']);
        } else {
            $url = str_replace(' ', '%20', $file['mirror']);
        }

        if ('./' == substr($url, 0, 2)) {
            $url = str_replace('./', $SETTINGS['boardurl'], $url);
        }

        if (!@fopen($url, "r")) {
            eval('echo "'.template('header').'";');
            files_errormsg($lang['nofileexists']);
        } else {
            header("Content-type: unknown/unknown");
            header("Location: $url");
        }
        exit;
        break;

    case 'category':
        $id = (isset($id) ? (int)$id : 0);
        $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE id='$id'");
        $category = $db->fetch_array($query);
        $db->free_result($query);
        $category['name'] = stripslashes($category['name']);
        if (!empty($id) && $id == (int)$category['id']) {
            if ($category['parent'] == 0) {
                nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
                nav($category['name']);
            } else {
                $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE id='$category[parent]'");
                $parent = $db->fetch_array($query);
                $db->free_result($query);
                $parent['name'] = stripslashes($parent['name']);
                nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
                nav('<a href="files.php?action=category&amp;id='.intval($parent['id']).'">'.$parent['name'].'</a>');
                nav($category['name']);
            }
        } else {
            nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
        }

        eval('echo "'.template('header').'";');

        if (empty($id) || $id != (int)$category['id']) {
            files_errormsg($lang['nocategoryexists']);
        }

        $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));

        if (empty($whoview)) {
            files_errormsg($lang['cannotviewcategory']);
        }

        $whoview = '';

        $subquery = $db->query("SELECT c.id, c.name, c.description, c.icon, c.whoview, c.viewlist, count(f.catid) as files FROM ".X_PREFIX."files_categories c LEFT JOIN ".X_PREFIX."files f ON c.id = f.catid WHERE c.status='on' AND parent='$id' AND (f.status='approved' || f.status IS NULL) GROUP BY c.id");
        $subtotal = $db->num_rows($subquery);
        $subcats = false;
        $categories = '';
        while($sub = $db->fetch_array($subquery)) {
            $whoview = files_permissions($sub['whoview'], stripslashes($sub['viewlist']));
            if (!empty($whoview)) {
                $subcats = true;
                $sub['name'] = stripslashes($sub['name']);
                $sub['description'] = stripslashes($sub['description']);
                $filesincat = $sub['files'];
                if (!empty($sub['icon'])) {
                    $icon = '<img src="'.$sub['icon'].'" border="0" align="left" /> ';
                } else {
                    $icon = '';
                }
                $mouseover = files_mouseover('files.php?action=category&id='.intval($sub['id']));
                eval('$categories .= "'.template('files_subcategories_categories').'";');
            }
        }
        $db->free_result($subquery);

        if ($subcats) {
            eval('echo "'.template('files_subcategories').'";');
        }

        if (!isset($sortby) || !in_array(strtolower($sortby), array('id', 'name', 'description', 'creator', 'version', 'longdesc', 'ssurl', 'dlurl', 'mirror', 'time', 'catid', 'posticon', 'license', 'dls', 'last', 'pin', 'docsurl', 'rating', 'votes', 'views', 'status', 'submitdate', 'submitby', 'filesize', 'filetype'))) {
            $sortby = "name";
        }

        if (!isset($ascdesc) || !in_array(strtolower($ascdesc), array('asc', 'desc'))) {
            $ascdesc = "ASC";
        }

        $page = ((isset($page) && (int)$page > 0) ? (int)$page : 1);
        $start_limit = ($page > 1) ? (($page-1) * $SETTINGS['files_fpp']) : 0;

        $rows = $start = '';
        $filequery = $db->query("SELECT * FROM ".X_PREFIX."files WHERE catid='$id' AND status='approved' ORDER BY pin DESC, $sortby $ascdesc LIMIT $start_limit, $SETTINGS[files_fpp]");
        $filetotal = $db->num_rows($filequery);
        while($file = $db->fetch_array($filequery)) {
            $dateadded = date($dateformat, $file['time']);

            $rating = @round($file['rating']/$file['votes']);
            $stars = '';
            for($i = 0; $i < $rating; $i++) {
                $stars .= '<img src="'.$THEME['imgdir'].'/star.gif" border="0" alt="'.$rating.'/10" />';
                if ($i == 4) {
                    $stars .= '<br />';
                }
            }

            if ($file['posticon'] != '' && file_exists($THEME['smdir'].'/'.$file['posticon'])) {
                $icon = '<img src="'.$THEME['smdir'].'/'.$file['posticon'].'" border="0" alt="" />';
            } else {
                $icon = '';
            }

            if ($file['pin'] == 'yes') {
                $pin = '<img src="'.$THEME['imgdir'].'/pin.gif" border="0" alt="" />&nbsp;';
            } else {
                $pin = '';
            }

            if (!empty($file['fee']) && $file['fee'] != '0.00') {
                $sell = '<img src="'.$THEME['imgdir'].'/dollar.gif" border="0" alt="" />&nbsp;';
            } else {
                $sell = '';
            }

            $file['description'] = stripslashes($file['description']);
            $file['name'] = stripslashes($file['name']);
            $mouseover = files_mouseover('files.php?action=file&id='.intval($file['id']));
            eval('$rows .= "'.template('files_categories_rows').'";');
        }
        $db->free_result($filequery);

        $totalquery = $db->query("SELECT COUNT(*) FROM ".X_PREFIX."files WHERE catid='$category[id]' AND status='approved'");
        $totalfiles = $db->result($totalquery, 0);
        $db->free_result($totalquery);

        $multipage = multi($totalfiles, $SETTINGS['files_fpp'], $page, 'files.php?action=category&amp;id='.intval($category['id']));

        if ($filetotal == 0) {
            eval('$rows = "'.template('files_categories_none').'";');
        }

        $whosubmit = files_permissions($category['whosubmit'], stripslashes($category['submitlist']));

        if (!empty($whosubmit)) {
            $submitlink = "<input style=\"cursor: pointer; cursor: hand; font-size: 9px\" type=\"button\" onclick=\"location.href='files.php?action=submit&amp;id=$category[id]'\" value=\"$lang[submitfile]\" />";
        } else {
            $submitlink = '';
        }

        $whosubmit = '';

        eval('echo "'.template('files_categories').'";');
        break;

    case 'submit':
        $id = (isset($id) ? (int)$id : 0);

        $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE id='$id'");
        $category = $db->fetch_array($query);
        $db->free_result($query);

        $category['name'] = stripslashes($category['name']);

        if (!empty($id) && $id == (int)$category['id']) {
            if ($category['parent'] == 0) {
                nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
                nav('<a href="files.php?action=category&amp;id='.intval($category['id']).'">'.$category['name'].'</a>');
                nav($lang['submitfile']);
            } else {
                $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE id='$category[parent]'");
                $parent = $db->fetch_array($query);
                $db->free_result($query);
                $parent['name'] = stripslashes($parent['name']);
                nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
                nav('<a href="files.php?action=category&amp;id='.intval($parent['id']).'">'.$parent['name'].'</a>');
                nav('<a href="files.php?action=category&amp;id='.intval($category['id']).'">'.$category['name'].'</a>');
                nav($lang['submitfile']);
            }
        } else {
            nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
        }

        eval('echo "'.template('header').'";');

        if (empty($id) || $id != (int)$category['id']) {
            files_errormsg($lang['nocategoryexists']);
        }

        $whosubmit = files_permissions($category['whosubmit'], stripslashes($category['submitlist']));

        if (empty($whosubmit)) {
            files_errormsg($lang['cannotsubmitfile']);
        }

        $whosubmit = '';

        if (empty($_POST['filesubmit'])) {
            $dlurl = '';
            $customfields = '';
            $customdata['data'] = '';
            $filesize = '';
            $filetype = '';
            $icons = files_posticons();
            $listlicenses = array();
            $listlicenses[] = '<select name="license">';
            $listlicenses[] = '<option value="0">'.$lang['none'].'</option>';
            $licquery = $db->query("SELECT * FROM ".X_PREFIX."files_licenses ORDER BY name");
            while($license = $db->fetch_array($licquery)) {
                $license['name'] = stripslashes($license['name']);
                if ($license['name'] != '') {
                    $listlicenses[] = '<option value="'.intval($license['id']).'">'.$license['name'].'</option>';
                }
            }
            $listlicenses[] = '</select>';
            $listlicenses = implode("\n", $listlicenses);
            $db->free_result($licquery);

            $icons = str_replace('<input type="radio" name="posticon" value="" />', '<input type="radio" name="posticon" value="" checked="checked" />', $icons);

            $customquery = $db->query("SELECT * FROM ".X_PREFIX."files_custom ORDER BY name");
            while($custom = $db->fetch_array($customquery)) {
                eval('$customfields .= stripslashes("'.template('files_admin_files_custom').'");');
            }
            $db->free_result($customquery);

            $whoupload = files_permissions($category['whoupload'], stripslashes($category['uploadlist']));

            if (!empty($whoupload)) {
                $uploadlink = "<a href=\"#\" onclick=\"Popup('files_upload.php?uid=$category[id]', 'upload', '400', '22')\"><strong>$lang[clickhere]</strong></a> $lang[touploadnewfile].";
            } else {
                $uploadlink = '';
            }

            $whoupload = '';
            eval('echo "'.template('files_submit').'";');
        }

        if (isset($_POST['filesubmit'])) {
            if (empty($_POST['name'])) {
                files_errormsg($lang['nofilename']);
            }

            $_POST['name'] = addslashes($_POST['name']);

            $query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE name='$_POST[name]'");
            $check = $db->fetch_array($query);
            $db->free_result($query);

            if (!empty($check)) {
                files_errormsg($lang['fileexists']);
            }

            if (isset($_POST['dlurl']) && $_POST['dlurl'] != '') {
                $fileurl = str_replace(' ', '%20', $_POST['dlurl']);
                if ('./' == substr($fileurl, 0, 2)) {
                    $fileurl = str_replace('./', $SETTINGS['boardurl'], $fileurl);
                }

                $fp = @fopen($fileurl,"r");
                if (!$fp) {
                    files_errormsg($lang['filenotfound']);
                } else {
                    if ($_POST['filesize'] == '' && $_POST['filetype'] == '') {
                        @fclose($fp);
                        $ourhead = '';
                        $url = parse_url($fileurl);
                        $host = $url['host'];
                        $path = $url['path'];
                        $fp = @fsockopen($host, 80, $errno, $errstr, 20);
                        fputs($fp, "HEAD $fileurl HTTP/1.1\r\n");
                        fputs($fp, "HOST: dummy\r\n");
                        fputs($fp, "Connection: close\r\n\r\n");
                        while(!feof($fp)) {
                            $ourhead = sprintf("%s%s", $ourhead, fgets($fp,128));
                        }
                        $size = explode("Content-Length: ", $ourhead);
                        $_POST['filesize'] = isset($size[1]) ? (int) $size[1] : $lang['notavailable'];
                        $extension_head = explode("Content-Type: ", $ourhead);
                        $extension = $extension_head[1];
                        if (strpos($extension,';')) {
                            $extension = substr($extension, 0, strpos($extension,';'));
                        }
                        $_POST['filetype'] = $extension;
                    }
                    @fclose($fp);
                }
            } else {
                files_errormsg($lang['filenotfound']);
            }

            if (isset($_POST['screenshot']) && $_POST['screenshot'] != '') {
                $fp = @fopen($_POST['screenshot'],"r");
                if ($fp) {
                    fclose($fp);
                } else {
                    files_errormsg($lang['invalidssurl']);
                }
            }

            if (isset($_POST['documentation']) && $_POST['documentation'] != '') {
                $fp = @fopen($_POST['documentation'],"r");
                if ($fp) {
                    fclose($fp);
                } else {
                    files_errormsg($lang['invaliddocsurl']);
                }
            }

            $_POST['filesize']      = addslashes($_POST['filesize']);
            $_POST['filetype']      = addslashes($_POST['filetype']);
            $_POST['name']          = checkInput($_POST['name'], 'no', 'no', '', false);
            $_POST['shortdesc']     = checkInput(addslashes($_POST['shortdesc']), 'no', 'no', '', false);
            $_POST['longdesc']      = checkInput(addslashes($_POST['longdesc']), 'no', 'no', '', false);
            $_POST['creator']       = checkInput(addslashes($_POST['creator']), 'no', 'no', '', false);
            $_POST['version']       = checkInput(addslashes($_POST['version']), 'no', 'no', '', false);
            $_POST['screenshot']    = files_url_chk($_POST['screenshot']);
            $_POST['documentation'] = files_url_chk($_POST['documentation']);
            $_POST['mirror']        = files_url_chk($_POST['mirror']);
            $_POST['dlurl']         = addslashes($_POST['dlurl']);
            $_POST['posticon']      = addslashes($_POST['posticon']);
            $_POST['license']       = (int) $_POST['license'];
            $_POST['pin']           = ($_POST['pin'] == 'yes' ? 'yes' : 'no');

            $time = $onlinetime;

            $db->query("INSERT INTO ".X_PREFIX."files (name, description, creator, version, longdesc, ssurl, dlurl, mirror, catid, posticon, license, pin, docsurl, status, submitdate, submitby, filesize, filetype) VALUES ('$_POST[name]', '$_POST[shortdesc]', '$_POST[creator]', '$_POST[version]', '$_POST[longdesc]', '$_POST[screenshot]', '$_POST[dlurl]', '$_POST[mirror]', '$id', '$_POST[posticon]', '$_POST[license]', '$_POST[pin]', '$_POST[documentation]', 'pending', '$time', '$xmbuser', '$_POST[filesize]', '$_POST[filetype]')");
            $fid = $db->insert_id();

            if (!empty($_POST['custom'])) {
                foreach ($_POST['custom'] as $key => $result) {
                    $result = trim($result);
                    if (!empty($result)) {
                        $db->query("INSERT INTO ".X_PREFIX."files_custom_data (file, custom, data) VALUES ('$fid', '$key', '".checkInput(addslashes($result), 'no', 'no', '', false)."')");
                    }
                }
            }

            if ($SETTINGS['files_notify'] == 'on') {
                altMail($SETTINGS['adminemail'], $lang['submittedfilesubject'], "$lang[submittedfilemessage]\n\n$_POST[name]", "From: $SETTINGS[bbname] <$SETTINGS[adminemail]>");
            }
            files_confirmmsg($lang['filesubmitted'], 'files.php?action=category&id='.$id);
        }
        break;

    case 'viewall':
        nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
        nav($lang['viewall']);
        eval('echo "'.template('header').'";');

        if (!isset($sortby) || !in_array(strtolower($sortby), array('id', 'name', 'description', 'creator', 'version', 'longdesc', 'ssurl', 'dlurl', 'mirror', 'time', 'catid', 'posticon', 'license', 'dls', 'last', 'pin', 'docsurl', 'rating', 'votes', 'views', 'status', 'submitdate', 'submitby', 'filesize', 'filetype'))) {
            $sortby = "name";
        }

        if (!isset($ascdesc) || !in_array(strtolower($ascdesc), array('asc', 'desc')) ) {
            $ascdesc = "ASC";
        }

        $page = (isset($page) && is_numeric($page)) ? ($page < 1 ? 1 : ((int) $page)) : 1;
        $start_limit = ($page > 1) ? (($page-1) * $SETTINGS['files_fpp']) : 0;

        $filequery = $db->query("SELECT f.*, c.id AS catid, c.name AS catname, c.whoview AS catview, c.viewlist FROM ".X_PREFIX."files f LEFT JOIN ".X_PREFIX."files_categories c ON c.id = f.catid WHERE f.status = 'approved' ORDER BY f.pin DESC, $sortby $ascdesc LIMIT $start_limit, $SETTINGS[files_fpp]");
        $filetotal = $db->num_rows($filequery);
        $rows = '';
        while($file = $db->fetch_array($filequery)) {
            $whoview = files_permissions($file['catview'], stripslashes($file['viewlist']));
            if (!empty($whoview)) {
                $file['name']        = stripslashes($file['name']);
                $file['description'] = stripslashes($file['description']);
                $file['catname']     = stripslashes($file['catname']);

                $dateadded = date($dateformat, $file['time']);

                $rating = @round($file['rating']/$file['votes']);
                $stars = '';
                for($i = 0; $i < $rating; $i++) {
                    $stars .= '<img src="'.$THEME['imgdir'].'/star.gif" border="0" alt="'.$rating.'/10" />';
                    if ($i == 4) {
                        $stars .= '<br />';
                    }
                }

                if ($file['posticon'] != '' && file_exists($THEME['smdir'].'/'.$file['posticon'])) {
                    $icon = '<img src="'.$THEME['smdir'].'/'.$file['posticon'].'" border="0" alt="" />';
                } else {
                    $icon = '';
                }

                if ($file['pin'] == 'yes') {
                    $pin = '<img src="'.$THEME['imgdir'].'/pin.gif" border="0" alt="" />&nbsp;';
                } else {
                    $pin = '';
                }

                if (!empty($file['fee']) && $file['fee'] != '0.00') {
                    $sell = '<img src="'.$THEME['imgdir'].'/dollar.gif" border="0" alt="" />&nbsp;';
                } else {
                    $sell = '';
                }

                $mouseover = files_mouseover('files.php?action=file&id='.intval($file['id']));
                eval('$rows .= "'.template('files_viewall_rows').'";');
            }
            $whoview = '';
        }
        $db->free_result($filequery);

        $totalquery = $db->query("SELECT COUNT(*) FROM ".X_PREFIX."files WHERE status='approved'");
        $totalfiles = $db->result($totalquery, 0);
        $db->free_result($totalquery);

        $multipage = multi($totalfiles, $SETTINGS['files_fpp'], $page, 'files.php?action=viewall');
        $id = $start = 0;
        if ($filetotal == 0) {
            eval('$rows = "'.template('files_viewall_none').'";');
        }
        eval('echo "'.template('files_viewall').'";');
        break;

    case 'license':
        $fid = (isset($fid) ? (int)$fid : 0);
        $lid = (isset($lid) ? (int)$lid : 0);
        $mid = (isset($mid) ? (int)$mid : 0);

        if ($mid > 0) {
            $did = "mid";
            $id = $mid;
        } else {
            $did = "fid";
            $id = (int)$fid;
        }

        $navigation = files_navigation($id, $lang['license']);

        eval('echo "'.template('header').'";');

        $query = $db->query("SELECT * FROM ".X_PREFIX."files_licenses WHERE id='$lid'");
        $license = $db->fetch_array($query);
        $db->free_result($query);

        $license['name'] = stripslashes($license['name']);
        $license['text'] = postify($license['text'], 'no', 'no', 'yes', 'no', 'yes', 'yes');
        $license['text'] = stripslashes($license['text']);
        eval('echo "'.template('files_license').'";');
        break;

    case 'file';
        $id = (isset($id) ? (int)$id : 0);

        $navigation = files_navigation($id, '');

        eval('echo "'.template('header').'";');

        if (empty($id) || $id != (int)$file['id']) {
            files_errormsg($lang['nofileexists']);
        }

        $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));

        if (empty($whoview)) {
            files_errormsg($lang['cannotviewfile']);
        }

        $whoview = '';

        if (empty($page)) {
            $db->query("UPDATE ".X_PREFIX."files SET views=views+1 WHERE id='$id'");
        }

        $file_edit = '';
        if (X_ADMIN) {
            eval('$file_edit = "'.template('files_file_edit').'";');
        }

        $file_report = '';
        if ($SETTINGS['files_report'] == 'on') {
            eval('$file_report = "'.template('files_file_report').'";');
        }

        $whoemail = files_permissions($category['whoemail'], stripslashes($category['emaillist']));

        $file_email = '';
        if (!empty($whoemail)) {
            eval('$file_email = "'.template('files_file_email').'";');
        }

        $whoemail = '';

        $date = date($dateformat, $file['time']);

        if ($file['submitdate'] != 0) {
            $datesubmitted = date($dateformat, $file['submitdate']);
            if ($file['submitby'] != '') {
                $submittedby = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($file['submitby']).'">'.$file['submitby'].'</a>';
            } else {
                $submittedby = $lang['anonymous'];
            }
            eval('$file_submitted = "'.template('files_file_submitted').'";');
        } else {
            $file_submitted = '';
        }

        if ($file['last'] == 0) {
            $lastdownload = $lang['never'];
        } else {
            $lastdownload = date($dateformat.' g:i A', $file['last']);
        }

        $file['creator'] = trim($file['creator']);
        $file['version'] = trim($file['version']);
        $file['ssurl']   = trim($file['ssurl']);
        $file['docsurl'] = trim($file['docsurl']);

        $file_description = '';
        if (!empty($file['longdesc'])) {
            $file['longdesc'] = stripslashes($file['longdesc']);
            eval('$file_description = "'.template('files_file_description').'";');
        }

        $file_creator = '';
        if (!empty($file['creator'])) {
            $file['creator'] = stripslashes($file['creator']);
            eval('$file_creator = "'.template('files_file_creator').'";');
        }

        $file_version = '';
        if (!empty($file['version'])) {
            $file['version'] = stripslashes($file['version']);
            eval('$file_version = "'.template('files_file_version').'";');
        }

        $file['filesize'] = (!empty($file['filesize']) && is_numeric($file['filesize'])) ? (int) $file['filesize'] : 0;
        if ($file['filesize'] == 0) {
            $size = $lang['notavailable'];
        } else {
            $size = round($file['filesize'] / 1024, 2);
            $kb = 1024;
            $mb = 1024 * $kb;
            $gb = 1024 * $mb;
            $tb = 1024 * $gb;
            if ($size < $kb) {
                $size = $size." Kb";
            } else if ($size < $mb) {
                $size = round($size / $kb, 2) . " Mb";
            }
        }
        $filesize = $size;
        eval('$file_size = "'.template('files_file_size').'";');

        $extension = $lang['notavailable'];
        if (!empty($file['filetype'])) {
            $extension = stripslashes($file['filetype']);
        }
        eval('$file_type = "'.template('files_file_type').'";');

        if (!empty($file['ssurl'])) {
            if ($SETTINGS['files_screenshot'] == 'image') {
                $totalsize = explode('|', $SETTINGS['files_shotsize']);
                $maxwidth = $totalsize[0];
                $maxheight = $totalsize[1];
                if ($shotsize = getimagesize($file['ssurl'])) {
                    $shotwidth = $shotsize[0];
                    $shotheight = $shotsize[1];
                    $origshotwidth = $shotwidth;
                    $origshotheight = $shotheight;
                    if ($shotwidth > $maxwidth && $maxwidth > 0) {
                        $shotprop = ($maxwidth * 100) / $shotwidth;
                        $shotvsize = ($shotheight * $shotprop) / 100;
                        $shotwidth = $maxwidth;
                        $shotheight = ceil($shotvsize);
                    }

                    if ($shotheight > $maxheight && $maxheight > 0) {
                        $shotprop = ($maxheight * 100) / $shotheight;
                        $shothsize = ($shotwidth * $shotprop) / 100 ;
                        $shotheight = $maxheight;
                        $shotwidth = ceil($shothsize);
                    }
                    eval('$file_screenshot = "'.template('files_file_screenshot_image').'";');
                } else {
                    $screenshot = '<br />'.$text_novalidimage.'<br /><br /><a href="'.$file['ssurl'].'" target="_blank">'.$file['ssurl'].'</a>';
                }
            } else {
                eval('$file_screenshot = "'.template('files_file_screenshot_url').'";');
            }
        } else {
            $file_screenshot = '';
        }

        $file_documents = '';
        if (!empty($file['docsurl'])) {
            eval('$file_documents = "'.template('files_file_documents').'";');
        }

        $filerating = @round($file['rating']/$file['votes']);
        $stars = '';
        for($i = 0; $i < $filerating; $i++) {
            $stars .= '<img src="'.$THEME['imgdir'].'/star.gif" border="0" alt="'.$filerating.'/10" />';
        }

        if ($file['votes'] == 1) {
            $votes = '('.$file['votes'].' '.$lang['vote'].')';
        } else {
            $votes = '('.$file['votes'].' '.$lang['votes'].')';
        }

        $file_rating = '';
        if ($file['votes'] != 0) {
            eval('$file_rating = "'.template('files_file_rating').'";');
        }

        if ($file['license'] == 0) {
            $downloadlink = '<a href="files.php?action=download&amp;fid='.$id.'"><img src="'.$THEME['imgdir'].'/download.gif" border="0" alt="" /></a><br />'.$lang['download'];
        } else {
            $downloadlink = '<a href="files.php?action=license&amp;lid='.$file['license'].'&amp;fid='.$id.'"><img src="'.$THEME['imgdir'].'/download.gif" border="0" alt="" /></a><br />'.$lang['download'];
        }

        $mirrorlink = '';
        if (!empty($file['mirror'])) {
            $downloadlink .= '<br />('.$lang['primary'].' '.$lang['site'].')';
            if ($file['license'] == 0) {
                $mirrorlink = '<a href="files.php?action=download&amp;mid='.$id.'"><img src="'.$THEME['imgdir'].'/download.gif" border="0" alt="" /></a><br />'.$lang['download'].'<br />('.$lang['mirror'].' '.$lang['site'].')';
            } else {
                $mirrorlink = '<a href="files.php?action=license&amp;lid='.$file['license'].'&amp;mid='.$id.'"><img src="'.$THEME['imgdir'].'/download.gif" border="0" alt="" /></a><br />'.$lang['download'].'<br />('.$lang['mirror'].''.$lang['site'].')';
            }
        }

        $file_fee = '';
        if (!empty($file['fee']) && $file['fee'] != '0.00') {
            eval('$file_fee = "'.template('files_file_fee').'";');
            $whodownloadfile = files_paidpermissions(stripslashes($file['downloadlist']).', ');
        } else {
            $whodownloadfile = true;
        }

        $whodownload = files_permissions($category['whodownload'], stripslashes($category['downloadlist']));
        $width = '';
        $download = '';
        if ((!empty($file['dlurl']) || !empty($file['mirror'])) && !empty($whodownload)) {
            if (!empty($whodownloadfile)) {
                eval('$download .= "'.template('files_file_download').'";');
            } elseif (!empty($file['fee']) && $file['fee'] != '0.00' && isset($SETTINGS['files_paypal_account']) && !empty($SETTINGS['files_paypal_account'])) {
                $SETTINGS['files_paypal_account'] = stripslashes($SETTINGS['files_paypal_account']);
                eval('$download = "'.template('files_fees_paypal').'";');
            }
        }

        $whodownload = '';
        $file_custom = '';
        $result = $db->query("SELECT * FROM ".X_PREFIX."files_custom_data WHERE file='$id'");
        while($custom = $db->fetch_array($result)) {
            $query = $db->query("SELECT * FROM ".X_PREFIX."files_custom WHERE id='$custom[custom]'");
            $field = $db->fetch_array($query);
            $db->free_result($query);
            $field['name']  = stripslashes($field['name']);
            $custom['data'] = trim($custom['data']);
            $custom['data'] = stripslashes($custom['data']);
            eval('$file_custom .= "'.template('files_file_custom').'";');
        }
        $db->free_result($result);

        $whorate = files_permissions($category['whorate'], stripslashes($category['ratelist']));
        $whocomment = files_permissions($category['whocomment'], stripslashes($category['commentlist']));

        if (!empty($whorate) && !empty($whocomment)) {
            $width = '33%';
        } else if ((!empty($whorate) && empty($whocomment)) || (empty($whorate) && !empty($whocomment))) {
            $width = '50%';
        } else {
            $width = '100%';
        }

        $file_rate = '';
        if (!empty($whorate)) {
            eval('$file_rate = "'.template('files_file_rate').'";');
        }

        $file_comment = '';
        if (!empty($whocomment)) {
            eval('$file_comment = "'.template('files_file_comment').'";');
        }

        $whorate = '';
        $whocomment = '';

        $page = (isset($page) && is_numeric($page)) ? ($page < 1 ? 1 : ((int) $page)) : 1;
        $start_limit = ($page > 1) ? (($page-1) * $SETTINGS['files_cpp']) : 0;

        $thisbg = $THEME['altbg1'];

        smcwcache();
        $rows = '';
        $commentquery = $db->query("SELECT c.*, m.sig FROM ".X_PREFIX."files_comments c LEFT JOIN ".X_PREFIX."members m ON m.username=c.author WHERE c.fid='$id' ORDER BY cid DESC LIMIT $start_limit, $SETTINGS[files_cpp]");
        while($comment = $db->fetch_array($commentquery)) {
            $comment['subject'] = checkOutput(stripslashes($comment['subject']), 'no', '', true);
            $comment['message'] = postify($comment['message'], $comment['smiliesoff'], $comment['bbcodeoff'], $category['smilies'], $category['html'], $category['bbcode']);
            $comment['message'] = stripslashes($comment['message']);

            if ($comment['icon'] != '' && file_exists($THEME['smdir'].'/'.$comment['icon'])) {
                $icon = '<img src="'.$THEME['smdir'].'/'.$comment['icon'].'" border="0" alt="" /> ';
            } else {
                $icon = '';
            }

            $editcomment = '';
            if (X_MEMBER && ($xmbuser == $comment['author'] || X_STAFF)) {
                eval('$editcomment .= "'.template('files_file_comments_edit').'";');
            }

            $reportcomment = '';
            if ($SETTINGS['files_comment_report'] == 'on') {
                eval('$reportcomment = "'.template('files_file_comments_report').'";');
            }

            if ($comment['author'] == 'xguest123') {
                $author = '<strong>'.$lang['anonymous'].'</strong>';
            } else {
                $author = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($comment['author']).'"><strong>'.$comment['author'].'</strong></a>';
            }

            $postdate = gmdate($dateformat, $comment['dateposted'] + ($timeoffset * 3600) + ($addtime * 3600));
            $posttime = gmdate($timecode, $comment['dateposted'] + ($timeoffset * 3600) + ($addtime * 3600));

            $posted = $lang['postedby'].' '.$author.' '.$lang['on'].' '.$postdate.' '.$lang['at'].' '.$posttime;

            if ($comment['usesig'] == 'yes') {
                $comment['sig'] = postify($comment['sig'], $comment['smiliesoff'], $comment['bbcodeoff'], $category['smilies'], $category['html'], $category['bbcode']);
                $comment['message'] .= '<br /><hr />'.stripslashes($comment['sig']);
            }

            if ($comment['updatedby'] == 'xguest123') {
                $updateauthor = '<strong>'.$lang['anonymous'].'</strong>';
            } else {
                $updateauthor = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($comment['updatedby']).'"><strong>'.$comment['updatedby'].'</strong></a>';
            }

            if ($comment['dateposted'] < $comment['dateupdated']) {
                $updatedate = gmdate($dateformat, $comment['dateupdated'] + ($timeoffset * 3600) + ($addtime * 3600));
                $updatetime = gmdate($timecode, $comment['dateupdated'] + ($timeoffset * 3600) + ($addtime * 3600));
                $posted .= '<br />'.$lang['updatedby'].' '.$updateauthor.' '.$lang['on'].' '.$updatedate.' '.$lang['at'].' '.$updatetime;
            }

            eval('$rows .= "'.template('files_file_comments_rows').'";');

            if ($thisbg == $THEME['altbg2']) {
                $thisbg = $THEME['altbg1'];
            } else {
                $thisbg = $THEME['altbg2'];
            }
        }
        $db->free_result($commentquery);

        $totalquery = $db->query("SELECT COUNT(*) FROM ".X_PREFIX."files_comments WHERE fid='$file[id]'");
        $totalcomments = $db->result($totalquery, 0);
        $db->free_result($totalquery);

        $multipage = multi($totalcomments, $SETTINGS['files_cpp'], $page, 'files.php?action=file&amp;id='.intval($file['id']));

        $file_comments = '';
        if ($totalcomments != 0) {
            eval('$file_comments = "'.template('files_file_comments').'";');
        }
        eval('echo "'.template('files_file').'";');
        break;

    case 'rate':
        $fid = (isset($fid) ? (int)$fid : 0);

        $navigation = files_navigation($fid, $lang['ratefile']);

        eval('echo "'.template('header').'";');

        if (empty($fid) || $fid != (int)$file['id']) {
            files_errormsg($lang['selectratefile']);
        }

        $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));

        if (empty($whoview)) {
            files_errormsg($lang['cannotviewfile']);
        }

        $whoview = '';

        $whorate = files_permissions($category['whorate'], stripslashes($category['ratelist']));

        if (empty($whorate)) {
            files_errormsg($lang['cannotratefile']);
        }

        $whorate = '';

        if (empty($_POST['rating'])) {
            files_errormsg($lang['noratingselected']);
        }

        $ipaddy = $_SERVER['REMOTE_ADDR'];

        $result = $db->query("SELECT ip, file FROM ".X_PREFIX."files_votes WHERE ip='$ipaddy'");
        while($vote = $db->fetch_array($result)) {
            if ($vote['file'] == $fid) {
                files_errormsg($lang['ratefileerror']);
            }
        }
        $db->free_result($result);

        $db->query("UPDATE ".X_PREFIX."files SET rating=rating+ $rating, votes=votes+1 WHERE id='$fid'");

        $db->query("INSERT INTO ".X_PREFIX."files_votes (ip, file) VALUES ('$ipaddy', '$fid')");

        files_confirmmsg($lang['ratingsubmitted'], 'files.php?action=file&id='.$fid);
        break;

    case 'email':
        $fid = (isset($fid) ? (int)$fid : 0);

        $navigation = files_navigation($fid, $lang['emailfriend']);

        eval('echo "'.template('header').'";');

        if (empty($fid) || $fid != (int)$file['id']) {
            files_errormsg($lang['selectemailfile']);
        }

        $whoemail = files_permissions($category['whoemail'], stripslashes($category['emaillist']));

        if (empty($whoemail)) {
            files_errormsg($lang['cannotemailfile']);
        }

        $whoemail = '';

        if (!isset($_POST['emailsubmit'])) {
            $link = $SETTINGS['boardurl'];
            $link .= 'files.php?action=file&amp;id='.$fid;

            $emailsubject = $file['name'];
            $emailmessage = "$lang[sendemailmessage]\n\n$link";
            eval('echo stripslashes("'.template('files_email').'");');
        }

        if (isset($_POST['emailsubmit'])) {
            if (empty($_POST['fromemail'])) {
                files_errormsg($lang['noyouremail']);
            }

            if (empty($_POST['sendtoemail'])) {
                files_errormsg($lang['norecipientemail']);
            }

            if (empty($_POST['subject'])) {
                files_errormsg($lang['noemailsubject']);
            }

            if (empty($_POST['message'])) {
                files_errormsg($lang['noemailmessage']);
            }

            $_POST['subject'] = stripslashes($_POST['subject']);
            $_POST['message'] = stripslashes($_POST['message']);

            altMail($_POST['sendtoemail'], "$_POST[subject]", "$_POST[sendtoname],\n\n$_POST[message]\n\n$lang[sendemailfooter]", "From: $_POST[fromname] <$_POST[fromemail]>");
            files_confirmmsg($lang['emailsent'], 'files.php?action=file&id='.$fid);
        }
        break;

    case 'report':
        $fid = (isset($fid) ? (int)$fid : 0);

        $navigation = files_navigation($fid, ''.$lang['report'].' '.$lang['file'].'');

        eval('echo "'.template('header').'";');

        if ($SETTINGS['files_report'] == 'off') {
            files_errormsg($lang['featuredisabled']);
        }

        if ($fid != (int)$file['id'] || $fid == 0) {
            files_errormsg($lang['selectreportfile']);
        }

        $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));

        if (empty($whoview)) {
            files_errormsg($lang['cannotviewfile']);
        }

        $whoview = '';

        if (!isset($_POST['reportsubmit'])) {
            eval('echo "'.template('files_report').'";');
        }

        if (isset($_POST['reportsubmit'])) {
            if (empty($_POST['reason'])) {
                files_errormsg($lang['noreportreason']);
            }

            $url = $SETTINGS['boardurl'];
            $url .= 'files.php?action=file&id='.$fid;

            $message = "$lang[reportfilemessage]\n\n$url\n\n[b]$lang[reason]:[/b] $reason";

            $query = $db->query("SELECT username FROM ".X_PREFIX."members WHERE status='Super Administrator' OR status='Administrator'");
            while($member = $db->fetch_array($query)) {
                if ($member['username'] != '') {
                    $db->query("INSERT INTO ".X_PREFIX."u2u (msgto, msgfrom, type, owner, folder, subject, message, dateline, readstatus, sentstatus) VALUES ('$member[username]', '$xmbuser', 'incoming', '$member[username]', 'Inbox', '*** $lang[reportfilesubject] ***', '$message', '".$onlinetime."', 'no', 'yes')");
                }
            }
            $db->free_result($query);

            files_confirmmsg($lang['filereported'], 'files.php?action=file&id='.$fid);
        }
        break;

    case 'search':
        nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
        nav($lang['search'].' '.$lang['downloadcenter']);

        eval('echo "'.template('header').'";');

        if ($SETTINGS['files_search'] == 'off') {
            files_errormsg($lang['featuredisabled']);
        }

        if (!isset($searchsubmit) && !isset($page)) {
            $listcats = array();
            $listcats[] = '<select name="category">';
            $listcats[] = '<option value="all">'.$lang['all'].'</option>';
            $catquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE status='on' AND parent='0' ORDER BY name");
            while($cat = $db->fetch_array($catquery)) {
                $whoviewcat = files_permissions($cat['whoview'], stripslashes($cat['viewlist']));
                if (!empty($whoviewcat)) {
                    $cat['name'] = stripslashes($cat['name']);
                    if ($cat['name'] != '') {
                        $listcats[] = '<option value="'.intval($cat['id']).'">'.$cat['name'].'</option>';
                    }
                }

                $subquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE status='on' AND parent='$cat[id]' ORDER BY name");
                while($sub = $db->fetch_array($subquery)) {
                    $whoviewsub = files_permissions($sub['whoview'], stripslashes($sub['viewlist']));
                    if (!empty($whoviewsub)) {
                        $sub['name'] = stripslashes($sub['name']);
                        if ($sub['name'] != '') {
                            $listcats[] = '<option value="'.intval($sub['id']).'">&nbsp;&nbsp;&nbsp;'.$sub['name'].'</option>';
                        }
                    }
                }
                $db->free_result($subquery);
                $whoviewcat = $whoviewsub = '';
            }
            $listcats[] = '</select>';
            $listcats = implode("\n", $listcats);
            $db->free_result($catquery);
            eval('echo "'.template('files_search').'";');
        }

        if (isset($searchsubmit) || isset($page)) {
            foreach($_POST as $key => $val) {
                $$key = $val;
            }

            $startsearchtime = explode(' ', microtime());
            $startsearch = $startsearchtime[1] + $startsearchtime[0];

            $page = (isset($page) && is_numeric($page)) ? ($page < 1 ? 1 : ((int) $page)) : 1;
            $start = ($page > 1) ? (($page-1) * $SETTINGS['files_spp']) : 0;

            $sql = "SELECT f.*, c.id AS catid, c.name AS catname, c.whoview AS catview, c.viewlist FROM ".X_PREFIX."files f LEFT JOIN ".X_PREFIX."files_categories c ON c.id=f.catid WHERE f.status='approved'";

            if ($category == 'all') {
                $sql .= " AND f.catid != ''";
            } else if ((int)$category > 0) {
                $sql .= " AND f.catid='(int)$category'";
            }

            $searchtext = '';
            if ($srchname != '') {
                if ($results == 'similar') {
                    $sql .= " AND f.name LIKE '%$srchname%'";
                } else {
                    $sql .= " AND f.name='$srchname'";
                }
                $searchtext .= $srchname;
            }

            if ($srchdesc != '') {
                if ($results == 'similar') {
                    $sql .= " AND (f.description LIKE '%$srchdesc%' OR f.longdesc LIKE '%$srchdesc%')";
                } else {
                    $sql .= " AND (f.description='$srchdesc' OR f.longdesc='$srchdesc')";
                }
                $searchtext .= $srchdesc;
            }

            if ($creator != '') {
                if ($results == 'similar') {
                    $sql .= " AND f.creator LIKE '%$creator%'";
                } else {
                    $sql .= " AND f.creator='$creator'";
                }
                $searchtext .= $creator;
            }

            if ($ver != '') {
                if ($results == 'similar') {
                    $sql .= " AND f.version LIKE '%$ver%'";
                } else {
                    $sql .= " AND f.version = '$ver'";
                }
                $searchtext .= $ver;
            }

            if (empty($searchtext)) {
                $searchtext = $lang['allfiles'];
            }

            $days = (int)$days;
            if ($days > 0) {
                $days = $onlinetime - (86400 * $days);
                $sql .= " AND f.time >= '$days'";
            }

            $totalquery = $db->query($sql);
            $totalresults = $db->num_rows($totalquery);
            $db->free_result($totalquery);

            $sql .= " ORDER BY f.pin DESC, f.time DESC LIMIT $start, $SETTINGS[files_spp]";
            $query = $db->query($sql);
            $matches = 0;
            $searchresults = '';
            while($file = $db->fetch_array($query)) {
                $whoview = files_permissions($file['catview'], stripslashes($file['viewlist']));
                if (!empty($whoview)) {
                    $file['name']        = stripslashes($file['name']);
                    $file['description'] = stripslashes($file['description']);
                    $file['longdesc']    = stripslashes($file['longdesc']);
                    $file['catname']     = stripslashes($file['catname']);
                    $file['creator']     = stripslashes($file['creator']);
                    $file['version']     = stripslashes($file['version']);

                    if ($srchname != '') {
                        $file['name'] = eregi_replace($srchname, "<strong><font style=\"background-color: $SETTINGS[files_searchcolor]\">".$srchname."</font></strong>", $file['name']);
                    }

                    if ($srchdesc != '') {
                        if ($file['description'] != '') {
                            $description = "<br />" . eregi_replace($srchdesc, "<strong><font style=\"background-color: $SETTINGS[files_searchcolor]\">".$srchdesc."</font></strong>", $file['description']);
                        }

                        if ($file['longdesc'] != '') {
                            $description .= ". " . eregi_replace($srchdesc, "<strong><font style=\"background-color: $SETTINGS[files_searchcolor]\">".$srchdesc."</font></strong>", $file['longdesc']);
                        }
                    } else {
                        if ($file['description'] != '') {
                            $description = "<br />$file[description]";
                        }

                        if ($file['longdesc'] != '') {
                            $description .= ". $file[longdesc]";
                        }
                    }

                    $added = gmdate($dateformat, $file['time']);

                    if ($file['posticon'] != '' && file_exists($THEME['smdir'].'/'.$file['posticon'])) {
                        $icon = '<img src="'.$THEME['smdir'].'/'.$file['posticon'].'" border="0" alt="" />';
                    } else {
                        $icon = '';
                    }

                    if ($file['pin'] == 'yes') {
                        $pin = '<img src="'.$THEME['imgdir'].'/pin.gif" border="0" alt="" />&nbsp;';
                    } else {
                        $pin = '';
                    }

                    if (!empty($file['fee']) && $file['fee'] != '0.00') {
                        $sell = '<img src="'.$THEME['imgdir'].'/dollar.gif" border="0" alt="" />&nbsp;';
                    } else {
                        $sell = '';
                    }

                    $rating = @round($file['rating']/$file['votes']);
                    $stars = '';
                    for($i = 0; $i < $rating; $i++) {
                        $stars .= '<img src="'.$THEME['imgdir'].'/star.gif" border="0" alt="'.$rating.'/10" />';
                        if ($i == 4) {
                            $stars .= '<br />';
                        }
                    }

                    $url = $SETTINGS['boardurl'];
                    $url .= 'files.php?action=file&id='.intval($file['id']);

                    if ($file['creator'] == '') {
                        $file['creator'] = $lang['notavailable'];
                    }

                    $matches++;

                    $mouseover = files_mouseover('files.php?action=file&id='.intval($file['id']));
                    eval('$searchresults .= stripslashes("'.template('files_search_results_rows').'");');
                }
                $whoview = '';
            }
            $db->free_result($query);

            if ($matches == 0) {
                files_errormsg($lang['nofilestodisplay']);
            }

            $endsearchtime = explode(' ', microtime());
            $endsearch = $endsearchtime[1] + $endsearchtime[0];
            $searchtime = ($endsearch - $startsearch);
            $searchtime = number_format($searchtime, 3);

            $mpurl = 'files.php?action=search&amp;srchname='.$srchname.'&amp;srchdesc='.$srchdesc.'&amp;category='.$category.'&amp;creator='.$creator.'&amp;ver='.$ver.'&amp;days='.$days.'&amp;results='.$results;
            $multipage = multi($totalresults, $SETTINGS['files_spp'], $page, $mpurl);
            eval('echo "'.template('files_search_results').'";');
        }
        break;

    default:
        nav($lang['downloadcenter']);
        eval('echo "'.template('header').'";');

        $categories = '';
        $categorynum = 0;
        $filesindb = 0;
        $query = $db->query("SELECT c.id, c.name, c.description, c.icon, c.whoview, c.viewlist, count(f.catid) as files FROM ".X_PREFIX."files_categories c LEFT JOIN ".X_PREFIX."files f ON c.id=f.catid WHERE c.status='on' AND c.parent=0 AND (f.status='approved' || f.status IS NULL) GROUP BY c.id ORDER BY c.displayorder");
        while($category = $db->fetch_array($query)) {
            $filesincat = 0;
            $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));
            if (!empty($whoview)) {
                $filesincat += $category['files'];
                $subgroups = $db->query("SELECT c.id, c.whoview, c.viewlist, count(f.catid) as files FROM ".X_PREFIX."files_categories c LEFT JOIN ".X_PREFIX."files f ON c.id=f.catid WHERE c.status='on' AND parent='$category[id]' AND (f.status='approved' || f.status IS NULL) GROUP BY c.id");
                while($subcategory = $db->fetch_array($subgroups)) {
                    $whoview = files_permissions($subcategory['whoview'], stripslashes($category['viewlist']));
                    if (!empty($whoview)) {
                        $filesincat += $subcategory['files'];
                     }
                }
                $db->free_result($subgroups);

                $category['name'] = stripslashes($category['name']);
                $category['description'] = stripslashes($category['description']);

                $mouseover = files_mouseover('files.php?action=category&id='.intval($category['id']));

                if ($category['icon'] != '') {
                    $icon = '<img src="'.$category['icon'].'" border="0" align="left" alt="" />&nbsp;';
                } else {
                    $icon = '';
                }
                $categorynum = $categorynum + 1;
                $filesindb += $filesincat;
                eval('$categories .= "'.template('files_main_categories').'";');
            }
        }
        $db->free_result($query);

        if ($categorynum == 0) {
            eval('echo "'.template('files_main_none').'";');
        } else {
            $navlink = '';
            if ($SETTINGS['files_navigation'] == 'on') {
                $statslink = '';
                if ($SETTINGS['files_stats'] == 'on') {
                    eval('$statslink = "'.template('files_navigation_statslink').'";');
                }

                $searchlink = '';
                if ($SETTINGS['files_search'] == 'on') {
                    eval('$searchlink = "'.template('files_navigation_searchlink').'";');
                }

                $faqlink = '';
                if ($SETTINGS['files_faq'] == 'on') {
                    eval('$faqlink = "'.template('files_navigation_faqlink').'";');
                }

                $adminlink = '';
                if (X_ADMIN) {
                    eval('$adminlink = "'.template('files_navigation_adminlink').'";');
                }
                eval('$navlink = "'.template('files_navigation').'";');
            }
            $mouseover = files_mouseover('files.php?action=viewall');
            eval('echo "'.template('files_main').'";');
        }
        break;
}

$jumpbox = files_jumpbox();

eval('echo "'.template('files_copyright').'";');

end_time();
eval('echo "'.template('footer').'";');
?>