<?php
/**
 * Title: Download Center
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

if (!defined('IN_CODE')) {
    exit('Not allowed to run this file directly.');
}

function files_permissions($private, $userlist = '') {
    global $self, $xmbuser, $status;

    if ($private == 'admins' && (X_ADMIN)) {
        return true;
    } else if ($private == 'adminsmods' && (X_ADMIN || X_SMOD)) {
        return true;
    } else if ($private == 'staff' && (X_STAFF)) {
        return true;
    } else if ($private == 'all' && (X_STAFF || X_MEMBER) && empty($userlist)) {
        return true;
    } else if ($private == 'all' && (X_STAFF || X_MEMBER) && isset($userlist)) {
        if (X_STAFF) {
            return true;
        }
        $validusers = explode(',', $userlist);
        foreach($validusers as $validuser) {
            if ($xmbuser == trim($validuser)) {
                return true;
            }
        }
        return false;
    } else if ($private == 'guests') {
        return true;
    } else {
        return false;
    }
}

function files_mouseover($url) {
    global $THEME, $SETTINGS;

    $mouseover = '';
    if ($SETTINGS['files_mouseover'] == 'on') {
        $mouseover = "onclick=\"location.href='$url'\" style=\"cursor: pointer; cursor: hand;\" onmouseover=\"this.style.backgroundColor='$THEME[altbg1]'\" onmouseout=\"this.style.backgroundColor='$THEME[altbg2]'\"";
    }
    return $mouseover;
}

function files_errormsg($errormsg) {
    global $THEME, $SETTINGS, $starttime, $totaltime, $footerstuff, $jumpbox;

    reset($GLOBALS);
    while(list ($key, $val) = each($GLOBALS)) {
        $$key = $val;
    }
    eval('echo "'.template('files_error').'";');
    eval('echo "'.template('files_copyright').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

function files_confirmmsg($confirmmsg, $url) {
    global $THEME, $lang;

    eval('echo "'.template('files_confirm').'";');
    if (!empty($url)) {
        redirect($url, 2.5, X_REDIRECT_JS);
    }
}

function files_posticons() {
    global $THEME, $db, $self, $posticon, $lang, $cheHTML;

    $listed_icons = 0;
    $icons = '<input type="radio" name="posticon" value="" '.$cheHTML.' />'.$lang['none'];
    $query = $db->query("SELECT * FROM ".X_PREFIX."smilies WHERE type='picon'");
    while($smilie = $db->fetch_array($query)) {
        if ($posticon == $smilie['url']) {
            $icons .= '&nbsp;<input type="radio" name="posticon" value="'.$smilie['url'].'" checked="checked" />&nbsp;<img src="'.$THEME['smdir'].'/'.$smilie['url'].'" border="0" alt="" />';
        } else {
            $icons .= '&nbsp;<input type="radio" name="posticon" value="'.$smilie['url'].'" />&nbsp;<img src="'.$THEME['smdir'].'/'.$smilie['url'].'" border="0" alt="" />';
        }
        $listed_icons += 1;
        if ($listed_icons == 10) {
            $icons .= '<br />';
            $listed_icons = 0;
        }
    }
    $db->free_result($query);
    return $icons;
}

function files_letters($url) {
    global $THEME, $lang, $edit;

    $letters = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', $lang['misc']);
    $lettersort = '<tr>';

    if (isset($edit)) {
        $lettersort .= '<td class="ctrtablerow" bgcolor="'.$THEME['altbg2'].'"><a href="'.$url.'">'.$lang['all'].'</a></td>';
    } else {
        $lettersort .= '<td class="ctrtablerow" bgcolor="'.$THEME['altbg1'].'"><u>'.$lang['all'].'</u></td>';
    }

    for($i = 0; $i < count($letters); $i++) {
        if ($edit == strtolower($letters[$i])) {
            $lettersort .= '<td class="ctrtablerow" bgcolor="'.$THEME['altbg1'].'"><u>'.$letters[$i].'</u></td>';
        } else {
            $lettersort .= '<td class="ctrtablerow" bgcolor="'.$THEME['altbg2'].'"><a href="'.$url.'&amp;edit='.strtolower($letters[$i]).'">'.$letters[$i].'</a></td>';
        }
    }
    $lettersort .= '</tr>';
    return $lettersort;
}

function files_navigation($nid, $text) {
    global $db, $lang, $file, $category, $navigation;

    $query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE id='$nid'");
    $file = $db->fetch_array($query);
    $db->free_result($query);

    $file['name'] = stripslashes($file['name']);
    if (!empty($nid) && $nid == (int)$file['id']) {
        $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE id='$file[catid]'");
        $category = $db->fetch_array($query);
        $db->free_result($query);
        $category['name'] = stripslashes($category['name']);
        if ($category['parent'] == 0) {
            nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
            nav('<a href="files.php?action=category&amp;id='.intval($file['catid']).'">'.$category['name'].'</a>');
            nav('<a href="files.php?action=file&amp;id='.intval($nid).'">'.$file['name'].'</a>');
        } else {
            $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE id = '$category[parent]'");
            $parent = $db->fetch_array($query);
            $db->free_result($query);
            $parent['name'] = stripslashes($parent['name']);
            nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
            nav('<a href="files.php?action=category&amp;id='.intval($parent['id']).'">'.$parent['name'].'</a>');
            nav('<a href="files.php?action=category&amp;id='.intval($category['id']).'">'.$category['name'].'</a>');
            nav('<a href="files.php?action=file&amp;id='.intval($nid).'">'.$file['name'].'</a>');
        }
    } else {
        nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
    }

    if (!empty($text)) {
        $navigation .= ' &raquo; '.$text;
    }
    return $navigation;
}

function files_bbcodeinsert() {
    global $THEME, $lang, $SETTINGS, $spelling_lang;

    $bbcode = '';
    if ($SETTINGS['bbinsert'] == 'on') {
        eval('$bbcode = "'.template('functions_bbcodeinsert').'";');
    }
    return $bbcode;
}

function files_category_array() {
    global $db, $self;

    $catarray = array();
    $i = 0;
    $query = $db->query("SELECT id, parent, whoview, viewlist FROM ".X_PREFIX."files_categories ORDER BY parent ASC, id ASC");
    while($category = $db->fetch_array($query)) {
        $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));
        if (!empty($whoview)) {
            if ($category['parent'] == 0) {
                $catarray[$i] = (int)$category['id'];
                $i++;
            } else {
                if (in_array($category['parent'], $catarray)) {
                    $catarray[$i] = (int)$category['id'];
                    $i++;
                }
            }
        }
    }
    $db->free_result($query);
    return $catarray;
}

function files_jumpbox() {
    global $db, $self, $id, $lang, $SETTINGS;

    if ($SETTINGS['files_jumpbox'] != 'off') {
        $parentarray = array();
        $childarray = array();
        $i = 0;
        $j = 0;
        $query = $db->query("SELECT id, parent, name, whoview, viewlist  FROM ".X_PREFIX."files_categories WHERE status='on' ORDER BY name ASC");
        while($category = $db->fetch_array($query)) {
            $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));
            if (!empty($whoview)) {
                if ($category['parent'] == 0) {
                    $catrow = array('id' => (int)$category['id'], 'name' => stripslashes($category['name']));
                    $parentarray[$i] = $catrow;
                    $i++;
                } else {
                    $catrow = array('id' => (int)$category['id'], 'name' => '&nbsp;&nbsp;&nbsp;'.stripslashes($category['name']), 'parent' => (int)$category['parent']);
                    $childarray[$j] = $catrow;
                    $j++;
                }
            }
        }
        $db->free_result($query);

        $jumpbox = "\n<select onChange=\"if (this.options[this.selectedIndex].value) { window.location=('' + this.options[this.selectedIndex].value) }\">\n";
        $jumpbox .= '<option value="">'.$lang['selectcategory'].':</option>\n';
        $jumpbox .= '<option value="">--------------------</option>\n';
        for($i = 0; $i < count($parentarray); $i++) {
            if (isset($id) && $id == (int)$parentarray[$i]['id']) {
                $jumpbox .= '<option selected value="files.php?action=category&amp;id='.intval($parentarray[$i]['id']).'">'.stripslashes($parentarray[$i]['name']).'</option>\n';
            } else {
                $jumpbox .= '<option value="files.php?action=category&amp;id='.intval($parentarray[$i]['id']).'">'.stripslashes($parentarray[$i]['name']).'</option>\n';
            }

            for($j = 0; $j < count($childarray); $j++) {
                if ($childarray[$j]['parent'] == (int)$parentarray[$i]['id']) {
                    if (isset($id) && $id == (int)$childarray[$j]['id']) {
                        $jumpbox .= '<option selected value="files.php?action=category&amp;id='.intval($childarray[$j]['id']).'">'.stripslashes($childarray[$j]['name']).'</option>\n';
                    } else {
                        $jumpbox .= '<option value="files.php?action=category&amp;id='.intval($childarray[$j]['id']).'">'.stripslashes($childarray[$j]['name']).'</option>\n';
                    }
                }
            }
        }
        $jumpbox = stripslashes($jumpbox);
        $jumpbox = '<tr><td align="right">'.$jumpbox.'</td></tr>';
        return $jumpbox;
    }
}

function files_paidpermissions($userlist = '') {
    global $self, $xmbuser, $status;

    if (X_SADMIN) {
        return true;
    } elseif (X_MEMBER && isset($userlist)) {
        $validusers = explode(',', $userlist);
        foreach($validusers as $validuser) {
            if ($xmbuser == trim($validuser)) {
                return true;
            }
        }
        return false;
    } else {
        return false;
    }
}

function files_url_chk($url) {
    $url = trim(strip_tags($url));
    $url = addslashes(str_replace(' ', '%20', $url));
    $url = ((false !== strpos($url, "http://")) ? $url : 'http://' . $url);
    $url = (preg_match("#([a-z0-9+\-.]+)://(?:((?:[a-z0-9$\-_.+!*'\(\),;?&=]+)?(?::[a-z0-9$\-_.+!*'\(\),;?&=]+)?)@)?(?:((?:[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3})|(?:(?:(?:(?:[a-z0-9][a-z0-9\-]*[a-z0-9])\.)*[a-z]+)|[a-z0-9]+)|[a-z][a-z0-9\-]*[a-z0-9])(?::([0-9]+))?)((?:/( ?:[a-z0-9$\-_.+!*'\(\),]|%[0-9a-f][0-9a-f])*)*)(?:(?:\?((?:[;:@&=a-z0-9$\-_.+!*'\(\),]|%[0-9a-f][0-9a-f])+)+)?)(?:(?:\#((?:[;:@&=a-z0-9$\-_.+!*'\(\),]|%[0-9a-f][0-9a-f])+)+)?)?#mi", $url))  ? $url : '';
    return $url;
}
?>