<?php
/**
 * Title: Portal System
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'portal.php');

require 'header.php';

$tid = (isset($tid) && is_numeric($tid)) ? (int) $tid : 0;

loadtemplates(
'index_ticker',
'index_whosonline',
'index_whosonline_today',
'portal_guest',
'portal_home',
'portal_main_block',
'portal_main_menu',
'portal_member',
'portal_member_mood',
'portal_newmember',
'portal_newposts',
'portal_news',
'portal_news_archive',
'portal_quick_reg',
'portal_quick_reg_captcha',
'portal_quick_reg_password',
'portal_top_members'
);

eval('$css = "'.template('css').'";');

smcwcache();

if ($SETTINGS['portaltitle'] != '') {
    nav(stripslashes($SETTINGS['portaltitle']));
} else if ($SETTINGS['portaltitle'] == '') {
    nav($lang['portalnav']);
}

eval('echo "'.template('header').'";');

if ($SETTINGS['portalstatus'] != 'on') {
    error($lang['portaloffmsg'], false);
}

$plinks = array();

if ($SETTINGS['portalstatus'] == 'on' && $SETTINGS['portalview'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="index.php?forums"><font class="smalltxt">'.$lang['portalmainnav'].'</font></a>';
} else {
    $plinks[] = '&raquo;&nbsp;<a href="index.php"><font class="smalltxt">'.$lang['portalmainnav'].'</font></a>';
}

if ($SETTINGS['searchstatus'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="misc.php?action=search"><font class="smalltxt">'.$lang['textsearch'].'</font></a>';
}

if ($SETTINGS['faqstatus'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="faq.php"><font class="smalltxt">'.$lang['textfaq'].'</font></a>';
}

if ($SETTINGS['memliststatus'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="misc.php?action=list"><font class="smalltxt">'.$lang['textmemberlist'].'</font></a>';
}

if ($SETTINGS['topicactivity_status'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="activity.php"><font class="smalltxt">'.$lang['topicactivity'].'</font></a>';
}

if ($SETTINGS['stats'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="stats.php"><font class="smalltxt">'.$lang['navstats'].'</font></a>';
}

if ($SETTINGS['bbrules'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="faq.php?page=forumrules"><font class="smalltxt">'.$lang['textbbrules'].'</font></a>';
}

$plinks = implode("<br />", $plinks);

$modXmbuser = str_replace(array('*', '.', '+'), array('\*', '\.', '\+'), $xmbuser);
$restrict = array("(password='')");
switch($self['status']) {
    case 'Member':
        $restrict[] = 'private = 1';
        $restrict[] = "(userlist = '' OR userlist REGEXP '(^|(,))([:space:])*$modXmbuser([:space:])*((,)|$)')";
        break;
    case 'Moderator':
    case 'Super Moderator':
        $restrict[] = '(private = 1 OR private = 3)';
        $restrict[] = "(if ((private=1 AND userlist != ''), if ((userlist REGEXP '(^|(,))([:space:])*$modXmbuser([:space:])*((,)|$)'), 1, 0), 1))";
        break;
    case 'Administrator':
        $restrict[] = '(private > 0 AND private < 4)';
        $restrict[] = "(if ((private=1 AND userlist != ''), if ((userlist REGEXP '(^|(,))([:space:])*$modXmbuser([:space:])*((,)|$)'), 1, 0), 1))";
        break;
    case 'Super Administrator':
        break;
    default:
        $restrict[] = '(private=1)';
        $restrict[] = "(userlist='')";
        break;
}
$restrict = implode(' AND ', $restrict);

$bbname = stripslashes($bbname);
$sitename = stripslashes($sitename);

$sql = $db->query("SELECT COUNT(uid) FROM ".X_PREFIX."members WHERE lastvisit!=0 UNION ALL SELECT COUNT(tid) FROM ".X_PREFIX."threads UNION ALL SELECT COUNT(pid) FROM ".X_PREFIX."posts");
$portal_members = $db->result($sql, 0);
if ($portal_members == false) {
    $portal_members = 0;
}

$portal_threads = $db->result($sql, 1);
if ($portal_threads == false) {
    $portal_threads = 0;
}

$portal_posts = $db->result($sql, 2);
if ($portal_posts == false) {
    $portal_posts = 0;
}
$db->free_result($sql);

$portal_newest_topic = '';
$sql = $db->query("SELECT t.views, t.tid, t.subject FROM ".X_PREFIX."threads t, ".X_PREFIX."forums f WHERE $restrict AND f.fid = t.fid ORDER BY views DESC LIMIT 0,1");
while ($last = $db->fetch_array($sql)) {
    $last_subject = shortenString($last['subject'], 100, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $last_subject = stripslashes(censor(checkOutput($last['subject'], 'no', '', true)));
    $portal_newest_topic .= '<a href="viewthread.php?tid='.intval($last['tid']).'">'.$last_subject.'</a>';
}
$db->free_result($sql);

$sql = $db->query("SELECT regdate FROM ".X_PREFIX."members ORDER BY regdate LIMIT 0, 1");
$days = ($onlinetime - @$db->result($sql, 0)) / 86400;
if ($days > 0) {
    $membersday = number_format(($portal_members / $days), 2);
} else {
    $membersday = number_format(0, 2);
}
$db->free_result($sql);

$timesearch = $onlinetime - 86400;
$eval = $lang['evalnobestmember'];

$sql = $db->query("SELECT author, COUNT(author) AS Total FROM ".X_PREFIX."posts WHERE dateline >= '$timesearch' GROUP BY author ORDER BY Total DESC LIMIT 1");
$info = $db->fetch_array($sql);
$db->free_result($sql);

if ($info['Total'] != 0) {
    $portal_membesthtml = '<a href="member.php?action=viewpro&amp;member='.recodeOut($info['author']).'"><strong>'.$info['author'].'</strong></a>';
} else {
    $portal_membesthtml = $lang['textnone'];
}

if (isset($smileyoff) && $smileyoff == 'yes') {
    $smileyoff = 'yes';
} else {
    $smileyoff = 'no';
}

if (isset($bbcodeoff) && $bbcodeoff == 'yes') {
    $bbcodeoff = 'yes';
} else {
    $bbcodeoff = 'no';
}

$portal_news = '';
$SETTINGS['portalnewsfid'] = intval($SETTINGS['portalnewsfid']);
$SETTINGS['portalnewsdisplays'] = intval($SETTINGS['portalnewsdisplays']);
$SETTINGS['portaldgif'] = stripslashes($SETTINGS['portaldgif']);
$sql = $db->query("SELECT * FROM ".X_PREFIX."forums WHERE fid='{$SETTINGS['portalnewsfid']}'");
$forum = $db->fetch_array($sql);
$db->free_result($sql);
$sql = $db->query("SELECT DISTINCT * FROM ".X_PREFIX."posts WHERE fid='{$SETTINGS['portalnewsfid']}' GROUP BY (tid) ORDER BY dateline DESC LIMIT 0, {$SETTINGS['portalnewsdisplays']}");
while($news = $db->fetch_array($sql)) {
    $tid = '';
    $author = '<a href="member.php?action=viewpro&amp;member='.recodeOut($news['author']).'">'.$news['author'].'</a>';
    $tid = intval($news['tid']);
    $date = gmdate($dateformat, $news['dateline'] + ($timeoffset * 3600) + ($addtime * 3600));
    $time = gmdate($timecode, $news['dateline'] + ($timeoffset * 3600) + ($addtime * 3600));
    $formatdate = $date.' '.$lang['textat'].' '.$time;

    if ($news['subject'] == '') {
        $news['subject'] = $lang['textnosub'];
    }

    $subject = stripslashes(censor($news['subject']));
    $message = stripslashes(censor($news['message']));
    $subject = shortenString($news['subject'], 75, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $subject = checkOutput(censor($news['subject']), 'no', '', true);
    $message = shortenString($news['message'], 300, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $message = checkOutput(censor($news['message']), 'no', '', true);
    $message = postify($message, $smileyoff, $bbcodeoff, $forum['allowsmilies'], $forum['allowhtml'], $forum['allowbbcode'], $forum['allowimgcode'], false);

    $sqlnext = $db->query("SELECT COUNT(*) FROM ".X_PREFIX."posts WHERE tid='$tid'");
    $comments = $db->result($sqlnext, 0);
    $comments -= 1;
    if ($comments == 1) {
        $comment_txt = $lang['portalcomment'];
    } else {
        $comment_txt = $lang['portalcomments'];
    }

    if ($comments > 0) {
        $comments = '<a href="viewthread.php?tid='.$tid.'">'.$comments.' '.$comment_txt.'</a> |';
    } else {
        $comments = '';
    }

    if (isset($news['icon']) && $news['icon'] != '' && file_exists($THEME['smdir'].'/'.$news['icon'])) {
        $icon = '<img src="'.$THEME['smdir'].'/'.$news['icon'].'" border="0" alt="'.$news['icon'].'" />';
    } else {
        $icon = '<img src="'.$THEME['smdir'].'/'.$SETTINGS['portaldgif'].'" border="0" alt="'.$SETTINGS['portaldgif'].'" />';
    }

    $close = $db->query("SELECT closed FROM ".X_PREFIX."threads WHERE tid='$tid'");
    $closed = $db->result($close, 0);
    if ($closed == 'yes') {
        $postcomment = $lang['portalclosed'].' |';
    } else {
        $postcomment = '<a href="post.php?action=reply&amp;fid='.$SETTINGS['portalnewsfid'].'&amp;tid='.$tid.'">'.$lang['textreply'].'</a> |';
    }

    if (X_MEMBER) {
        $subscriptionlink = ' | <a href="memcp.php?action=subscriptions&amp;subadd='.$tid.'">'.$lang['textsubscribe'].'</a>';
    } else {
        $subscriptionlink = '';
    }
    eval('$portal_ne = "'.template('portal_news').'";');
    $portal_news .= $portal_ne;
}
$db->free_result($sql);
eval('$portal_news_archive = "'.template('portal_news_archive').'";');

$memcount = 1;
$top_members_list = '';
$SETTINGS['portaltopmembers'] = intval($SETTINGS['portaltopmembers']);
$sql = $db->query("SELECT * FROM ".X_PREFIX."members ORDER BY postnum DESC LIMIT 0, $SETTINGS[portaltopmembers]");
while($top_member = $db->fetch_array($sql)) {
    if ($top_members_list == '') {
        $avatar = '';
        if ($top_member['avatar'] != '' && $SETTINGS['portalavatar'] == 'on') {
            $avatar = '<img src="'.$top_member['avatar'].'" border="0" alt="'.$lang['altavatar'].'" /></a></div><br />';
        }

        $top_members_list = '<div align="center"><a href="member.php?action=viewpro&amp;member='.recodeOut($top_member['username']).'">'.$avatar.'<strong>'.$memcount.'. <a href="member.php?action=viewpro&amp;member='.recodeOut($top_member['username']).'">'.$top_member['username'].'</a></strong><br /><strong>'.$lang['portalrank'].'</strong>: '.$top_member['status'].'<br /><strong>'.$lang['memposts'].'</strong>: '.$top_member['postnum'].'<br /><hr />';
        $memcount++;
    } else {
        $top_members_list .= '<strong>'.$memcount.'. <a href="member.php?action=viewpro&amp;member='.recodeOut($top_member['username']).'" title="'.$lang['memposts'].' '.$top_member['postnum'].'">'.$top_member['username'].'</a></strong><br /><strong>'.$lang['portalrank'].'</strong>: '.$top_member['status'].'<br /><strong>'.$lang['memposts'].'</strong>: '.$top_member['postnum'].'<br /><br />';
        $memcount++;
    }
}
$db->free_result($sql);

$SETTINGS['portalpostsnull'] = stripslashes($SETTINGS['portalpostsnull']);
if (!eregi("[1-9]", $SETTINGS['portalpostsnull'])) {
    $dont_fid1 = $dont_fid2 = '';
} else {
    $dont_fid1 = "AND t.fid NOT IN($SETTINGS[portalpostsnull])";
    $dont_fid2 = "t.fid NOT IN($SETTINGS[portalpostsnull]) AND";
}

$portal_hot_subject = '';
$SETTINGS['portalhotdate'] = intval($SETTINGS['portalhotdate']);
$SETTINGS['portalhottopics'] = intval($SETTINGS['portalhottopics']);
$portal_hotdate = $onlinetime - ($SETTINGS['portalhotdate'] * 86400);
$sql = $db->query("SELECT t.tid, t.subject FROM ".X_PREFIX."threads t, ".X_PREFIX."forums f WHERE f.fid = t.fid AND (substring_index(t.lastpost, '|',1)+1) >= '$portal_hotdate' $dont_fid1 AND $restrict ORDER BY replies DESC LIMIT 0, $SETTINGS[portalhottopics]");
while($reply = $db->fetch_array($sql)) {
    $reply_subject = shortenString($reply['subject'], 100, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $reply_subject = stripslashes(censor(checkOutput($reply['subject'], 'no', '', true)));
    $portal_hot_subject .= '<br /><a href="viewthread.php?tid='.intval($reply['tid']).'">'.$reply_subject.'</a>';
}
$db->free_result($sql);

$count = 0;
$thisbg = $THEME['altbg2'];
$post_list = '';
$SETTINGS['portalmposts'] = intval($SETTINGS['portalmposts']);
$sql = $db->query("SELECT t.icon, t.tid, t.subject FROM ".X_PREFIX."threads t, ".X_PREFIX."forums f WHERE $dont_fid2 f.fid = t.fid AND $restrict ORDER BY t.lastpost DESC LIMIT 0, $SETTINGS[portalmposts]");
while($last = $db->fetch_array($sql)) {
    $last['subject'] = stripslashes(censor(checkOutput($last['subject'], 'no', '', true)));
    if (isset($last['icon']) && $last['icon'] != '' && file_exists($THEME['smdir'].'/'.$last['icon'])) {
        $last['icon'] = '<img src="'.$THEME['smdir'].'/'.$last['icon'].'" alt="'.$last['icon'].'" border="0" />';
    } else {
        $last['icon'] = '<img src="'.$THEME['smdir'].'/'.$SETTINGS['portaldgif'].'" alt="'.$SETTINGS['portaldgif'].'" border="0" />';
    }

    if ($count == 0) {
        $portal_newest_topic = '<a href="viewthread.php?tid='.intval($last['tid']).'">'.html_entity_decode($last['subject']).'</a>';
    }

    $post_list .= '<tr bgcolor="'.$thisbg.'" class="tablerow"><td width="1">'.$last['icon'].'</td><td><a href="viewthread.php?tid='.intval($last['tid']).'">'.html_entity_decode($last['subject']).'</a></td></tr>';
    $post_list .= "\n";

    if ($thisbg == $THEME['altbg2']) {
        $thisbg = $THEME['altbg1'];
    } else {
        $thisbg = $THEME['altbg2'];
    }
    $count++;
}
$db->free_result($sql);

$num = 0;
$new_members_list = '';
$SETTINGS['portalnewmembers'] = intval($SETTINGS['portalnewmembers']);
$sql = $db->query("SELECT username FROM ".X_PREFIX."members WHERE lastvisit!=0 ORDER BY regdate DESC LIMIT 0, $SETTINGS[portalnewmembers]");
while($lastmem = $db->fetch_array($sql)) {
    if ($num == 0) {
        $portal_newest_member = '<a href="member.php?action=viewpro&amp;member='.recodeOut($lastmem['username']).'"><strong>'.$lastmem['username'].'</strong></a>';
    }
    $new_members_list .= '<a href="member.php?action=viewpro&amp;member='.recodeOut($lastmem['username']).'">'.$lastmem['username'].'</a><br />';
    $num++;
}
$db->free_result($sql);

$portal_quickreg = '';
if (X_GUEST) {
    $pwtd = '';
    if ($SETTINGS['emailcheck'] != 'on') {
        eval('$pwtd = "'.template('portal_quick_reg_password').'";');
    }

    $captcharegcheck = '';
    if ($SETTINGS['captcha_status'] == 'on' && $SETTINGS['captcha_reg_status'] == 'on' && !DEBUG) {
        require ROOT.'include/captcha.inc.php';
        $Captcha = new Captcha(250, 50);
        if ($Captcha->bCompatible !== false) {
            $imghash = $Captcha->GenerateCode();
            if ($SETTINGS['captcha_code_casesensitive'] == 'off') {
                $lang['captchacaseon'] = '';
            }
            eval('$captcharegcheck = "'.template('portal_quick_reg_captcha').'";');
        }
    }

    $portal_quickreg = '';
    if ($SETTINGS['regstatus'] == 'on') {
        eval('$portal_quickreg = "'.template('portal_quick_reg').'";');
    }
    eval('$portal_welcome = "'.template('portal_guest').'";');
}

if (X_MEMBER) {
    if ($self['avatar'] == '') {
        $avatar = '';
    } else {
        $avatar = '<img src="'.$self['avatar'].'" border="0" alt="'.$lang['altavatar'].'" /><br />';
    }
    eval('$portal_welcome = "'.template('portal_member').'";');
}

$ticker = '';
if ($SETTINGS['tickerstatus'] == 'on') {
    $contents = '';
    $news = explode("\n", str_replace(array("\r\n", "\r"), array("\n"), $tickercontents));
    for($i = 0; $i <count($news); $i++) {
        if (strlen(trim($news[$i])) == 0) {
            continue;
        }
        $news[$i] = postify($news[$i], 'no', 'no', 'yes', 'no', 'yes', 'yes', false, 'yes', 'no');
        $news[$i] = str_replace('\"', '"', addslashes($news[$i]));
        $contents .= "\tcontents[$i]='$news[$i]';\n";
    }
    eval('$ticker = "'.template('index_ticker').'";');
}

$whosonline = $whosonlinetoday = '';
if ($SETTINGS['whosonlinestatus'] == 'on') {
    $guestcount = $membercount = $hiddencount = 0;
    $member = array();
    $query  = $db->query("SELECT m.status, m.username, m.invisible, w.* FROM ".X_PREFIX."whosonline w LEFT JOIN ".X_PREFIX."members m ON m.username=w.username ORDER BY w.username");
    while($online = $db->fetch_array($query)) {
        switch($online['username']) {
            case 'xguest123':
                $guestcount++;
                break;
            default:
                if ($online['invisible'] != 0 && X_ADMIN) {
                    $member[] = $online;
                    $hiddencount++;
                } else if ($online['invisible'] != 0) {
                    $hiddencount++;
                } else {
                    $member[] = $online;
                    $membercount++;
                }
                break;
        }
    }
    $db->free_result($query);

    $onlinetotal = $guestcount + $membercount;

    if ($membercount != 1) {
        $membern = '<strong>'.$membercount.'</strong> '.$lang['textmembers'];
    } else {
        $membern = '<strong>1</strong> '.$lang['textmem'];
    }

    if ($guestcount != 1) {
        $guestn = '<strong>'.$guestcount.'</strong> '.$lang['textguests'];
    } else {
        $guestn = '<strong>1</strong> '.$lang['textguest1'];
    }

    if ($hiddencount != 1) {
        $hiddenn = '<strong>'.$hiddencount.'</strong> '.$lang['texthmems'];
    } else {
        $hiddenn = '<strong>1</strong> '.$lang['texthmem'];
    }

    eval($lang['whosoneval']);
    $memonmsg = '<span class="smalltxt">'.$lang['whosonmsg'].'</span>';

    $memtally = array();
    $num = 1;
    $show_total = (X_ADMIN) ? ($membercount+$hiddencount) : ($membercount);

    $show_inv_key = false;
    for($mnum=0; $mnum<$show_total; $mnum++) {
        $pre = $suff = '';

        $online = $member[$mnum];

        $pre = '<span class="status_'.str_replace(' ', '_', $online['status']).'">';
        $suff = '</span>';

        if ($online['invisible'] != 0) {
            $pre .= '<strike>';
            $suff = '</strike>'.$suff;
            if (!X_ADMIN && $online['username'] != $xmbuser) {
                $num++;
                continue;
            }
        }

        if ($online['username'] == $xmbuser && $online['invisible'] != 0) {
            $show_inv_key = true;
        }

        $memtally[] = '<a href="member.php?action=viewpro&amp;member='.recodeOut($online['username']).'">'.$pre.''.$online['username'].''.$suff.'</a>';
        $num++;
    }

    if (X_ADMIN || $show_inv_key === true) {
        $hidden = ' - <strike>'.$lang['texthmem'].'</strike>';
    } else {
        $hidden = '';
    }

    $memtally = implode(', ', $memtally);
    if ($memtally == '') {
        $memtally = '&nbsp;';
    }

    $whosonlinetoday = '';
    if ($SETTINGS['onlinetoday_status'] == 'on') {
        $datecut = $onlinetime - (3600 * 24);
        if (X_ADMIN) {
            $query = $db->query("SELECT username, status FROM ".X_PREFIX."members WHERE lastvisit >= '$datecut' ORDER BY lastvisit DESC");
        } else {
            $query = $db->query("SELECT username, status FROM ".X_PREFIX."members WHERE lastvisit >= '$datecut' AND invisible!=1 ORDER BY lastvisit DESC");
        }

        $todaymembersnum = $db->num_rows($query);
        $todaymembers = array();
        $pre = $suff = '';
        $x = 0;
        while($memberstoday = $db->fetch_array($query)) {
            if ($x <= $onlinetodaycount) {
                $pre = '<span class="status_'.str_replace(' ', '_', $memberstoday['status']).'">';
                $suff = '</span>';
                $todaymembers[] = '<a href="member.php?action=viewpro&amp;member='.recodeOut($memberstoday['username']).'">'.$pre.''.$memberstoday['username'].''.$suff.'</a>';
                $x++;
            } else {
                continue;
            }
        }
        $todaymembers = implode(', ', $todaymembers);
        $db->free_result($query);

        if ($todaymembersnum == 1) {
            $memontoday = $todaymembersnum.$lang['textmembertoday'];
        } else {
            $memontoday = $todaymembersnum.$lang['textmemberstoday'];
        }
        eval('$whosonlinetoday = "'.template('index_whosonline_today').'";');
    }
    eval('$whosonline = "'.template('index_whosonline').'";');
}

$moodmems_list = '';
$SETTINGS['portalrmods'] = intval($SETTINGS['portalrmods']);
$sql = $db->query("SELECT username, mood FROM ".X_PREFIX."members WHERE mood != 'No Mood' AND mood != '' AND mood != 'Not Defined' ORDER BY RAND() LIMIT 0, $SETTINGS[portalrmods]");
while($moodmems = $db->fetch_array($sql)) {
    if ($moodmems['mood'] != '') {
        $moodmems['mood'] = postify($moodmems['mood'], 'no', 'no', 'yes', 'no', 'yes', 'no', true, 'yes');
    } else {
        $moodmems['mood'] = $lang['nomoodtext'];
    }
    $moodmems_list .= '<tr><td class="mediumtxt" bgcolor="'.$altbg2.'"><a href="member.php?action=viewpro&amp;member='.recodeOut($moodmems['username']).'">'.$moodmems['username'].'</a></td><td class="mediumtxt" bgcolor="'.$altbg1.'">'.$moodmems['mood'].'</td></tr>';
    $moodmems_list .= "\n";
}
$db->free_result($sql);

$sql = $db->query("SELECT p.*, t.* FROM ".X_PREFIX."portal_templates p LEFT JOIN ".X_PREFIX."templates t ON t.name=p.name WHERE p.status='on' ORDER BY p.displayorder ASC LIMIT 0, 30");
while($block = $db->fetch_array($sql)) {
    if ($block['direction'] == 'center' && $block['status'] == 'on' && $block['displayorder'] == $block['displayorder']) {
        eval('$center[] = "'.template($block['name']).'";');
    } else if ($block['direction'] == 'right' && $block['status'] == 'on' && $block['displayorder'] == $block['displayorder']) {
        eval('$right[] = "'.template($block['name']).'";');
    } else if ($block['direction'] == 'left' && $block['status'] == 'on' && $block['displayorder'] == $block['displayorder']) {
        eval('$left[] = "'.template($block['name']).'";');
    }
}
$centerblock = implode('<br />', $center);
$rightblock = implode('<br />', $right);
$leftblock = implode('<br />', $left);
$db->free_result($sql);

eval('echo stripslashes("'.template('portal_home').'");');

end_time();
eval('echo "'.template('footer').'";');
?>