<?php
/**
 * Title: Contact Us
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'contact.php');

require 'header.php';

loadtemplates(
'contactus',
'contactus_captcha',
'misc_feature_notavailable'
);

nav($lang['contactus']);

smcwcache();

eval('$css = "'.template('css').'";');
eval('echo "'.template('header').'";');

if ($SETTINGS['contactus_status'] == 'off') {
    eval('echo "'.template('misc_feature_notavailable').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

if (noSubmit('contactsubmit')) {
    $self['username'] = (isset($self['username']) ? $self['username'] : '');
    $self['email'] = (isset($self['email']) ? $self['email'] : '');
    $captchacheck = '';
    if (X_GUEST && $SETTINGS['captcha_status'] == 'on' && !DEBUG) {
        require ROOT.'include/captcha.inc.php';
        $Captcha = new Captcha(250, 50);
        if ($Captcha->bCompatible !== false) {
            $imghash = $Captcha->GenerateCode();
            if ($SETTINGS['captcha_code_casesensitive'] == 'off') {
                $lang['captchacaseon'] = '';
            }
            eval('$captchacheck = "'.template('contactus_captcha').'";');
        }
    }
    eval('echo "'.template('contactus').'";');
}

if (onSubmit('contactsubmit')) {
    $name = trim(stripslashes($_POST['name']));
    $email = trim(stripslashes($_POST['email']));
    $subject = trim(stripslashes($_POST['subject']));
    $message = trim(stripslashes($_POST['message']));

    if ($name === '' || $email === '' || $subject === '' || $message === '') {
        error($lang['contactempty'], false, '', '', 'contact.php', true, false, true);
    }

    if (X_GUEST && $SETTINGS['captcha_status'] == 'on' && !DEBUG) {
        require ROOT.'include/captcha.inc.php';
        $Captcha = new Captcha(250, 50);
        if ($Captcha->bCompatible !== false) {
            $imghash = postedVar('imghash', '', FALSE, TRUE);
            $imgcode = postedVar('imgcode', '', FALSE, FALSE);
            if ($Captcha->ValidateCode($imgcode, $imghash) !== true) {
                error($lang['captchaimageinvalid'], false, '', '', 'contact.php', true, false, true);
            }
        }
    }

    if (!isValidEmail($email)) {
        error($lang['bademail'], false, '', '', 'contact.php', true, false, true);
    }

    if (X_GUEST) {
        $xmbuser = 'Guest';
    }

    $headers = array();
    $headers[] = "From: $name <$email>";
    $headers[] = 'X-Mailer: PHP';
    $headers[] = 'X-AntiAbuse: Board servername - '.$SETTINGS['bbname'];
    $headers[] = 'X-AntiAbuse: Username - '.$xmbuser;
    $headers[] = 'Content-Type: text/plain; charset='.$charset;
    $headers = implode("\r\n", $headers);

    altMail($SETTINGS['adminemail'], $subject, $message, $headers);

    message($lang['contactsubmitted'], false, '', '', 'index.php', true, false, true);
}

end_time();
eval('echo "'.template('footer').'";');
?>