<?php
/**
 * eXtreme Message Board
 * XMB 1.9.8 Engage Final SP4
 *
 * SP3 Developed By The XMB Group
 * SP4 Maintained By John Briggs
 * Copyright (c) 2001-2008, The XMB Group
 * Copyright (c) 2009, John Briggs
 * http://www.xmbforum.com
 * http://www.xmbgarage.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/


if (!defined('IN_CODE')) {
    exit ("Not allowed to run this file directly.");
}

class Attachments {
    var $attachments;

    function get_attachments($tid) {
        global $db, $start_limit, $ppp;

        $pids = array();
        $q = $db->query("SELECT pid FROM ".X_PREFIX."posts WHERE tid='$tid' ORDER BY pid LIMIT $start_limit, $ppp");
        while($row = $db->fetch_array($q)) {
            $pids[] = $row['pid'];
        }
        $pids = "'".implode("', '", $pids)."'";

        $this->attachments = array();
        $q = $db->query("SELECT * FROM ".X_PREFIX."attachments WHERE pid IN ($pids)");
        while($row = $db->fetch_array($q)) {
            $this->attachments[] = $row;
        }
        $db->free_result($q);
    }

    function format_attach($bytes) {
        if ($bytes >= 1073741824) {
            $bytes = round($bytes / 1073741824 * 100) / 100 . "gb";
        } else if ($bytes >= 1048576) {
            $bytes = round($bytes / 1048576 * 100) / 100 . "mb";
        } else if ($bytes >= 1024) {
            $bytes = round($bytes / 1024 * 100) / 100 . "kb";
        } else {
            $bytes = $bytes . "b";
        }
        return $bytes;
    }

    function upgrade_attachment(& $attach) {
        global $db;

        $aid = intval($attach['aid']);
        if ($aid == 0 || ini_get('safe_mode')) {
            return false;
        }

        $tempfn = tempnam("","");
        $temp = fopen($tempfn, "w");
        fwrite($temp, $attach['attachment']);
        fclose($temp);
        $exsize = getimagesize($tempfn);
        unlink($tempfn);

        $attach['fileheight'] = intval($exsize[1]);
        $attach['filewidth'] = intval($exsize[0]);

        $db->query("UPDATE ".X_PREFIX."attachments SET fileheight=".$attach['fileheight'].", filewidth=".$attach['filewidth']." WHERE aid=".$aid);
    }

    function get_post_attachments($pid) {
        global $SETTINGS, $lang, $post, $forum, $tid, $n_height, $n_width, $attach;
        global $THEME, $bordercolor, $borderwidth, $tablespace, $cattext, $altbg1, $altbg2, $tablewidth;

        reset($this->attachments);
        $retval = '';
        foreach($this->attachments as $attach) {
            if ((intval($attach['fileheight']) == 0 || intval($attach['filewidth']) == 0) && strpos($attach['filetype'], 'image') !== false) {
                $this->upgrade_attachment($attach);
            }
            if ($attach['pid'] == $pid) {
                $post['filename'] = htmlspecialchars($attach['filename']);
                if ($attach['filename'] != '' && isset($forum['attachstatus']) && $forum['attachstatus'] != 'off') {
                    $attach['filename'] = checkInput($attach['filename'], 'no', 'no', '', false);
                    $attach['filetype'] = checkInput($attach['filetype'], 'no', 'no', '', false);
                    $extention = strtolower(substr(strrchr($post['filename'],'.'),1));
                    $attachsize = $this->format_attach($attach['filesize']);
                    $downloadcount = $attach['downloads'];
                    if ($downloadcount == '') {
                        $downloadcount = 0;
                    }

                    if ($SETTINGS['attachimgpost'] == 'on' && ($extention == 'jpg' || $extention == 'jpeg' || $extention == 'jpe' || $extention == 'gif' || $extention == 'png' || $extention == 'bmp')) {
                        if ($attach['fileheight'] != '' && $attach['filewidth'] != '') {
                            $SETTINGS['max_attheight'] = (int) $SETTINGS['max_attheight'];
                            $SETTINGS['max_attwidth'] = (int) $SETTINGS['max_attwidth'];
                            $h_ratio = $SETTINGS['max_attheight'] / $attach['fileheight'];
                            $w_ratio = $SETTINGS['max_attwidth'] / $attach['filewidth'];
                            if (($attach['fileheight'] <= $SETTINGS['max_attheight']) && ($attach['filewidth'] <= $SETTINGS['max_attwidth'])) {
                                $n_height = $attach['fileheight'];
                                $n_width = $attach['filewidth'];
                            } else if (($w_ratio * $attach['fileheight']) < $SETTINGS['max_attheight']) {
                                $n_height = ceil($w_ratio * $attach['fileheight']);
                                $n_width = $SETTINGS['max_attwidth'];
                            } else {
                                $n_height = $SETTINGS['max_attheight'];
                                $n_width = ceil($h_ratio * $attach['filewidth']);
                            }
                        }
                        eval("\$post['message'] .= \"".template('viewthread_post_attachmentimage')."\";");
                    } else {
                        eval("\$post['message'] .= \"".template('viewthread_post_attachment')."\";");
                    }
                }
            }
        }
    }
}
?>